﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Language>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove(); refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    string actionUrl = Url.Action("CreateLanguage", "ManageSettings");
    if (!string.IsNullOrEmpty(Model.LanguageCode))
        actionUrl = Url.Action("UpdateLanguage", "ManageSettings", new RouteValueDictionary { { "languageCode", Model.LanguageCode } }); 

%>
<form action="<%=actionUrl %>" method="post" class="nyroModal tn-helper-reset" id="LanguageForm">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%if (!string.IsNullOrEmpty(Model.LanguageCode)) Response.Write("修改语言"); else Response.Write("添加语言");%>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            区域/语言编码
        </label>
        <% if (!string.IsNullOrEmpty(Model.LanguageCode))
           {%>
        <input id="languageCode_readonly" type="text" class="tn-textbox tn-input-long tn-border-gray"
            readonly="readonly" name="languageCode" value="<%=Model.LanguageCode %>" />
        <%}
           else
           { %>
        <input id="languageCode" type="text" class="tn-textbox tn-input-long tn-border-gray"
            name="languageCode" value="<%=Model.LanguageCode %>" />
        <%} %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            本地化名称
        </label>
        <input id="nativeName" type="text" class="tn-textbox tn-input-long tn-border-gray"
            name="nativeName" value="<%=Model.NativeName %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %>
        </label>
        <input name="isEnabled" type="radio" value="true" <%  if (Model.IsEnabled) Response.Write("checked=\"checked\""); %> />是
        &nbsp;<input name="isEnabled" type="radio" value="false" <%  if (!Model.IsEnabled) Response.Write("checked=\"true\""); %> />否
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
        <input type="button" id="Button1" value="<%=GetResourceString("Button_Cancel") %>"
            onclick="$.nyroModalRemove();return false;" />
    </div>
    
</div>
</form>

