﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }


    if (ViewData["PointRole"] != null)
    {
        UserPointItemRole ur = ViewData["PointRole"] as UserPointItemRole;
%>
<form class="nyroModal" action="<%=Url.Action("Control_UpdatePoints", "ManageSettings",new{ ItemKey = ur.ItemKey })%>"
method="post" id="PointForm" name="PointForm">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        修改积分<span class="tn-text-note">（请修改以下信息！）</span>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            操作：</label><%=ur.ItemName %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Enum_UserPointCategory_BasicPoint") %></label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="BasicPoints"
            id="BasicPoints" value="<%=ur.BasicPoints %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            声望：
        </label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=ur.ReportPoints %>"
            id="ReportPoints" name="ReportPoints" />
    </div>
 <%--   <div class="tn-form-row">
        <label class="tn-form-label">
            信誉积分：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=ur.CreditPoints %>"
            id="CreditPoints" name="CreditPoints" />
    </div>--%>
    <div class="tn-form-row">
        <label class="tn-form-label">
           <%=GetResourceString("Enum_UserPointCategory_TradePoint")%></label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="TradePoints"
            id="TradePoints" value="<%=ur.TradePoints %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Enum_UserPointCategory_BasicPoint") %>日最大限额：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="BasicPointQuota"
            value="<%=ur.BasicPointQuota %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            声望日最大积分：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="ReportPointQuota"
            value="<%=ur.ReportPointQuota %>" />
    </div>
<%--    <div class="tn-form-row">
        <label class="tn-form-label">
            信誉积分日最大限额：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="CreditPointQuota"
            value="<%=ur.CreditPointQuota %>" />
    </div>--%>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Enum_UserPointCategory_TradePoint")%>日最大限额：</label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="TradePointQuota"
            value="<%=ur.TradePointQuota %>" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
        <input type="button" id="Button_Cancel" value="<%=GetResourceString("Button_Cancel") %>"
            onclick="$.nyroModalRemove();return false;" />
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#PointForm").validate({
            rules: {
                BasicPoints: { required: true, number: true },
                ReportPoints: { required: true, number: true },
                CreditPoints: { required: true, number: true },
                TradePoints: { required: true, number: true }
            },
            messages: {
                BasicPoints: { required: '请填写<%=GetResourceString("Enum_UserPointCategory_BasicPoint") %>', number: "请输入非负整数" },
                ReportPoints: { required: "请填写声誉积分", number: "请输入非负整数" },
                CreditPoints: { required: "请填写信誉积分", number: "请输入非负整数" },
                TradePoints: { required: '请填写<%=GetResourceString("Enum_UserPointCategory_TradePoint")%>', number: "请输入非负整数" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#PointForm").valid()) {
                return false;
            }
        });
    }); 
</script>

<%}%>
