﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PresentArea>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    bool isCanAssignOwner = false;
    if (PresentAreas.GetPresentArea(Model.PresentAreaID, false) != null)
        isCanAssignOwner = PresentAreas.GetPresentArea(Model.PresentAreaID, false).CanAssignOwner;

%>
<form class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("UpdatePresentArea", "ManageSettings", new RouteValueDictionary { { "presentAreaID",Model.PresentAreaID } })%>"
method="post" id="PresentAreaForm">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        编辑表现区域</h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            表现区域ID：</label><%=Model.PresentAreaID %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            名称：</label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="Keyword" value="<%=Model.Name %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            描述：
        </label>
        <input type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=Model.Description%>"
            name="Description" />
    </div>
    <%if (isCanAssignOwner)
      { %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            启用皮肤：</label>
        <div class="tn-input-multiple">
            <input id="yes" type="radio" class="tn-radiobutton" value="true" name="enableThemes"
                <%if (Model.EnableThemes ==true){ Response.Write("checked=\"checked\""); } %>>
            <label for="yes">
                启用</label>
            <input id="no" type="radio" class="tn-radiobutton" value="false" name="enableThemes"
                <%if (Model.EnableThemes ==false){ Response.Write("checked=\"checked\""); } %>>
            <label for="no">
                不启用</label>
        </div>
    </div>
    <%} %>
    <div class="tn-form-row">
        <label class="tn-form-label">
            默认皮肤：</label>
        <%IList<Theme> listTheme = ViewData["themes"] as IList<Theme>; %>
        <select id="theme" class="tn-dropdownlist" name="theme">
            <%
                foreach (Theme theme in listTheme)
                {
                    if (theme.DirectoryName == Model.DefaultTheme)
                        Response.Write(string.Format("<option value=\"{0}\" selected=\"selected\">{0}</option>", theme.DirectoryName));
                    else
                        Response.Write(string.Format("<option value=\"{0}\">{0}</option>", theme.DirectoryName));
                }
            %>
        </select>
    </div>
<div class="tn-form-row">
    <label class="tn-form-label">
        默认外观：</label>
    <%IList<ThemeAppearance> listAppearance = ViewData.Get<IList<ThemeAppearance>>("appearances"); %>
    <select class="tn-dropdownlist" id="appearance" name="appearance">
        <%
            foreach (ThemeAppearance appearance in listAppearance)
            {
                if (appearance.DirectoryName == Model.DefaultAppearance)
                    Response.Write(string.Format("<option value=\"{0}\" selected=\"selected\">{1}</option>", appearance.DirectoryName, appearance.Title));
                else
                    Response.Write(string.Format("<option value=\"{0}\">{1}</option>", appearance.DirectoryName, appearance.Title));
            }
        %>
    </select>
</div>
<div class="tn-form-row">
    <label class="tn-form-label">
        皮肤文件位置：</label>
    <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="ThemeLocation"
        value="<%=Model.ThemeLocation %>" />
</div>
<div class="tn-form-row">
    <label class="tn-form-label">
        Widget文件位置：</label>
    <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="WidgetLocation"
        value="<%=Model.WidgetLocation %>" />
</div>
<div class="tn-form-row tn-form-row-button">
    <label class="tn-form-label">
    </label>
    <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
    <input type="button" id="Button_Cancel" value="<%=GetResourceString("Button_Cancel") %>"
        onclick="$.nyroModalRemove();return false;" />
</div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#PresentAreaForm").validate({
            rules: {
                Name: { required: true },
                Description: { required: true },
                ThemeLocation: { required: true },
                WidgetLocation: { required: true }
            },
            messages: {
                Name: { required: "请填写名称" },
                Description: { required: "请填写描述" },
                ThemeLocation: { required: "请填写皮肤文件位置" },
                WidgetLocation: { required: "请填写Widget文件位置" }
            }
        });
        $("#theme").change(function() {
            $.getJSON('<%=SPBUrlHelper.Action("GetThemeAppearances","ManageSettings",new RouteValueDictionary{{"presentAreaID",Model.PresentAreaID}}) %>', { themeName: $(this).val() }, function(data) {
                $("#appearance").empty();
                $(data).each(function() {
                    $("#appearance").append("<option value=\"" + this.value + "\">" + this.name + "</option>");
                });
            });
        });

        $("#saveButton").click(function() {
            if (!$("#PresentAreaForm").valid()) {
                return false;
            }
        });
    }); 
</script>

