﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<School>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove(); refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }
    string actionUrl = Url.Action("CreateSchool", "ManageSettings");
    if (Model.SchoolID > 0)
        actionUrl = Url.Action("UpdateSchool", "ManageSettings", new RouteValueDictionary { { "schoolID", Model.SchoolID } }); 

%>
<form action="<%=actionUrl %>" method="post" class="nyroModal tn-helper-reset" id="SchoolForm">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%if (Model.SchoolID > 0) Response.Write("修改学校"); else Response.Write("添加学校");%>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            学校名称：</label>
        <input id="SchoolName" type="text" class="tn-textbox tn-input-long tn-border-gray"
            name="SchoolName" value="<%=Model.SchoolName %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            所在地区：</label>
        <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("schoolAreaCode", string.Empty, Model.AreaCode, 3, "tn-dropdownlist"));%>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            学校类型：</label>
        <select name="manageSchoolType" id="manageSchoolType" class="tn-dropdownlist">
            <option <% if (Model.SchoolType ==SchoolTypes.University) Response.Write("selected=\"selected\""); %>
                value="<% =(int)(SchoolTypes.University)%>">大学</option>
            <option <% if (Model.SchoolType ==SchoolTypes.SeniorHighSchool) Response.Write("selected=\"selected\""); %>
                value="<% =(int)(SchoolTypes.SeniorHighSchool)%>">高中</option>
            <option <% if (Model.SchoolType ==SchoolTypes.JuniorHighSchool) Response.Write("selected=\"selected\""); %>
                value="<% =(int)(SchoolTypes.JuniorHighSchool)%>">初中</option>
            <option <% if (Model.SchoolType ==SchoolTypes.GradeSchool) Response.Write("selected=\"selected\""); %>
                value="<% =(int)(SchoolTypes.GradeSchool)%>">小学</option>
        </select>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            排序序号：</label>
        <input id="DisplayOrder" type="text" class="tn-textbox tn-input-long tn-border-gray"
            name="DisplayOrder" value="<%=Model.DisplayOrder %>" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
        <input type="button" id="Button1" value="<%=GetResourceString("Button_Cancel") %>"
            onclick="$.nyroModalRemove();return false;" />
    </div>
</div>
<%--<table class="commonFormArea" cellspacing="1">
    <tr>
        <td class="commonFormFieldName">
            学校名称：
        </td>
        <td class="commonFormField">
            <input id="SchoolName" type="text" class="tn-textbox tn-input-long tn-border-gray" name="SchoolName" value="<%=Model.SchoolName %>" />
        </td>
    </tr>
    <tr>
        <td class="commonFormFieldName">
            所在地区：
        </td>
        <td class="commonFormField">
            <span id="schoolAreaCodeSpan">
                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("schoolAreaCode", string.Empty, Model.AreaCode, 3, "dropDownList"));%></span>
        </td>
    </tr>
    <tr>
        <td class="commonFormFieldName">
            学校类型：
        </td>
        <td class="commonFormField">
            <select name="manageSchoolType" id="manageSchoolType" class="tn-dropdownlist">
                <option <% if (Model.SchoolType ==SchoolTypes.University) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.University)%>">大学</option>
                <option <% if (Model.SchoolType ==SchoolTypes.SeniorHighSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.SeniorHighSchool)%>">高中</option>
                <option <% if (Model.SchoolType ==SchoolTypes.JuniorHighSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.JuniorHighSchool)%>">初中</option>
                <option <% if (Model.SchoolType ==SchoolTypes.GradeSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.GradeSchool)%>">小学</option>
            </select>
        </td>
    </tr>
    <tr>
        <td class="commonFormFieldName">
            排序序号：
        </td>
        <td class="commonFormField">
            <input id="Text1" type="text" class="tn-textbox tn-input-long tn-border-gray" name="DisplayOrder" value="<%=Model.DisplayOrder %>" />
        </td>
    </tr>
    <tr>
        <td class="commonFormFieldName">
        </td>
        <td class="commonFormField">
            <input type="submit"  id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
            <input type="button"  id="Button1" value="<%=GetResourceString("Button_Cancel") %>" onclick="$.nyroModalRemove();return false;" />
        </td>
    </tr>
</table>--%>
</form>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#schoolType", $("#SchoolForm")).val("<%=(int)Model.SchoolType %>");
        $("#SchoolForm").validate({
            rules: {
                SchoolName: { required: true },
                DisplayOrder: { required: true, digits: true }
            },
            messages: {
                SchoolName: { required: "请填写学校名称" },
                DisplayOrder: { required: "请填写排序序号", digits: "请输入非负整数" }
            }
        });

        $("#saveButton").click(function() {
            if (!$("#SchoolForm").valid()) {
                return false;
            }
        });
    });  
</script>

