﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Dictionary<int, CodeItem>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        else
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        TempData["StatusMessageType"] = null;
    }

    string codeSetCode = null;
    if (ViewData["codeSetCode"] != null)
        codeSetCode = ViewData.GetString("codeSetCode");

    Dictionary<string, CodeSet> codeSets = CodeSets.GetCodeSets(); 
%>
 <div class="tn-form-box tn-border-gray tn-border-bottom">
     <table>
        <tr>
            <th>
                筛选：
            </th>
            <td>
                <select name="seclectDataDict" id="seclectDataDict" class="tn-dropdownlist">
                        <%if (codeSets != null)
                          {
                              foreach (string code in codeSets.Keys)
                              {%>
                        <option value="<% =code%>">
                            <%=codeSets[code].Name%></option>
                        <% }
              } %>
                    </select>
               
            </td>
        </tr>
    </table>
</div>
<div class="tn-tabs tn-widget" id="ManageDataDictionaryTable">
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
     
            <form id="ManageDataDictionary" action="<%=SPBUrlHelper.Action("ManageDataDictionary", "ManageSettings",new RouteValueDictionary{{"codeSetCode",ViewData.GetString("codeSetCode")}})%>"
            method="post">
        
            <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
         <%=SPBHtmlHelper.Instance().LinkButton("addedit", "添加代码项", SPBUrlHelper.Action("Control_AddCodeItem", "ManageSettings", new RouteValueDictionary { { "codeSetCode", ViewData.GetString("codeSetCode") } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                           
                            <%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                                    new RouteValueDictionary { { "onclick", "if (confirm('确实删除选中的代码项吗？')) { $('#ManageDataDictionary').attr('action','" + SPBUrlHelper.Action("DeleteCodeItems", "ManageSettings", new RouteValueDictionary { { "codeSetCode", ViewData.GetString("codeSetCode") } }) 
                                + "');$('#ManageDataDictionary').submit(); return false; } else { return false; } ;" }, { "title", "把选中的博客通过审核" } }, null)%>

         
         </div>
         </div>
            
            
            <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-width-check">
                        <input type="checkbox" onclick="checkAll(this,'codeItemsBoxGroup')" />
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        代码项ID
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        代码名称
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        排序依据
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        操作
                    </th>
                </tr>
                <%if (Model != null)
                  {
                      foreach (var item in Model)
                      {%>
                <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <input type="checkbox" name="codeItemsBoxGroup" value="<%=item.Key%>" />
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=item.Key%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=item.Value.Name%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=item.Value.DisplayOrder%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom">
                        <a class="nyroModal" href="<%=SPBUrlHelper.Action("Control_EditCodeItem", "ManageSettings",new RouteValueDictionary{{"codeSetCode",item.Value.CodeSetCode},{"ItemID",item.Key}}) %>">
                            编辑</a> <a href="javascript:;" onclick="if (confirm('确认要删除这个代码项吗？')) $('#ManageDataDictionaryTable').parent().load('<%=SPBUrlHelper.Action("DeleteCodeItem", "ManageSettings", new RouteValueDictionary{{"codeSetCode",item.Value.CodeSetCode},{"ItemID",item.Key}})%>');"
                                >删除</a>
                    </td>
                </tr>
                <%}
          }%>
            </table>
            </form>
           

            <script type="text/javascript">
                $(document).ready(function() {
                    $("#seclectDataDict").val("<%=codeSetCode %>");
                    $("#seclectDataDict").change(function() {
                    $('#ManageRecommendedItemsDiv').load('<%=SPBUrlHelper.Action("Control_ManageDataDictionary", "ManageSettings")%>', { codeSetCode: $("#seclectDataDict").attr("value") });
                    });
                    $('a.nyroModal,#addedit').nyroModal({
                        resizeable: true,
                        endRemove: function(elts, settings) {
                            $('#ManageRecommendedItemsDiv').load('<%=SPBUrlHelper.Action("Control_ManageDataDictionary", "ManageSettings",new RouteValueDictionary{{"codeSetCode",codeSetCode}})%>');
                        }
                    });
                });
            </script>
    </div>
</div>
