﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int appID = int.Parse(ViewData["appID"].ToString());
    int type = int.Parse(ViewData["type"].ToString());

    List<PermissionItem> ListPItem = null;
    List<Role> ListRole = null;
    List<UserRank> ListRank = null;
    Dictionary<int, PermissionCollection> DicPerCollection = null;
    if (ViewData["ListPItem"] != null)
    {
        ListPItem = ViewData["ListPItem"] as List<PermissionItem>;
        if (type == 0)
        {
            ListPItem = (from lp in ListPItem
                         where lp.EnabledInUserRole == true
                         select new PermissionItem
                         {
                             ItemKey = lp.ItemKey,
                             ItemName = lp.ItemName,
                         }).ToList();
        }
        else
        {
            ListPItem = (from lp in ListPItem
                         where lp.EnabledInUserRank == true
                         select new PermissionItem
                         {
                             ItemKey = lp.ItemKey,
                             ItemName = lp.ItemName,
                         }).ToList();
        }
    }
    if (ViewData["ListRole"] != null)
    {
        ListRole = ViewData["ListRole"] as List<Role>;
    }
    if (ViewData["DicPerCollection"] != null)
    {
        DicPerCollection = ViewData["DicPerCollection"] as Dictionary<int, PermissionCollection>;
    }
    if (ViewData["ListRank"] != null)
    {
        ListRank = ViewData["ListRank"] as List<UserRank>;
    }           
%>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <%
            Dictionary<int, Application> dic = null;
            if (ViewData["DicApplication"] != null)
            {
                dic = ViewData["DicApplication"] as Dictionary<int, Application>;
            }
            if (dic != null)
            {
                string str = "<li {0}><a href=\"{1}\" target=\"_self\"><span>{2}</span></a></li>";
                string strUrl = "";
                foreach (var item in dic.Values)
                {
                    string strClass = string.Empty;
                    if (item.ApplicationID == appID)
                        strClass = "class=\"tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected\"";
                    else
                        strClass = "class=\"tn-widget-content tn-border-gray tn-border-trl\"";
                    strUrl = Url.Action("PermissionSettings", "ManageSettings", new { AppID = item.ApplicationID });
                    Response.Write(string.Format(str, strClass, strUrl, item.GetMultilingualApplicationName(CurrentUserLanguage)));
                }
            }
        %>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
        <%
            if (type == 1)
            {
                Response.Write("<form id=\"ManageRankForm\" method=\"post\" action=\"" + Url.Action("Control_SetRanksPermissionSettings", "ManageSettings", new { appID = appID }) + "\">");
        %>

        <script type="text/javascript">
            $(document).ready(function() {
                $('#ManageRankForm').submit(function(e) {
                    e.preventDefault();
                    $('#ManageRankForm').nyroModalManual({
                        resizeable: true
                    });
                    return false;
                });
            });
        </script>

        <%} %>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                查看： <span class="tn-action <%if (type == 0) Response.Write(" tn-selected"); %>"><a
                    class="tn-action-text" href="<%=SPBUrlHelper.Action("PermissionSettings", "ManageSettings", new RouteValueDictionary { { "appID", appID }, { "type", 0 } })%>">
                    按角色设置</a></span> <span class="tn-action <%if (type == 1) Response.Write(" tn-selected"); %>">
                        <a class="tn-action-text" href="<%=SPBUrlHelper.Action("PermissionSettings", "ManageSettings", new RouteValueDictionary { { "appID", appID }, { "type", 1 } })%>">
                            按级别设置</a></span>
                <%if (type == 1)
                  {
                %>
                <%=SPBHtmlHelper.Instance().LinkButton("Button_Set", GetResourceString("Button_Set"), "javascripr:;", ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Set, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "$('#ManageRankForm').submit(); return false;" }, { "title", "批量设置选定的级别" } }, null)%>
                <%} %>
            </div>
        </div>
        <%if (type == 0)
          {%>
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    角色
                </th>
                <%
                    if (ListPItem != null)
                    {
                        string strTH = "<th class=\"tn-border-gray tn-border-bottom tn-text-note\">{0}</th>";
                        foreach (var item in ListPItem)
                        {
                            Response.Write(string.Format(strTH, item.ItemName));
                        }
                    }
                %>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    编辑
                </th>
            </tr>
            <%
                if (ListRole != null)
                {
                    foreach (var item in ListRole)
                    {
            %>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=item.FriendlyRoleName %>
                </td>
                <%
                    if (ListPItem != null && DicPerCollection != null)
                    {
                        string strTH = "<td class=\"tn-border-gray tn-border-bottom tn-nowrap\"><img src=\"{0}\" alt=\"{2}\" style=\"border-width: 0px;\" />{1}</td>";

                        foreach (var Pitem in ListPItem)
                        {
                            try
                            {
                                if (item.RoleName == "SystemAdministrator" || item.RoleName == "ContentAdministrator")
                                    Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true_red.gif"), string.Empty, "允许(不可修改)"));
                                else
                                {
                                    if (DicPerCollection[item.RoleID][Pitem.ItemKey].IsLocked)
                                    {
                                        if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                            Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true_red.gif"), string.Empty, "允许(不可修改)"));
                                        else if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.NotSet)
                                            Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">---</td>");
                                        else
                                            Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false_red.gif"), string.Empty, "禁止(不可修改)"));
                                    }
                                    else
                                    {
                                        if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                            Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif"), string.Empty, "允许"));
                                        else if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.NotSet)
                                            Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>");
                                        else
                                            Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif"), string.Empty, "禁止"));
                                    }
                                }
                            }
                            catch
                            { Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>"); }
                        }
                    }
                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%
                        if (item.RoleName != "SystemAdministrator" && item.RoleName != "ContentAdministrator")
                            Response.Write("<a class=\"submit\" href=\"" + Url.Action("Control_SetRolePermissionSettings", "ManageSettings", new { roleID = item.RoleID, appID = appID, RoleName = item.FriendlyRoleName }) + "\" name=\"EditPermission\">编辑</a>");
                    %>
                </td>
            </tr>
            <%
                }
                }
            %>
        </table>
        <div>
            <br />
            图例说明：<img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true_red.gif")%>" />允许(不可修改)&nbsp;&nbsp;&nbsp;&nbsp;
            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false_red.gif")%>" />禁止(不可修改)&nbsp;&nbsp;&nbsp;&nbsp;
            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif") %>" />允许&nbsp;&nbsp;&nbsp;&nbsp;
            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif")%>" />禁止&nbsp;&nbsp;&nbsp;&nbsp;
            --- 无实际意义
        </div>
        <%
            }
          else
          {
        %>
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    级别
                </th>
                <%
                    if (ListPItem != null)
                    {
                        string strTH = "<th class=\"tn-border-gray tn-border-bottom tn-text-note\" >{0}</th>";
                        foreach (var item in ListPItem)
                        {
                            Response.Write(string.Format(strTH, item.ItemName));
                        }
                    }
                %>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    编辑
                </th>
            </tr>
            <%
                if (ListRank != null)
                {
                    foreach (var item in ListRank)
                    {
            %>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                        value="<%=item.Rank %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=item.Rank %>级
                </td>
                <%
                    if (ListPItem != null && DicPerCollection != null)
                    {
                        string strTH = "<td class=\"tn-border-gray tn-border-bottom tn-nowrap\"><img src=\"{0}\" style=\"border-width: 0px;\" alt=\"{2}\" />{1}</td>";

                        foreach (var Pitem in ListPItem)
                        {
                            try
                            {
                                if (DicPerCollection[item.Rank][Pitem.ItemKey].IsLocked)
                                {
                                    if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true_red.gif"), string.Empty, "允许(不可修改)"));
                                    else if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Refuse)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false_red.gif"), string.Empty, "禁止(不可修改)"));
                                    else
                                        Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">---</td>");
                                }
                                else
                                {
                                    if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif"), string.Empty, "允许"));
                                    else if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Refuse)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif"), string.Empty, "禁止"));
                                    else
                                        Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>");
                                }
                            }
                            catch
                            { Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>"); }
                        }
                    }
                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%   
                        Response.Write("<a class=\"submit\" href=\"" + Url.Action("Control_SetRankPermissionSettings", "ManageSettings", new { Rank = item.Rank, appID = appID }) + "\" name=\"EditPermission\">编辑</a>");
                    %>
                </td>
            </tr>
            <%
                }
                }
            %>
        </table>
        <%} %>
        <%
            if (type == 1)
                Response.Write("</form>");
        %>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $(".tn-collapsible-right").collapsibleBox({ switchPosition: "right" });
        $('a[name="EditPermission"]').nyroModal();
    });
               
</script>

