﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["StatusMessageType"] = null;
    }

%>
<form action="<%=Url.Action("Control_UpdateRankPermissionSettings", "ManageSettings",new{Rank=Request.QueryString.GetInt("Rank",0),appID=Request.QueryString.GetInt("appID",ApplicationIDs.Instance().Forum())})%>"
method="post" class="nyroModal">
<div class="tn-form-box">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        详细等级权限设置</h4>
    <p class="tn-text-note">
        你可以设置下列等级的具体权限。</p>
    当前等级为：
    <%=Request.QueryString.GetString("Rank", string.Empty)%>
    级
    <%
        PermissionCollection PerConllection = null;
        List<PermissionItem> ListPItem = null;

        if (ViewData["PerConllection"] != null)
        {
            PerConllection = ViewData["PerConllection"] as PermissionCollection;
        }
        if (ViewData["ListPItem"] != null)
        {
            ListPItem = ViewData["ListPItem"] as List<PermissionItem>;
            ListPItem = (from lp in ListPItem
                         where lp.EnabledInUserRank == true
                         select new PermissionItem
                         {
                             ItemKey = lp.ItemKey,
                             ItemName = lp.ItemName,
                         }).ToList();
        }
    %>
    <br />
    <br />
    <table width="80%" cellpadding="3" cellspacing="5">
        <tr>
            <%
                if (ListPItem != null && PerConllection != null)
                {
                    string strTH = "<td align=\"{0}\">{1}</td>";
                    int i = 1;
                    foreach (var item in ListPItem)
                    {

                        Response.Write(string.Format(strTH, "right", item.ItemName));
                        string strDropDownList = "<select class=\"tn-dropdownlist\" name=\"Rank_{0}\" {4}><option value=\"" + ((int)AllowTypes.Allow).ToString() + "\" {1}>允许</option><option value=\"" + ((int)AllowTypes.Refuse).ToString() + "\" {2}>禁止</option><option value=\"" + ((int)AllowTypes.NotSet).ToString() + "\" {3}>未设置</option></select>";
                        try
                        {
                            string isLocked = string.Empty;
                            if (PerConllection[item.ItemKey].IsLocked)
                                isLocked = "disabled=\"disabled\"";

                            if (PerConllection[item.ItemKey].AllowType == AllowTypes.Allow)
                                Response.Write(string.Format(strTH, "left", string.Format(strDropDownList, item.ItemKey, "selected", string.Empty, string.Empty, isLocked)));
                            else if (PerConllection[item.ItemKey].AllowType == AllowTypes.Refuse)
                                Response.Write(string.Format(strTH, "left", string.Format(strDropDownList, item.ItemKey, string.Empty, "selected", string.Empty, isLocked)));
                            else
                                Response.Write(string.Format(strTH, "left", string.Format(strDropDownList, item.ItemKey, string.Empty, string.Empty, "selected", isLocked)));
                        }
                        catch
                        {
                            Response.Write(string.Format(strTH, "left", string.Format(strDropDownList, item.ItemKey, string.Empty, string.Empty, "selected", string.Empty)));
                        }
                        if (i % 2 == 0)
                            Response.Write("</tr><tr>");
                        i++;
                    }
                }
            %>
        </tr>
        <tr>
            <td>
            </td>
            <td>
                <input name="updateButton" type="submit" id="updateButton" value="更新设置" />&nbsp;
                <input id="Reset1" type="button" value="<%=GetResourceString("Button_Cancel")%>"
                    onclick="$.nyroModalRemove();return false;" />
            </td>
        </tr>
    </table>
    <br />
</div>
</form>
