﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Advertising>" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.ManageAdvertising;
      ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageAdvertisings;
      Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%   
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(string.Format("<script type=\"text/javascript\">window.location.href='{0}'</script>", this.Url.Action("ManageAdvertisings", "Auxiliaries")));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            }
            TempData["StatusMessageType"] = null;
        }
        Advertising advertising = ViewData.Model;
        int applicationID = ApplicationIDs.Instance().User();
         %>
  <div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
      <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="<%=Url.Action("ManageAdvertisings", "Auxiliaries")%>"><span>广告</span></a></li>
      <li><a href="<%=Url.Action("ManageAdvertisingPositions", "Auxiliaries")%>"><span> 广告位</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
      <div class="container">
        <div class="title">
          <%if (advertising.AdvertisingID > 0) { Response.Write("编辑广告"); } else { Response.Write("发布广告"); } %>
        </div>
        <form id="editor" method="post" action="<%=this.Url.Action("CreateUpdateAdvertising", "Auxiliaries", new { advertisingID = advertising.AdvertisingID })%>">
          <div class="tn-form tn-label-right ">
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_AdvertisingName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" id="advertisingName" class="tn-textbox tn-input-medium tn-border-gray" name="advertisingName" value="<%=advertising.AdvertisingName %>" />
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_AdvertisingStartTime",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateFrom", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateFrom, false, "tn-textbox tn-input-medium tn-border-gray")); %>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_AdvertisingEndTime",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
              <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateTo", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateTo, false, "tn-textbox tn-input-medium tn-border-gray")); %>
            </div>
            <div class="tn-form-row tn-textarea-wrap">
              <label class="tn-form-label"><%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %> </label>
              <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isEnabled", advertising.IsEnabled, new RouteValueDictionary { { "Class", "radiobutton" } })%> </div>
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_AdvertisingScript",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
              <textarea id="script" class="tn-textarea tn-input-long tn-border-gray" style="width:600px; height:120px;"  name="script"><%=advertising.Script %></textarea>
              <span style="display:none"></span>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("submitButton", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().Button("Return", GetResourceString("Action_Return"), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "cancle()" } }, null)%> </div>
          <div id="apforjueryload">
            <%Html.RenderAction<AuxiliariesController>(n => n.Control_ListAdvertisingPositions(advertising.AdvertisingID, null));%>
          </div>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("submitButton2", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().Button("Return", GetResourceString("Action_Return"), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "cancle()" } }, null)%> </div>
        </form>
      </div>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
            $("#editor").validate({
                rules: {
                    advertisingName: { required: true },
                    script: { required: true }
                },
                messages: {
                    advertisingName: { required: "必填" },
                    script: { required: "必填" }
                }
            });

            $("#submitButton,#submitButton2").click(function() {
                if (!$("#editor").valid()) {
                    return false;
                }
            });
        });
        function cancle() {
            window.location.href = '<%=Url.Action("ManageAdvertisings", "Auxiliaries") %>';
        }    
    </script>
</asp:content>
