﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Announcement>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
<%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.Announcements;
  ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.EditAnnouncement;
  Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData);
   %>
 </asp:content>
<asp:content runat="server" contentplaceholderid="pageNameContent">

<%=Model.ThreadID>0?"编辑公告":"创建公告" %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="EditAnnouncement"
</asp:content>
<asp:content id="Content2" runat="server" contentplaceholderid="wideContent">


    <%

        if (TempData["statusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            if (statusMessageData.MessageType == StatusMessageType.Success)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["statusMessageData"] = null;
        }
   
    
    %>

  <spb:Script runat="server" ID="iColorPicker" Src="~/Utility/jquery/plugin/iColorPicker-noLink.js"
    SetExpireDays="30" />
   <spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    SetExpireDays="30" />
  <form id="editAnnouncementForm" name="editAnnouncementForm" method="post" action="<%=Url.Action("CreateUpdateAnnouncement", "Auxiliaries", new RouteValueDictionary { { "threadID",Model.ThreadID } }) %>">

    <div class="tn-body">
      <div class="tn-form-box spb-create-notice">
        <table>
          <tbody><tr class="tn-area">
            <th>展示区域：</th>
            <td>   
            <input class="tn-checkbox" value="<%=PresentAreaIDs.Instance().Channel() %>" <% if (Model.PresentAreaIDs.Contains(PresentAreaIDs.Instance().Channel())) Response.Write("checked=\"checked\""); %>
             name="PresentAreaIDs" id="channel" type="checkbox" />                 
              <label for="channel">频道首页</label>
              <input class="tn-checkbox" value="<%=PresentAreaIDs.Instance().UserDomain() %>" <% if (Model.PresentAreaIDs.Contains(PresentAreaIDs.Instance().UserDomain())) Response.Write("checked=\"checked\""); %>
               name="PresentAreaIDs" id="home" type="checkbox" />
              <label for="home">个人中心</label>
              <input class="tn-checkbox" value="<%=PresentAreaIDs.Instance().ClubDomain() %>" <%if (Model.PresentAreaIDs.Contains(PresentAreaIDs.Instance().ClubDomain())) Response.Write("checked=\"checked\""); %> 
               name="PresentAreaIDs" id="club" type="checkbox" />
              <label for="club">群组首页</label>
              <input class="tn-checkbox" value="<%=PresentAreaIDs.Instance().MicroBlogDomain() %>" <%if (Model.PresentAreaIDs.Contains(PresentAreaIDs.Instance().MicroBlogDomain())) Response.Write("checked=\"checked\""); %>  name="PresentAreaIDs" id="microblog" type="checkbox" /> 
              <label for="microblog">微博空间主页</label></td>
          </tr>
          <tr>
            <th>公告主题：</th>
            <td>
            <div class="tn-form-row">
            <label class="tn-form-label">
                字体：
            </label>
            <select class="tn-dropdownlist" id="Fonts" name="Fonts">
                <option selected="selected" style="font-family:宋体" value="宋体">宋体</option>
                <option style="font-family:仿宋_GB2312" value="仿宋_GB2312">仿宋</option>
                <option style="font-family:新宋体" value="新宋体">新宋体</option>
                <option style="font-family:黑体" value="黑体">黑体</option>
                <option style="font-family:楷体_GB2312" value="楷体_GB2312">楷体</option>
            </select>
            
            &nbsp;
            <select class="tn-dropdownlist" id="FontSize" name="FontSize">
                <option  selected="selected" value="">字体大小</option>
                <option style="font-size:8pt" value="8pt">1(8pt)</option>
                <option style="font-size:10pt" value="10pt">2(10pt)</option>
                <option style="font-size:12pt" value="12pt">3(12pt)</option>
                <option style="font-size:14pt" value="14pt">4(14pt)</option>
            </select>
             <label class="tn-form-label">
               加粗：
            </label>
            <input type="checkbox" class="tn-checkbox" id="jiacu" name="jiacu" /> 
            &nbsp;
             <label class="tn-form-label">
                颜色：
            </label>
            <input type="text" readonly="readonly" id="BGColor" name="BGColor" class="tn-textbox tn-input-short tn-border-gray hasDatepicker iColorPicker" />
            </div>            
            </td>
          </tr>
          <tr>
            <th>&nbsp;</th>
            <td>
            <textarea class="tn-textarea tn-input-longest tn-border-gray " style="<%= Model.SubjectStyle %>" rows="" cols="" name="title" id="title"><%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject)%> </textarea>
            <input type="hidden" value="<%= Model.SubjectStyle %>" name="SubjectStyle"  id="SubjectStyle"/>

            </td>
          </tr>
          <tr>
          
           
            
              <th>是否外链：</th>
              <td>
        
              <input id="no" type="radio" class="tn-radiobutton" checked="checked" name="isHyperLink" value="false" onclick="$('#HyperLinkem').hide();  $('#isHyper').hide(); $('#editor').show(); $('#lableforeditor').show();  " />
                          <label class="dt-label" for="no">否</label>
                          <input id="isHyperLink" type="radio" class="tn-radiobutton" name="isHyperLink" value="true" onclick="$('#HyperLinkem').show(); $('#isHyper').show(); $('#editor').hide();$('#lableforeditor').hide(); " />
                          <label class="dt-label" for="isHyperLink">是</label>
                        <em id="HyperLinkem"  > <input style="display:none;"  type="text" class="tn-textbox tn-input-long tn-border-gray" id="isHyper" name="isHyper" value="<%=Model.HyperLinkUrl %>" /></em>
        
           </td>
       
          </tr>
               
          <tr>          
            <th id="lableforeditor">内容：</th>
            <td>
               <div class="tn-form-row tn-editor" id="editor" >
             
              <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", Model.Body, new RouteValueDictionary { { "id", "body" }, { "style", "width:100%;height:270px" } })%> 
             
            </div>            
            </td>
             
          </tr>
        
          <tr>
            <th rowspan="3">公告选项：</th>
            <td>           
            <input class="tn-checkbox"  name="Immediately" id="Immediately" checked="checked" value="true"  type="checkbox"/>         
              <label for="Immediately">立即发布</label>
            
              <span id="ExpiredTime" style="display:none">
              <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("releaseDate", null, null, Model.ReleaseDate, true, "tn-textbox tn-input-medium tn-border-gray"));%>
              </span> 
         </td>
          </tr>
          <tr>
            <td> 
              <label for="autoexpire">过期时间：</label>
               <span id="expire"  > 
              <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("dateExpired", null, null, Model.DateExpired, true, "tn-textbox tn-input-medium tn-border-gray"));%>
              </span>
              </td>
          </tr>
          <tr>
            <td><input class="tn-checkbox" <%if (Model.IsSticky) Response.Write("checked=\"checked\""); %> value="true" name="isSticky" id="isSticky" type="checkbox"/>
              <label for="isSticky">置顶显示</label></td>
          </tr>
          <tr>
            <th>排序序号：</th>
            <td><input class="tn-textbox tn-input-short  tn-border-gray" value="<%=Model.DisplayOrder %>" name="displayOrder" id="displayOrder" type="text"/></td>
          </tr>
          <tr>
            <th>&nbsp;</th>
            <td>
                  <%=SPBHtmlHelper.Instance().SubmitButton("createNewEventButton","发布公告", ButtonSizes.Large, null, null)%>
 <% if (Request.UrlReferrer != null)
    {%>
        <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
        <%} %>              
              
              </td>
          </tr>
        </tbody></table>   
      </div>
    </div>
   </form>

<script type="text/javascript">
    $(document).ready(function () {

      $("#isHyper").watermark("http://").focus();
      $('#HyperLinkem').hide();  $('#isHyper').hide();
        $("#editAnnouncementForm").validate({
            rules: {
                title: { required: true, maxBlength: 500 },
                displayOrder: { digits: true, required: true },
                PresentAreaIDs: { required: true },
                editor:{maxBlength:5000},
                isHyper:{ url:true}
            },
            messages: {
                title: { required: "公告标题不能为空", maxBlength: "公告标题不能超过500字" },
                displayOrder: { digits: "请输入数字", required: "排序序号不能为空" },
                PresentAreaIDs: { required: "展示区域不能为空" },
                 editor:{maxBlength:"公告内容不能超过5000字"},
                isHyper: { url:"请输入正确的URL地址,例如http://c.spacebuilder.cn" }
            }
        });


        $('#Immediately').click(function () {
            if (this.checked ){
                $('#ExpiredTime').hide();
            }
            else {
                $('#ExpiredTime').show();
            }
        });

      
     <% if(Model.IsHyperLink){ %>
        $("#isHyperLink").click();
     <%} %>
     <% if ( Model.ThreadID>0 && Model.ReleaseDate.CompareTo(DateTime.Now)>0){  %>
        $('#Immediately').attr("checked",false);
        $('#ExpiredTime').show();
     <%} %>

    
        $('#Fonts').change(function () {
            $('#title').css('font-family', $(this).val());
            $('#SubjectStyle').val($('#title').attr('style'));
        });
        $('#FontSize').change(function () {
            $('#title').css('font-size', $(this).val());
            $('#SubjectStyle').val($('#title').attr('style'));
        });
        $('#iColorPicker').live("click", function () {
            $('#title').css('color', $("#BGColor").val());
            $('#SubjectStyle').val($('#title').attr('style'));
        });
        $('#jiacu').click(function () {
            if (this.checked) {
                $('#title').css('font-weight', 'bold');
            }
            else
                $('#title').css('font-weight', 'normal');
        });
    });
</script>  
     
</asp:content>
