﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<List<Advertising>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.ManageAdvertising;
    ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageAdvertisings;
    Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ListAdvertisingsOfPosition"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
广告列表
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
   <div class="tn-tabs tn-widget">
<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li><a href="<%=Url.Action("ManageAdvertisings", "Auxiliaries")%>"><span>广告</span></a></li>
        <li><a href="<%=Url.Action("ManageAdvertisingPositions", "Auxiliaries")%>"><span> 广告位</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="#"><span>广告列表</span></a></li>
      </ul>
      <div class="tn-tabs-panel tn-widget-content tn-border-gray">
         <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong><%=string.Format("\"{0}\"下共有{1}个广告",(ViewData["position"] as AdvertisingPosition).Description,ViewData.Model.Count)%></strong></div>
         
         <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 广告名称 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 开始时间 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 结束时间 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 投放数量 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 点击量 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 广告类型 </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%> </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </td>
          </tr>
          <%foreach (var advertising in ViewData.Model)
            {%>
         <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(advertising.AdvertisingName,20) %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateFrom) %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateTo) %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=advertising.UseredPositions %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=advertising.HitTimes %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%switch (advertising.AdvertisingType)
                                                                    {
                                                                        case AdvertisingTypes.Flash:
                                                                            Response.Write("动画");
                                                                            break;
                                                                        case AdvertisingTypes.Image:
                                                                            Response.Write("图片");
                                                                            break;
                                                                        case AdvertisingTypes.Script:
                                                                            Response.Write("脚本");
                                                                            break;
                                                                        default:
                                                                            break;
                                                                    }  %>            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (advertising.IsEnabled)
                                                                    { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                    else
                                                                    { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>    </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=this.Url.Action("EditAdvertising", "Auxiliaries",new{advertisingID=advertising.AdvertisingID})%>"> 编辑</a> </td>
          </tr>
          <%}%>
        </table>
      </div>
    </div>
</asp:content>
