﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<List<AdvertisingPosition>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.ManageAdvertising;
    ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageAdvertisingPositions;
    Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="pageNameContent">
管理广告位
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ManageAdvertisingPositions"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
 
    <div class="tn-tabs tn-widget">
<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl"><a href="<%=Url.Action("ManageAdvertisings", "Auxiliaries")%>"> <span>广告</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="<%=Url.Action("ManageAdvertisingPositions", "Auxiliaries")%>"><span> 广告位</span></a></li>
      </ul>
      <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <div id="container-1">
          <form id="newsForm" method="post">          
             <div class="tn-list-header">
                <div class="tn-toolbar-area tn-helper-clearfix">
               <%=SPBHtmlHelper.Instance().LinkButton("newAdvertisingPosition", "新建广告位置", Url.Action("Control_EditAdvertisingPosition", "Auxiliaries", new { positionCode = "", isCreate = true }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "class", "iconLink icoLinkAdd" } }, null)%>                                                           
               <%=SPBHtmlHelper.Instance().LinkButton("DeleteAdvertisingPositions", "删除广告位置", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, null, null)%>                                                           
             </div>
             </div>
            
             <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                  <input type="checkbox" onclick="checkAll(this,'positionCheckBoxGroup')" />
                  </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 位置编码 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Description")%> </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 广告位图示 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 大小 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 已经使用/最大数量 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 拥有者类型 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 允许后台投放 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <%foreach (var position in ViewData.Model)
                {%>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="positionCheckBoxGroup" value="<%=position.PositionCode %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=position.PositionCode %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(position.Description,20) %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (!string.IsNullOrEmpty(position.ImageUrl))
                                                                        {%>
                   <a target="_blank" type="formData" href="<%=SiteUrls.Instance().AdvertisingPositionImage(position.PositionCode) %>" class="imageForModal" title="<%=StringUtils.Trim(position.Description,300) %>">
                                    查看图示</a>
                  <%}%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%Response.Write(string.Format("{0}*{1}", position.Width, position.Height)); %>
                </td>
                <%if (position.PresentAreaID == PresentAreaIDs.Instance().Channel())
                  { %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%Response.Write(string.Format("<a href=\"{0}\">{1}</a>/{2}", this.Url.Action("ListAdvertisingsOfPosition", "Auxiliaries", new { positionCode = position.PositionCode }), position.UseredAdvertisings, position.Maximum));%>
                </td>
                <%}
                  else
                  { %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"> 无限制 </td>
                <%} %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%
                    if (position.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                        Response.Write("群组广告");
                    else if (position.PresentAreaID == PresentAreaIDs.Instance().Channel())
                        Response.Write("系统广告");
                    else if (position.PresentAreaID == PresentAreaIDs.Instance().UserDomain())
                        Response.Write("用户广告"); %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (position.AllowSystem)
                                                                        { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                        else
                                                                        { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a class="submit editAdvertisingPosition" href="<%=this.Url.Action("Control_EditAdvertisingPosition", "Auxiliaries",new{positionCode =position.PositionCode ,isCreate = false})%>"> 编辑</a> <a  href="<%=this.Url.Action("ListAdvertisingsOfPosition", "Auxiliaries",new{positionCode =position.PositionCode})%>"> 查看广告</a> </td>
              </tr>
              <%}%>
            </table>
          </form>
          <script type="text/javascript">
              $(document).ready(function() {
                  $('#newAdvertisingPosition,.editAdvertisingPosition').nyroModal({
                      resizeable: true,
                      width: 350,
                      height: 500
                  });
                  $(document).ready(function() {
                      $('.imageForModal').nyroModal({
                          resizeable: true
                      });
                  });
                  $("#DeleteAdvertisingPositions").click(function() {
                      if (confirm('确实要删除吗？'))
                          $('#newsForm')
                             .attr('action', '<%=Url.Action("DeleteAdvertisingPositions","Auxiliaries") %>')
                             .submit();

                  });
              });
                    </script>
        </div>
      </div>
    </div>
  
</asp:content>
