﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<Advertising>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.ManageAdvertising;
    ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageAdvertisings;
    Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="pageNameContent">
管理广告
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ManageAdvertisings"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
 
        <div class="tn-tabs tn-widget">

<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="<%=Url.Action("ManageAdvertisings", "Auxiliaries")%>"> <span>广告</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl"><a href="<%=Url.Action("ManageAdvertisingPositions", "Auxiliaries")%>"><span> 广告位</span></a></li>
      </ul>
      <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <div id="container-1">
          <form id="newsForm" method="post">         
            
          <div class="tn-list-header">
             <div class="tn-toolbar-area tn-helper-clearfix">
              <%=SPBHtmlHelper.Instance().LinkButton("EditAdvertising", "新建广告", Url.Action("EditAdvertising", "Auxiliaries"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, null, null)%>                                                           
              <%=SPBHtmlHelper.Instance().LinkButton("DeleteAdvertisings", "删除广告", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "删除选中广告" } }, null)%>                                                           
             </div>
          </div>
            
             <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                  <input type="checkbox" onclick="checkAll(this,'advertisingCheckBoxGroup')" />
                  </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 广告名称 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 开始时间 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 结束时间 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 投放数量 </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%> </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <%foreach (var advertising in ViewData.Model.Records)
                {%>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="advertisingCheckBoxGroup" value="<%=advertising.AdvertisingID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(advertising.AdvertisingName,20) %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateFrom) %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateTo) %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=advertising.UseredPositions %> </td>
                <%--<td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=advertising.DisplayTimes %>
                        </td>--%>
                <%--<td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%switch (advertising.AdvertisingType)
                              {
                                  case AdvertisingTypes.Flash:
                                      Response.Write("动画");
                                      break;
                                  case AdvertisingTypes.Image:
                                      Response.Write("图片");
                                      break;
                                  case AdvertisingTypes.Script:
                                      Response.Write("脚本");
                                      break;
                                  default:
                                      break;
                              }  %>
                        </td>--%>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (advertising.IsEnabled)
                                                                        { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                        else
                                                                        { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a  href="<%=this.Url.Action("EditAdvertising", "Auxiliaries",new{advertisingID=advertising.AdvertisingID})%>"> 编辑</a> </td>
              </tr>
              <%}%>
            </table>
               <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("ManageAdvertisings", "Auxiliaries", new RouteValueDictionary { { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>
          </form>

        </div>
      </div>
    </div>
 <script type="text/javascript">
     $(document).ready(function() {
         $("#DeleteAdvertisings").click(function() {
             if (confirm('确定要删除该广告吗？'))
                 $('#newsForm')
        .attr('action', '<%=Url.Action("DeleteAdvertisings","Auxiliaries") %>')
        .submit();
         });

     }) 
    </script>  
</asp:content>
