﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<Announcement>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
<%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.Announcements;
  ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageAnnouncements;
  Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
        </asp:content>
<asp:content runat="server" contentplaceholderid="pageNameContent">
管理公告
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ManageAnnouncements"
</asp:content>
<asp:content id="Content2" runat="server" contentplaceholderid="wideContent">
  <%       if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
          TempData["StatusMessageType"] = null;
      }

      int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
      int presentAreaID = Request.QueryString.GetInt("presentAreaID", -1);
      
    %>
  <div class="tn-body">  
  <div class="tn-form-box tn-border-gray tn-border-bottom">
  <form id="searchForm" method="post" action="<%=Url.Action("SearchAnnouncement","Auxiliaries",new {presentAresID=presentAreaID }) %>">

        <table>
          <tbody><tr>
            <th>搜索关键字：</th>
            <td><input class="tn-textbox tn-input-medium tn-border-gray" name="searchKeywords" id="searchKeywords" value="<%=Request.QueryString.GetString("searchKeywords", string.Empty) %>" type="text"/></td>            
            <td><button class="tn-push-button" id="searchButton" type="submit">搜索</button></td>
          </tr>
        </tbody></table>
   </form>
  </div>   
  <div class="tn-tabs tn-widget">
  
        <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(presentAreaID== -1) Response.Write(" tn-tabs-selected"); %>"><a href="<%=Url.Action("ManageAnnouncements", "Auxiliaries", new { presentAreaID=-1,searchKeywords=Request.QueryString.GetString("searchKeywords", string.Empty) })%>"><span>全部公告</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(presentAreaID== PresentAreaIDs.Instance().Channel()) Response.Write(" tn-tabs-selected"); %>"><a href="<%=Url.Action("ManageAnnouncements", "Auxiliaries", new { presentAreaID=PresentAreaIDs.Instance().Channel(),searchKeywords=Request.QueryString.GetString("searchKeywords", string.Empty) })%>"><span>频道</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(presentAreaID== PresentAreaIDs.Instance().UserDomain()) Response.Write(" tn-tabs-selected"); %>"><a href="<%=Url.Action("ManageAnnouncements", "Auxiliaries", new { presentAreaID=PresentAreaIDs.Instance().UserDomain(),searchKeywords=Request.QueryString.GetString("searchKeywords", string.Empty) })%>"><span>个人空间</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(presentAreaID== PresentAreaIDs.Instance().ClubDomain()) Response.Write(" tn-tabs-selected"); %>"><a href="<%=Url.Action("ManageAnnouncements", "Auxiliaries", new { presentAreaID=PresentAreaIDs.Instance().ClubDomain(),searchKeywords=Request.QueryString.GetString("searchKeywords", string.Empty) })%>"><span>群组</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(presentAreaID== PresentAreaIDs.Instance().MicroBlogDomain()) Response.Write(" tn-tabs-selected"); %>"><a href="<%=Url.Action("ManageAnnouncements", "Auxiliaries", new { presentAreaID=PresentAreaIDs.Instance().MicroBlogDomain(),searchKeywords=Request.QueryString.GetString("searchKeywords", string.Empty) })%>"><span>微博</span></a></li>
        </ul>
        <form id="ManageAnnouncementsForm" method="post" >
        <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
<%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
          new RouteValueDictionary { { "onclick", "if(!VerifyChoose()) return false; if (confirm('确认要删除这些公告吗？'))  { $('#ManageAnnouncementsForm').attr('action','" + Url.Action("DeleteAnnouncements", "Auxiliaries", new { returnUrl = Request.RawUrl }) + "');$('#ManageAnnouncementsForm').submit(); return false; }  else {  return false; };" }, { "title", "删除选中的公告" } }, null)%>
                                                                                                    
        </div>
        <div id="ManageBlogsDiv">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
               标题
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                状态
            </th>
              <th class="tn-border-gray tn-border-bottom tn-text-note">
               发布日期
            </th>
              <th class="tn-border-gray tn-border-bottom tn-text-note">
                更新时间
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
               过期时间
            </th>          
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                排序序号
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                操作
            </th>
        </tr>
        <%
            if (ViewData.Model != null)
            {
                PagingDataSet<Announcement> PgListAnnouncement = ViewData.Model as PagingDataSet<Announcement>;
                IList<Announcement> IListAnnouncement = PgListAnnouncement.Records;                
        %>



        <% if (ViewData.Model.Records.Count > 0)
           {
               foreach (var item in IListAnnouncement)
               {    
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                    value="<%=item.ThreadID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <a href="<%=SiteUrls.Instance().ShowAnnouncement(item.ThreadID) %>" target="_blank" style="<%=item.SubjectStyle%>"> 
                <%=item.Subject%> <%if (item.IsSticky) Response.Write("<span title='置顶' class='tn-icon-inline tn-icon-top tn-icon'></span>");%></a>
                  
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">                   
                <%if ((int)item.AnnouncementStatus ==0)
                  {%>
                  未发布  
                <%}%>     
                  <%if ((int)item.AnnouncementStatus ==1)
                  {%>
                  已发布   
                <%} %>  
                  <%if ((int)item.AnnouncementStatus ==2)
                  {%>
                  已过期   
                <%} %>       
            </td>
              <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
               <%=Formatter.FormatDate(item.ReleaseDate) %>
            </td>
              <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
              <%=Formatter.FormatDate(item.LastModified) %> 
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
             <%=Formatter.FormatDate(item.DateExpired) %>
            </td>
          
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
               <%=item.DisplayOrder %>
            </td>
          
           
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
            <span class="tn-action">
            <a onclick="if ( !confirm('是否删除选中的公告？') ) {return false; }"
                            href="<%=Url.Action("DeleteAnnouncement", new RouteValueDictionary { { "threadID",item.ThreadID } })%>">
                            删除</a>
            </span>
                <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                    menu="#moreOptions3<%=item.ThreadID %>"><span class="tn-icon tn-icon-triangle-down">
                    </span><a href="<%=Url.Action("EditAnnouncement", new RouteValueDictionary { { "threadID",item.ThreadID } })%>"
                        class="tn-action-text" >编辑</a> </span>

                <div id="moreOptions3<%=item.ThreadID %>" class="tn-drop-menu ui-widget-content"
                    style="display: none;">
                    <ul class="tn-menu-drop-list">
                     
                        <li class="tn-menu-drop-item">
                            <%if (item.IsSticky)
                              {%>
                           <a href="<%=Url.Action("SetSticky", new RouteValueDictionary { { "threadID",item.ThreadID },{"isSticky",false } })%>" > 取消置顶</a>
                            <%} %>
                            <%else
                                {%>
                               <a href="<%=Url.Action("SetSticky", new RouteValueDictionary { { "threadID",item.ThreadID },{"isSticky",true } })%>" > 置顶</a> 
                            <%} %>
                             </li>
                    </ul>
                </div>
            </td>
        </tr>
        <%}
           } %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%
            Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgListAnnouncement.TotalRecords, PgListAnnouncement.PageSize, PgListAnnouncement.PageIndex, 11, null)); 
        %>
    </div>
    <%} %>
</div>
   </form >   
  </div> 
  </div>      
     
  <script type="text/javascript">
      function VerifyChoose() {
          if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
              alert("至少选择一条公告！");
              return false;
          }
          return true;
      }
      $(document).ready(function () {
          $("#searchButton").click(function () {
              if (!$("#searchForm").valid()) {
                  return false;
              }
          });

          $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });

      });
</script>  
      

</asp:content>
