﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.ManageLinks;
    ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.ManageLinkCategory;
    Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="pageNameContent">
友情链接类别管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="ManageLinkCategories"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">

     <div class="tn-tabs tn-widget">
      <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <div>
       
           <div class="tn-list-header" id="Div1">
                <div class="tn-toolbar-area tn-helper-clearfix">
                   <%=SPBHtmlHelper.Instance().LinkButton("Add", "增加链接类别", Url.Action("Control_AddLinkCategory", "Auxiliaries"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "name", "LinkCategory" }, { "title", "增加一个新的链接类别" } }, null)%>                                                           
                   <%=SPBHtmlHelper.Instance().LinkButton("Delete", "删除链接类别", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些链接类别吗？注意：删除类别后，该类别下的所有友情链接都会被删除！')) { $('#categroyform').submit(); return false; } else { return false; } ;" }, { "title", "批量删除链接类别" } }, null)%>                                                           
                </div>
          </div>
          <form action="<%=Url.Action("DeleteLinkCategoryAction", "Auxiliaries")%>" method="post"
                    id="categroyform">
              <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom"> <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'CategroyGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 类别ID </th>
                <th scope="row" class="tn-border-gray tn-border-bottom tn-text-note"> 类别名称 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Description")%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 排列顺序 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <%
                  if (ViewData["LinkCategories"] != null)
                  {
                      List<LinkCategory> LinkCategories = ViewData["LinkCategories"] as List<LinkCategory>;
                      foreach (var item in LinkCategories)
                      {
                        %>
               <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" class="tn-checkbox" name="CategroyGroup" value="<%=item.CategoryID %>" />
                </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.CategoryID %> </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(item.CategoryName,30) %> </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(item.Description,35) %> </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.DisplayOrder %> </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=Url.Action("Control_EditLinkCategory","Auxiliaries",new{CateID=item.CategoryID}) %>"
                                    name="LinkCategory" >修改</a> </td>
              </tr>
              <%
                  }
                            }
                        %>
            </table>
          </form>
        </div>
      </div>
    </div>
 
  <script type="text/javascript">
      $(document).ready(function() {
          $('a[name="LinkCategory"]').nyroModal({
              resizeable: true,
              width: 500,
              height: 300
          });
      });
    </script>
</asp:content>
