﻿<%@ Page Language="C#"    Inherits="SpaceBuilder.Web.ManageViewPage<List<Role>>" %>
<asp:Content runat="server" ContentPlaceHolderID="HeaderContent">
  <%ViewData["AuxiliaryModuleMenu"] = AuxiliaryModuleMenu.InformationFeedback;
  ViewData["AuxiliaryModuleSubMenu"] = AuxiliaryModuleSubMenu.MassSystemMessage;
  Html.RenderPartial("Controls/Auxiliaries/AuxiliaryModuleMenu.ascx", ViewData); %>
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="pageNameContent"> 群发消息 </asp:Content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="MassSystemMessage" </asp:content>
<asp:Content runat="server" ContentPlaceHolderID="wideContent">
  <%
            if (TempData["StatusMessageData"] != null)
            {
                StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
                if (messageData.MessageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData.MessageType, messageData.MessageContent, 3000));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
                TempData["StatusMessageData"] = null;
            }

        %>
  <form id="massSystemMessageForm" name="massSystemMessageForm" action="<%=Url.Action("MassSystemMessageAction","Auxiliaries") %>"
                method="post">
    <div class="tn-form tn-label-right">
      <div class="tn-form-row">
        <label class="tn-form-label"> 接收群体：</label>
        <select id="type" name="type" class="tn-dropdownlist">
          <option value="0">所有会员</option>
          <option value="1">按角色选择</option>
          <option value="2">按级别选择</option>
        </select>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 角色:</label>
        <select id="roleID" name="roleID">
          <%  foreach (Role role in ViewData.Model)
                                    {
                                        if (role.ConnectToUser == true)
                                        {                                
                                %>
          <option value="<%=role.RoleID %>"> <%=role.FriendlyRoleName %></option>
          <%}
                                    } %>
        </select>
        </select>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 级别范围：</label>
        <select id="minLevel" name="minRank" class="tn-dropdownlist">
          <% for (int i = 1; i <= 18; i++)
                                   { %>
          <option value="<%=i%>"> <%=i %>&nbsp;级</option>
          <%} %>
        </select>
        至
        <select id="maxLevel" name="maxRank" class="tn-dropdownlist">
          <% for (int i = 1; i <= 18; i++)
                                   { %>
          <option value="<%=i%>"> <%=i %>&nbsp;级</option>
          <%} %>
        </select>
        <div class="tn-text-note"> 想对某一级别群发消息时,请选择相同的数值 </div>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label">传输方式：</label>
        <input type="radio" id="usePrivateMessage" checked="checked" name="transportMode"  value="0" class="tn-radiobutton" />
        <label for="usePrivateMessage">发送私信</label>
        <input type="radio" id="useEmail" name="transportMode" value="1" class="tn-radiobutton" />
        <label for="useEmail">发送Email</label>
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" id="subject" name="subject" class="tn-textbox tn-input-long tn-border-gray"  />
        <%=GetResourceString("Description_Required")%> </div>
      <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label"> <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %></label>
        <textarea name="body" id="body" class="tn-textarea tn-input-long tn-border-gray"></textarea>
        <span style="display:none"></span>
        <div class="tn-text-note"> 内容允许输入的最大字数为：3000字 </div>
      </div>
      <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <input type="submit" value="<%=GetResourceString("Button_Send")%>" id="sendButton" class="tn-botton" />
        <a  href="javascript:;" style="display: none" id="saveButtonA"> <%=GetResourceString("Message_Loading")%></a> &nbsp;&nbsp;
        <% if (Request.UrlReferrer != null)
                   {%>
        <%-- <a href="<%=Request.UrlReferrer.AbsoluteUri %>" class="cancel"><%=GetResourceString("Button_Cancel")%></a>--%>
        <input id="cancle" type="button" class="tn-botton"  value="取消"/>
        <%} %>
      </div>
    </div>
  </form>
  <script type="text/javascript">
        $(document).ready(function() {
            $("#massSystemMessageForm").validate({
                rules: {
                    subject: { required: true, maxBlength: 30 },
                    body: { required: true, maxBlength: 3000 }
                },
                messages: {
                    subject: { required: "请填写消息标题", maxBlength: "消息标题最大长度不允许超过30个字" },
                    body: { required: "请填写消息内容", maxBlength: "消息内容最大长度不能超过3000字" }
                }
            });

            $("#sendButton").click(function() {
                if (!$("#massSystemMessageForm").valid()) {
                    return false;
                }
                else {
                    $("#sendButton").hide();
                    $("#saveButtonA").show();
                }
            });
            $("#type").change(function() {
                if ($(this).attr("value") == "1") {
                    $("#levelTr").hide();
                    $("#roleTr").fadeIn();
                }
                else if ($(this).attr("value") == "2") {
                    $("#roleTr").hide();
                    $("#levelTr").fadeIn();
                }
                else {
                    $("#roleTr,#levelTr").hide();
                }
            });
        });
        $("#cancle").click(function() {
            window.location.href =
                   '<%=Request.UrlReferrer.AbsoluteUri %>';
        });
    </script>
</asp:Content>
