﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="HeaderContent" contentplaceholderid="HeaderContent" runat="server">
  <% 
      if (ViewData["BlogSubMenu"] == null)
          ViewData["BlogSubMenu"] = BlogSubMenu.ManageBlogComments;
      ViewData.Add("ApplicationID", ApplicationIDs.Instance().Blog());
      Html.RenderPartial("Controls/Blog/BlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
博客评论管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Blog-ManageBlogComments"
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, true));
          TempData["StatusMessageType"] = null;
      }
      
      AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
      if (ViewData["status"] != null)
          AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];

      int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
    %>
    <form id="ManageSearchForm" action="" method="Get">
       <div class="tn-form-box tn-border-gray tn-border-bottom">
                <table>
                    <tr>
                        <th>
                            关键字：
                        </th>
                        <td>
                            <input name="CommentKeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentKeyWords" value="<%=Request.QueryString.Get("CommentKeyWords") %>" />
                        </td>
                        <th>
                            用户ID
                        </th>
                        <td>
                             <input name="CommentUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentUserID" value="<%=Request.QueryString.Get("CommentUserID") %>" />
                        </td>
                        <td>
                            <select name="status" class="tn-dropdownlist" id="status">
                            <option value="-1">请选择</option>
                                 <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>> 已通过审核</option>
                                <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>> 未通过审核</option>
                              
                                <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>> 待审核</option>
                              </select>
                        </td>
                        <td>
                            <input id="searchButton" class="tn-botton" type="submit" value="<%=GetResourceString("Button_Search")%>" onclick="$('#ManageSearchForm').attr('action','<%=Url.Action("ListBlogComments","ManageBlog")%>');$('#ManageSearchForm').submit(); return false;" />
                            
                               
                        </td>
                    </tr>
                </table>
            </div>
  </form>

            <div class="tn-tabs tn-widget">
               <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
               <li class="tn-widget-content tn-border-gray tn-border-trl  <% if((int)AuditingStatuses== -1) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ListBlogComments","ManageBlog",new{ status = -1,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"> <span>全部评论</span></a></li>

                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ListBlogComments","ManageBlog",new{ status = AuditingStatusesForDisplay.Success,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"
                                    target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
               <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ListBlogComments","ManageBlog",new{ status = AuditingStatusesForDisplay.Pending,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"> <span>待审核</span></a></li>

               <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ListBlogComments","ManageBlog",new{ status = AuditingStatusesForDisplay.Fail,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"> <span>未通过审核</span></a></li>
            </ul>
            <div class="tn-tabs-panel tn-widget-content tn-border-gray">
              <form id="ManageCommentForm" method="post">
              
               <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
                   <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText,
                                                                                         new RouteValueDictionary{{"onclick","if(!VerifyChoose()) return false; $('#ManageCommentForm').attr('action','"+Url.Action("UpdateCommentAuditingStatus","ManageBlog",
                    new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success })+"');$('#ManageCommentForm').submit(); return false; "},{"title","审核通过选中的评论"}}, null)%>
                  
                  <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                                                                      new RouteValueDictionary { { "onclick", "if(!VerifyChoose()) return false; $('#ManageCommentForm').attr('action','" +Url.Action("UpdateCommentAuditingStatus","ManageBlog",
                    new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail }) + "');$('#ManageCommentForm').submit(); return false;" }, { "title", "不审核通过选中的评论" } }, null)%>
                    
                                      <%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                                                                                                                                      new RouteValueDictionary { { "onclick", "if(!VerifyChoose()) return false; if (confirm('确认要删除这些评论吗？')) { $('#ManageCommentForm').attr('action','" + Url.Action("DeleteBlogComments","ManageBlog",
                    new { returnUrl= Request.RawUrl })+ "');$('#ManageCommentForm').submit(); return false; } else {  return false; };" }, { "title", "删除选中的评论" } }, null)%>
</div>
</div>
                              <div id="fragment-1">
                  <% Html.RenderAction<ManageBlogController>(b => b.Control_ListBlogComments((AuditingStatusesForDisplay)(AuditingStatuses), pageIndex)); %>
                </div>
              </form>
            </div>
          </div>
              <script type="text/javascript">
                  function VerifyChoose() {
                      if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                          alert("至少选择一条评论！");
                          return false;
                      }
                      return true;
                  }
              
                  $(document).ready(function() {
                      $("#ManageSearchForm").validate({
                          rules: {
                              CommentUserID: { digits: true }
                          },
                          messages: {
                              CommentUserID: { digits: "请输入非负整数" }
                          }
                      });

                      $("#searchButton").click(function() {
                          if (!$("#ManageSearchForm").valid()) {
                              return false;
                          }
                      });


                  });
    </script>
</asp:content>
