﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%
      ViewData.Add("ApplicationID", ApplicationIDs.Instance().Club());
      ViewData["ClubSubMenu"] = ClubSubMenu.ManageClubs;
      Html.RenderPartial("Controls/Club/ClubSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
群组管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Club-ManageClubs"
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
 <%if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
       TempData["StatusMessageType"] = null;
   }

   AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
   if (ViewData["status"] != null)
       AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];
   int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
   string rootAreaCode = ClubDomainConfiguration.Instance().RootAreaCode;
   int areaLevel = ClubDomainConfiguration.Instance().AreaLevel;
%>                     
<form id="SearchClubform" action="<%=SPBUrlHelper.Action("ListClubs", "ManageClub")%>"
method="get">
<div class="tn-form-box tn-border-gray tn-border-bottom">
    <table>
        <tr>
            <th>
                群组名称：
            </th>
            <td>
                <input type="text" name="SearchClubName" id="SearchClubName" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=Request.QueryString.GetString("SearchClubName", string.Empty)%>" />
            </td>
            <th>
                群主UserID：
            </th>
            <td>
                <input type="text" id="SearchClubUserID" name="SearchClubUserID" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=Request.QueryString.GetString("SearchClubUserID", string.Empty)%>" />
            </td>
            <th>
                公开程度：
            </th>
            <td>
                <% int intSearchClubSecrecyType = Request.QueryString.GetInt("SearchClubSecrecyType", -1); %>
                <select id="Select1" name="SearchClubSecrecyType" class="tn-dropdownlist" style="width: 150px;">
                    <option value="-1">所有</option>
                    <option value="1" <% if (intSearchClubSecrecyType == 1) { Response.Write("selected"); } %>>
                        公开</option>
                    <option value="0" <% if (intSearchClubSecrecyType == 0) { Response.Write("selected"); } %>>
                        私有</option>
                </select>
            </td>
        </tr>
        <tr>
            <th>
                群组类别：
            </th>
            <td>
                <% int clubCategoryID = Request.QueryString.GetInt("ClubCategoryID", -1); %>
                <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Club(), 3, "ClubCategoryID", clubCategoryID, "tn-dropdownlist")); %>
            </td>
            <th>
                所在地区：
            </th>
            <td>
                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", rootAreaCode, Request.QueryString.GetString("AreaCode", string.Empty), areaLevel, "tn-dropdownlist")); %>
            </td>
            <input type="hidden" name="status"  value="<%=AuditingStatuses %>"/>
            <td>
                <input id="searchButton" class="tn-botton" type="submit"
                    value="<%=GetResourceString("Button_Search")%>" />
            </td>
        </tr>
    </table>
</div>
</form>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListClubs","ManageClub",new{ status = AuditingStatusesForDisplay.Success,SearchClubName=Request.QueryString.GetString("SearchClubName", string.Empty),SearchClubUserID=Request.QueryString.GetString("SearchClubUserID", string.Empty),SearchClubSecrecyType=Request.QueryString.GetString("SearchClubSecrecyType", string.Empty),ClubCategoryID=Request.QueryString.GetString("ClubCategoryID", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>"
                target="_self" style="cursor: pointer">
                <span>已通过审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListClubs","ManageClub",new{ status = AuditingStatusesForDisplay.Pending,SearchClubName=Request.QueryString.GetString("SearchClubName", string.Empty),SearchClubUserID=Request.QueryString.GetString("SearchClubUserID", string.Empty),SearchClubSecrecyType=Request.QueryString.GetString("SearchClubSecrecyType", string.Empty),ClubCategoryID=Request.QueryString.GetString("ClubCategoryID", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>">
                <span>待审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Again) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListClubs","ManageClub",new{ status = AuditingStatusesForDisplay.Again,SearchClubName=Request.QueryString.GetString("SearchClubName", string.Empty),SearchClubUserID=Request.QueryString.GetString("SearchClubUserID", string.Empty),SearchClubSecrecyType=Request.QueryString.GetString("SearchClubSecrecyType", string.Empty),ClubCategoryID=Request.QueryString.GetString("ClubCategoryID", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>">
                <span>需再审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListClubs","ManageClub",new{ status = AuditingStatusesForDisplay.Fail,SearchClubName=Request.QueryString.GetString("SearchClubName", string.Empty),SearchClubUserID=Request.QueryString.GetString("SearchClubUserID", string.Empty),SearchClubSecrecyType=Request.QueryString.GetString("SearchClubSecrecyType", string.Empty),ClubCategoryID=Request.QueryString.GetString("ClubCategoryID", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>">
                <span>未通过审核</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="ManageClubForm" method="post">
        <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
                <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText,
                       new RouteValueDictionary{{"onclick","$('#ManageClubForm').attr('action','"+Url.Action("UpdateClubAuditingStatus","ManageClub",
                    new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success })+"');$('#ManageClubForm').submit(); return false;"},{"title","审核通过选中的群组"}}, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                    new RouteValueDictionary { { "onclick", "$('#ManageClubForm').attr('action','"+Url.Action("UpdateClubAuditingStatus","ManageClub",
                    new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail })+"');$('#ManageClubForm').submit(); return false;" }, { "title", "不审核通过选中的群组" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("del", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                                                  new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些群组吗？')) { $('#ManageClubForm').attr('action','"+Url.Action("DeleteClubs","ManageClub",
                    new { returnUrl= Request.RawUrl })+"');$('#ManageClubForm').submit(); return false; } else {  return false; };" }, { "title", "删除选中的群组" } }, null)%>
            </div>
        </div>
        <div id="fragment-1">
            <%if (ViewData["PgClubs"] != null)
              {
                  PagingDataSet<Club> pds = ViewData["PgClubs"] as PagingDataSet<Club>;
            %>
            <div>
                <table class="tn-table-grid">
                    <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom">
                            <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            群组名称
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            群主
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            所属类别
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            所在地区
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            公开程度
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_DateCreated")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            成员数
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            积分
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            周浏览
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            操作
                        </th>
                    </tr>
                    <% 
                        if (pds != null && pds.TotalRecords > 0)
                        {
                            IList<Club> IlistClub = pds.Records;
                            foreach (var item in IlistClub)
                            {
                                                        
                    %>
                    <tr class="tn-table-grid-row">
                        <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input id="CheckBoxGroup" type="checkbox" name="CheckBoxGroup" value="<%=item.ClubID %>" />
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <a href="<%=SiteUrls.Instance().ClubDomainHome(item.DomainName) %>" target="_blank">
                                <%=item.ClubName%></a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.ClubOwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                target="_blank">
                                <%=item.ClubOwner.UserName%></a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <% if (item.ClubSiteCategoy != null) Response.Write(item.ClubSiteCategoy.CategoryName);  %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <% if (item.Area != null) Response.Write(item.Area.Name); %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <% if (item.IsPublic) Response.Write("公开"); else Response.Write("私有"); %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=Formatter.FormatDate(item.DateCreated)%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=item.MemberCount%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=item.Points%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=item.StageHitTimes%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                            <span class="tn-action">
                                <a href="<%=Url.Action("Home","ClubManage",new{clubDomainName=item.DomainName}) %>"
                                    target="_blank" class="tn-action-text">管理</a></span>
                            <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                                menu="#moreOptions<%=item.ClubID %>">
                                <span class="tn-icon tn-icon-triangle-down"></span>
                                <a onclick="if ( !confirm('是否删除这个群组？') ) {return false; }" href="<%=Url.Action("DeleteClub","ManageClub",new{ status = (AuditingStatusesForDisplay)(item.AuditingStatus), pageIndex = pds.PageIndex, clubID = item.ClubID }) %>"
                                    class="tn-action-text">删除</a></span>
                            <div id="moreOptions<%=item.ClubID %>" class="tn-drop-menu ui-widget-content" style="display: none;">
                                <ul class="tn-menu-drop-list">
                                    <li class="tn-menu-drop-item">
                                        <a class="showModal" href="<%=Url.Action("Control_ChangeClubOwner","ManageClub",new{clubID=item.ClubID}) %>">
                                            更换群主</a></li>
                                    <li class="tn-menu-drop-item">
                                        <a onclick="if ( !confirm('确实要将此群组转换为论坛版块组吗？') ) {return false; }" href="<%=Url.Action("ClubToForumGroup","ManageClub",new{ clubID = item.ClubID,returnUrl= Request.RawUrl }) %>">
                                            转换为论坛</a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <% }
                        }%>
                </table>
                <div class="tn-pagination tn-helper-align-center">
                    <%  Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, pds.TotalRecords, pds.PageSize, pds.PageIndex));   %>
                </div>
                <% 
                    }%>
            </div>
        </div>
        </form>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#SearchClubform").validate({
            rules: {
                SearchClubUserID: { digits: true }
            },
            messages: {
                SearchClubUserID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#SearchClubform").valid()) {
                return false;
            }
        });

        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
        $('.showModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 300,
            endRemove: function() {

            }
        });
    });
</script>
  
</asp:content>
