﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<EventPhotoComment>>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["EventSubMenu"] = EventSubMenu.ManageEventPhotoComment;
     ViewData.Add("ApplicationID", ApplicationIDs.Instance().Event());
     Html.RenderPartial("Controls/Events/EventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Event-ManageEventPhotoComments"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
活动照片评论管理
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
 
      <% 
          if (TempData["StatusMessageType"] != null)
          {
              StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
              if (messageType == StatusMessageType.Success)
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
              else
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
              TempData["StatusMessageType"] = null;
          }
          AuditingStatusesForDisplay? auditingStatusForDisplay = AuditingStatusesForDisplay.Pending;
          if (ViewData["AuditingStatusForDisplay"] != null)
              auditingStatusForDisplay = (AuditingStatusesForDisplay)ViewData["AuditingStatusForDisplay"];
       

            %>  
  
    <form id="SearchEventPhotocommentsForm" method="get" action="<%=Url.Action("ManageEventPhotosComments","ManageEvent",new {auditingStatusForDisplay= auditingStatusForDisplay}) %>">
       <div class="tn-form-box tn-border-gray tn-border-bottom">
                <table>
                    <tr>
                        <th>
                            关键字：
                        </th>
                        <td>
                           <input name="Keyword" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="eventName" value="<%=Request.QueryString.GetString("Keyword",string.Empty) %>" />
                        </td>
                        <th>
                            用户ID
                        </th>
                        <td>
                           <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<% if (Request.QueryString.GetInt("UserID", -1) > 0) Response.Write(Request.QueryString.GetInt("UserID",0).ToString()); %>" />
                        </td>  
                         <th>审核状态</th>  
                         <td>
                         <select name="auditingStatusForDisplay" class="tn-dropdownlist" id="Select1">                         
                            <option value="-1" >请选择</option>
                                <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>> 已通过审核</option>
                                <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>> 未通过审核</option>
                                <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>> 待审核</option>
                          </select>
                         </td> 
                            <td>   
                        <input type="submit"  class="tn-botton" value="搜索" id="searchButton"  />
                        </td>                
                         </tr>                          
                </table>
        </div>
    </form>
  
 <div class="tn-tabs tn-widget">
               <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)auditingStatusForDisplay==-1) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotosComments", "ManageEvent", new { auditingStatusForDisplay = -1,Keyword=Request.QueryString.GetString("Keyword", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty)}) %>"> <span>全部照片评论</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
                 <a href="<%=Url.Action("ManageEventPhotosComments", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Success,Keyword=Request.QueryString.GetString("Keyword", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty)}) %>" ><span>已通过审核</span></a></li>                                   
                <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotosComments", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Pending,Keyword=Request.QueryString.GetString("Keyword", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty)}) %>"> <span>待审核</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotosComments", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Fail,Keyword=Request.QueryString.GetString("Keyword", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty)}) %>"> <span>未通过审核</span></a></li>
              </ul>
            <div class="tn-tabs-panel tn-widget-content tn-border-gray">  
               
              <form id="ManageEventPhotoCommentsForm" method="post">
              <div class="tn-list-header">
                 <div class="tn-toolbar-area tn-helper-clearfix">
                   <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageEventPhotoCommentsForm').attr('action','"+Url.Action("SetEventPhotoCommentsAuditingStatus","ManageEvent",new {isPass=true,returnUrl= Request.RawUrl})+"'); $('#ManageEventPhotoCommentsForm').submit();return false;"},{"title","把选中的活动照片评论通过审核"}}, null)%>
                   <%= SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "$('#ManageEventPhotoCommentsForm').attr('action','" + Url.Action("SetEventPhotoCommentsAuditingStatus", "ManageEvent",new {isPass=false,returnUrl = Request.RawUrl }) + "'); $('#ManageEventPhotoCommentsForm').submit();return false;" },{"title","把选中的活动照片评论不通过审核"} }, null)%>
                   <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些活动照片评论吗？')) {$('#ManageEventPhotoCommentsForm').attr('action','" + Url.Action("DeleteEventPhotoComments", "ManageEvent", new { returnUrl = Request.RawUrl }) + "');$('#ManageEventPhotoCommentsForm').submit();}return false;" }, { "title", "删除选中的活动照片评论" } }, null)%>
                 </div>
              </div>
              <% if (Model != null && Model.TotalRecords > 0)
               { %>  
                <div id="fragment-1">         
               <table class="tn-table-grid" >
                  <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 
                      <input type="checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 评论内容 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 评论人 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 评论者ID </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 评论日期 </th>                   
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                  </tr>
                  <% foreach (EventPhotoComment eventPhotoCommentThread in ViewData.Model.Records)
                     {
                         if (eventPhotoCommentThread == null)
                             continue;
                         %>
                  <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                      <input type="checkbox" name="CheckBoxGroup" class="tn-checkbox" value="<%=eventPhotoCommentThread.CommentID %>" /> 
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <a title="<%=eventPhotoCommentThread.Body %>" href="<%=SiteUrls.Instance().ShowEventPhoto(eventPhotoCommentThread.AttachmentID) %>#photoCommentsListDiv" target="_blank">
                      <%=HtmlUtils.TrimHtml(eventPhotoCommentThread.Body, 50)%></a></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><% if (eventPhotoCommentThread.UserID > 0)
                                                                             { %>
                      <a href="<%=SiteUrls.Instance().UserChannelHome(eventPhotoCommentThread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                        target="_blank" title="点击查看<%=eventPhotoCommentThread.Author %>的个人空间"> <%=eventPhotoCommentThread.Author%></a>
                     <%} %> 
                    </td>                                       
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventPhotoCommentThread.UserID%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(eventPhotoCommentThread.DateCreated,true)%> </td>             
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">                 
                        <a onclick="if (confirm('确定要删除这个活动照片的评论吗？') ) {window.location.href='<%=Url.Action("DeleteEventPhotoComment", "ManageEvent", new { commentID = eventPhotoCommentThread.CommentID,returnUrl= Request.RawUrl}) %>'; } return false;"
                                                href="Javascript:void(0);" >删除</a>     
                        
                     </td>
                  </tr>
                  <%} %>
               </table>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
               <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
            </div>
                </div>  
                 <%} %>
              </form>
           
            </div>
          </div>
 
  <script type="text/javascript">
      $(document).ready(function () {

          $("#SearchEventPhotocommentsForm").validate({
              rules: {
                  userID: { digits: true }
              },
              messages: {
                  userID: { digits: "请输入非负整数" }
              }
          });
          $("#searchButton").click(function () {
              if (!$("#SearchEventPhotocommentsForm").valid()) {
                  return false;
              }
          });
      }); 
    </script>
    
    
</asp:content>
