﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<EventPhoto>>" %>

<asp:content id="Content1" runat="server" contentplaceholderid="HeaderContent">
  <% ViewData["EventSubMenu"] = EventSubMenu.ManageEventPhotos;
     ViewData.Add("ApplicationID", ApplicationIDs.Instance().Event());
     Html.RenderPartial("Controls/Events/EventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Event-ManageEventPhotos"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
活动照片管理
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
          <%   if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                   TempData["StatusMessageType"] = null;
               }
               AuditingStatusesForDisplay auditingStatusForDisplay = AuditingStatusesForDisplay.Pending;
               if (ViewData["AuditingStatusForDisplay"] != null)
                   auditingStatusForDisplay = (AuditingStatusesForDisplay)ViewData["AuditingStatusForDisplay"];                  
           %>
  <form id="ManageSearchForm" method="post" action="<%=Url.Action("SearchEventPhotos","ManageEvent",new {auditingStatusForDisplay = auditingStatusForDisplay}) %>">
       <div class="tn-form-box tn-border-gray tn-border-bottom">
                <table>
                    <tr>
                        <th>
                            关键字：
                        </th>
                        <td>
                         <input name="subjectKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("subjectKeywords",string.Empty) %>"
                                    id="subjectKeywords" />
                        </td>
                        <th>
                            用户ID
                        </th>
                        <td>
                            <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<% if (Request.QueryString.GetInt("UserID", 0) > 0) Response.Write(Request.QueryString.GetInt("UserID",0).ToString()); %>"
                                    id="userID" />
                        </td>                       
                        <td>  
                        <input type="submit" value="搜索" id="searchButton" />
                        </td>
                    </tr>
                </table>
        </div>
  </form>
  <div id="EventContent">
     <div id="EventCenterColumn">
       <div class="containerCenter">
          <div class="containerArea">
            <div class="tn-tabs tn-widget">
              <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">   
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotos", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Success,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>" target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>                                   
                <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotos", "ManageEvent", new {  auditingStatusForDisplay = AuditingStatusesForDisplay.Pending,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>待审核</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Again) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotos", "ManageEvent", new {  auditingStatusForDisplay = AuditingStatusesForDisplay.Again,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>需再审核</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEventPhotos", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Fail,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)}) %>"> <span>未通过审核</span></a></li>
             </ul>
              <div class="tn-tabs-panel tn-widget-content tn-border-gray">        
                 <form id="ManageEventPostsForm" method="post">
                  <div class="tn-list-header">
                   <div class="tn-toolbar-area tn-helper-clearfix">
                      <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageEventPostsForm').attr('action','"+Url.Action("UpdateEventPhotoAuditingStatuses","ManageEvent",
                             new {auditingStatus=AuditingStatuses.Success,returnUrl= Request.RawUrl})+"'); $('#ManageEventPostsForm').submit();return false;"},{"title","把选中的活动留言通过审核"}}, null)%>
                      <%= SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "$('#ManageEventPostsForm').attr('action','" + Url.Action("UpdateEventPhotoAuditingStatuses", "ManageEvent",
                            new { auditingStatus = AuditingStatuses.Fail, returnUrl = Request.RawUrl }) + "'); $('#ManageEventPostsForm').submit();return false;" },{"title","把选中的活动留言不通过审核"} }, null)%>
                       <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                            new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些活动照片吗？')) $('#ManageEventPostsForm').attr('action','" + Url.Action("DeleteEventPhotos", "ManageEvent", new { returnUrl = Request.RawUrl }) + "'); $('#ManageEventPostsForm').submit();return false;" }, { "title", "删除选中的活动照片" } }, null)%>
                   </div>
                 </div>
                    
                     <div id="fragment-1">        
              <table class="tn-table-grid" >
              <tr class="tn-table-grid-header">
                 <th class="tn-border-gray tn-border-bottom tn-text-note"> 
                  <input type="checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                   </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 发布者用户ID </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 缩略图 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 图片名称 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 发布者 </th>
                <th class="tn-border-gray tn-border-bottom"> <%=GetResourceString("Label_Description")%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 发布时间 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <% foreach (EventPhoto eventPhoto in ViewData.Model.Records)
                 {%>
              <tr class="gridItem">
                <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="CheckBoxGroup" class="tn-checkbox" value="<%=eventPhoto.AttachmentID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventPhoto.UserID %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a target="_blank" href="<%=SiteUrls.Instance().ShowEventPhoto(eventPhoto.AttachmentID) %>"> <img src="<%=SiteUrls.Instance().EventPhotoUrl(eventPhoto.AttachmentID, EventPhotoTypes.Thumbnail) %>"
                                        title="<%=eventPhoto.FriendlyFileName %>" /></a></td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventPhoto.FriendlyFileName %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=SiteUrls.Instance().UserChannelHome(eventPhoto.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                    target="_blank" title="点击查看<%=eventPhoto.Author %>的个人空间"> <%=eventPhoto.Author%></a> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><span> <%= StringUtils.Trim(eventPhoto.Description, 36)%></span> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%= Formatter.FormatDate(eventPhoto.DateCreated, true)%> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="javascript:;"  onclick="if (confirm('确定要删除该图片吗？')) {window.location= '<%=this.Url.Action("DeleteEventPhoto", "ManageEvent", new { attachmentID =eventPhoto.AttachmentID,returnUrl= Request.RawUrl })%>';}"> 删除</a> </td>
              </tr>
              <%} %>
            </table>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
             <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
            </div>
                </div>
                  </form>
              </div>
          </div>
        </div>
       </div>
     </div>
  </div>
  
  <script type="text/javascript">
      $(document).ready(function() {
          $("#ManageSearchForm").validate({
              rules: {
                  userID: { digits: true }
              },
              messages: {
                  userID: { digits: "请输入非负整数" }
              }
          });

          $("#searchButton").click(function() {
              if (!$("#ManageSearchForm").valid()) {
                  return false;
              }
          });
      }); 

    </script>
</asp:content>
