﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<EventThread>>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["EventSubMenu"] = EventSubMenu.ManageEvents;
     ViewData.Add("ApplicationID", ApplicationIDs.Instance().Event());
     Html.RenderPartial("Controls/Events/EventSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Event-ManageEvents"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
活动管理
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
 
      <% 
          if (TempData["StatusMessageType"] != null)
          {
              StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
              if (messageType == StatusMessageType.Success)
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
              else
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
              TempData["StatusMessageType"] = null;
          }
          AuditingStatusesForDisplay auditingStatusForDisplay = AuditingStatusesForDisplay.Pending;
          if (ViewData["AuditingStatusForDisplay"] != null)
              auditingStatusForDisplay = (AuditingStatusesForDisplay)ViewData["AuditingStatusForDisplay"];
          string rootAreaCode = EventConfiguration.Instance().RootAreaCode;
          int areaLevel = EventConfiguration.Instance().AreaLevel;

          Dictionary<int, string> eventSiteCategories = ViewData["EventSiteCategories"] as Dictionary<int, string>;                  
            %>  
  
    <form id="SearchEventsForm" method="post" action="<%=Url.Action("SearchEvents","ManageEvent",new {auditingStatusForDisplay= auditingStatusForDisplay}) %>">
       <div class="tn-form-box tn-border-gray tn-border-bottom">
                <table>
                    <tr>
                        <th>
                            活动名称：
                        </th>
                        <td>
                           <input name="eventName" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="eventName" value="<%=Request.QueryString.GetString("Keyword",string.Empty) %>" />
                        </td>
                        <th>
                            发起人ID
                        </th>
                        <td>
                           <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<% if (Request.QueryString.GetInt("UserID", 0) > 0) Response.Write(Request.QueryString.GetInt("UserID",0).ToString()); %>" />
                        </td>  
                           <th>
                            地区
                        </th>
                        <td colspan="3">
                           <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", rootAreaCode, Request.QueryString.GetString("AreaCode", string.Empty), areaLevel, string.Empty)); %>
                        </td> 
                      </tr>
                        <tr>
                             <th>
                            状态
                        </th>
                        <td>
                           <select name="status" class="tn-dropdownlist" id="status">
                            <option value="-1">全部</option>
                            <option value="1">进行中</option>
                            <option value="2">已取消</option>
                            <option value="9">已结束</option>
                          </select>
                        </td>
                          <th>
                            活动类别
                        </th>
                        <td>
                           <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Event(), ViewData.GetInt("SiteCategoryDepth", 1), "siteCategoryID", Request.QueryString.GetInt("SiteCategoryID", -1), "dropDownList")); %>
                        </td> 
                         <th>
                            排序
                        </th>
                        <td>
                           <select id="sortby" name="sortby" class="tn-dropdownlist">
                            <option value="1">最后更新日期</option>
                            <option value="2">成员数</option>
                            <option value="3">留言数</option>
                            <option value="4"><%=GetResourceString("Label_BrowseCount")%></option>
                            <option value="5">照片数</option>
                          </select>
                          <select name="sortorder" class="tn-dropdownlist" id="sortorder">
                            <option value="1">降序</option>
                            <option value="0">升序</option>
                          </select>
                        </td> 
                        <td>   
                        <input type="submit" value="搜索" id="searchButton" />
                        </td>
                    </tr>
                </table>
        </div>
    </form>
    <div id="EventContent">
    <div id="EventCenterColumn">
        <div class="tn-tabs tn-widget">
               <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
                 <a href="<%=Url.Action("ManageEvents", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Success,Keyword=Request.QueryString.GetString("Keyword", string.Empty),siteCategoryID=Request.QueryString.GetString("siteCategoryID", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty),status=Request.QueryString.GetString("status", string.Empty),sortBy=Request.QueryString.GetString("sortBy", string.Empty),sortOrder=Request.QueryString.GetString("sortOrder", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>"
                 target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>                                   
                <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEvents", "ManageEvent", new {  auditingStatusForDisplay = AuditingStatusesForDisplay.Pending,Keyword=Request.QueryString.GetString("Keyword", string.Empty),siteCategoryID=Request.QueryString.GetString("siteCategoryID", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty),status=Request.QueryString.GetString("status", string.Empty),sortBy=Request.QueryString.GetString("sortBy", string.Empty),sortOrder=Request.QueryString.GetString("sortOrder", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)})%>"> <span>待审核</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl  <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Again) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEvents", "ManageEvent", new {  auditingStatusForDisplay = AuditingStatusesForDisplay.Again,Keyword=Request.QueryString.GetString("Keyword", string.Empty),siteCategoryID=Request.QueryString.GetString("siteCategoryID", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty),status=Request.QueryString.GetString("status", string.Empty),sortBy=Request.QueryString.GetString("sortBy", string.Empty),sortOrder=Request.QueryString.GetString("sortOrder", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)})%>"> <span>需再审核</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageEvents", "ManageEvent", new { auditingStatusForDisplay = AuditingStatusesForDisplay.Fail,Keyword=Request.QueryString.GetString("Keyword", string.Empty),siteCategoryID=Request.QueryString.GetString("siteCategoryID", string.Empty),userID=Request.QueryString.GetString("userID", string.Empty),status=Request.QueryString.GetString("status", string.Empty),sortBy=Request.QueryString.GetString("sortBy", string.Empty),sortOrder=Request.QueryString.GetString("sortOrder", string.Empty),areaCode=Request.QueryString.GetString("areaCode", string.Empty)}) %>"> <span>未通过审核</span></a></li>
              </ul>
            <div class="tn-tabs-panel tn-widget-content tn-border-gray">        
              <form id="ManageEventPostsForm" method="post">
              <div class="tn-list-header">
                 <div class="tn-toolbar-area tn-helper-clearfix">
                   <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageEventPostsForm').attr('action','"+Url.Action("SetEventAuditingStatus","ManageEvent",
                         new {isPass=true,returnUrl= Request.RawUrl})+"'); $('#ManageEventPostsForm').submit();return false;"},{"title","把选中的活动通过审核"}}, null)%>
                   <%= SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "$('#ManageEventPostsForm').attr('action','" + Url.Action("SetEventAuditingStatus", "ManageEvent",
                        new {isPass=false,returnUrl = Request.RawUrl }) + "'); $('#ManageEventPostsForm').submit();return false;" },{"title","把选中的活动不通过审核"} }, null)%>
                   <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                                                  new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些活动吗？')) {$('#ManageEventPostsForm').attr('action','"+Url.Action("DeleteEvents","ManageEvent",new {returnUrl= Request.RawUrl})+"');$('#ManageEventPostsForm').submit();}return false;"}, { "title", "删除选中的活动" } }, null)%>
                 </div>
              </div>
              
                <div id="fragment-1">         
               <table class="tn-table-grid" >
                  <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 
                      <input type="checkbox" onclick="checkAll(this,'ManageEventsCheckBoxGroup')" />
                    </th>
                    <th class="tn-border-gray tn-border-bottom"> <%=GetResourceString("Label_Body")%> </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 发起者 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 所属类别 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 所在地区 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 公开程度 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 状态 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 最后更新日期</th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 成员数 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 积分 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 点击数 </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                  </tr>
                  <% foreach (EventThread eventThread in ViewData.Model.Records)
                     {%>
                  <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                      <input type="checkbox" name="ManageEventsCheckBoxGroup" class="tn-checkbox" value="<%=eventThread.EventID %>" />
                     
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=SiteUrls.Instance().ShowEvent(eventThread.EventID) %>" target="_blank"
                                        title="<%=eventThread.EventName %>"> <%=StringUtils.Trim(eventThread.EventName,10) %></a> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><% if (eventThread.UserID > 0)
                                                                             { %>
                      <a href="<%=SiteUrls.Instance().UserChannelHome(eventThread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                        target="_blank" title="点击查看<%=eventThread.Sponsor %>的个人空间"> <%=eventThread.Sponsor %></a>
                      <%}
                                                                             else Response.Write(eventThread.Sponsor); %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><% if (eventSiteCategories != null) { Response.Write(eventSiteCategories[eventThread.EventID]); } %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatArea(eventThread.AreaCode,true) %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><% if (eventThread.IsPublic) Response.Write("公开"); else Response.Write("私有"); %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><% switch (eventThread.EventStatus)
                                                                             {
                                                                                 case EventStatuses.Canceled:
                                                                                     Response.Write("已取消");
                                                                                     break;
                                                                                 case EventStatuses.Finished:
                                                                                     Response.Write("已结束");
                                                                                     break;
                                                                                 case EventStatuses.Published:
                                                                                     Response.Write("正在进行");
                                                                                     break;
                                                                                 default:
                                                                                     break;
                                                                             } %>
                    </td>
                   <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=Formatter.FormatDate(eventThread.LastModified) %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventThread.MemberCount %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventThread.Points %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=eventThread.HitTimes %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                  <%--  <a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Event(), eventThread.UserID, eventThread.EventID, eventThread.EventName) %>"
                                        class="submit nyroModal">推荐</a> <a  href="<%=Url.Action("EditEvent", "ChannelEvent", new { eventID = eventThread.EventID })%>"
                                            target="_blank">编辑</a> <a onclick="if (confirm('确定要删除这个活动吗？') ) {window.location.href='<%=Url.Action("DeleteEvent", "ManageEvent", new { eventID = eventThread.EventID,returnUrl= Request.RawUrl}) %>'; } return false;"
                                                href="#" >删除</a> --%>
                        <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"  menu="#moreOptions3_<%=eventThread.EventID %>"> <span class="tn-icon tn-icon-triangle-down"></span>
                         <a class="tn-action-text" href="<%=Url.Action("EditEvent", "ChannelEvent", new { eventID = eventThread.EventID })%>"
                                            target="_blank">编辑</a>                        </span>
                        <div id="moreOptions3_<%=eventThread.EventID %>" class="tn-drop-menu ui-widget-content" style="display:none;">
                <ul class="tn-menu-drop-list">
                  <li class="tn-menu-drop-item"> <a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Event(), eventThread.UserID, eventThread.EventID, eventThread.EventName) %>"
                                        class=" nyroModal">推荐</a></li>
                  <li class="tn-menu-drop-item"><a onclick="if (confirm('确定要删除这个活动吗？') ) {window.location.href='<%=Url.Action("DeleteEvent", "ManageEvent", new { eventID = eventThread.EventID,returnUrl= Request.RawUrl}) %>'; } return false;"
                                                href="Javascript:void(0);" >删除</a></li>
                </ul>
              </div>
                     </td>
                  </tr>
                  <%} %>
               </table>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
               <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
            </div>
                </div>
              </form>
            </div>
          </div>
    </div>
  </div>  
  <% int status = Request.QueryString.GetInt("Status", -1);
     int sortBy = Request.QueryString.GetInt("SortBy", 1);
     int sortOrder = Request.QueryString.GetInt("sortOrder", 1);
   %>
  <script type="text/javascript">
      $(document).ready(function() {

      $("#SearchEventsForm").validate({
          rules: {
              userID: { digits: true }
          },
          messages: {
              userID: { digits: "请输入非负整数" }
          }
      });

      $("#searchButton").click(function() {
          if (!$("#SearchEventsForm").valid()) {
              return false;
          }
      });
      
          $("#status").val("<%=status %>");
          $("#sortby").val("<%=sortBy %>");
          $("#sortorder").val("<%=sortOrder %>");
          $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
      }); 
    </script>
    
    
</asp:content>
