﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="FileCommentHeaderContent" runat="server" contentplaceholderid="HeaderContent">
    <% 
        if (ViewData["FileSubMenu"] == null)
            ViewData["FileSubMenu"] = FileGallerySubMenu.ManageFileComments;
        ViewData.Add("ApplicationID", ApplicationIDs.Instance().File());
        Html.RenderPartial("Controls/File/FileSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="File-ManageFileComments"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
文件评论管理
</asp:content>
<asp:content id="FileCommentCenterContent" runat="server" contentplaceholderid="wideContent">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }

        AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
        if (ViewData["status"] != null)
            AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];

        int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
    %>    
     <form id="ManageSearchForm" action="<%=Url.Action("ListManageComments","ManageFile")%>" method="Get">
        <div class="tn-form-box tn-border-gray tn-border-bottom">          
           <table>
                    <tr>
                        <th>
                            <%=GetResourceString("Label_KeyWord")%>：
                        </th>
                        <td>
                           <input name="CommentKeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentKeyWords" value="<%=Request.QueryString.Get("CommentKeyWords") %>" />
                        </td>
                        <th>
                            用户ID
                        </th>
                        <td>
                             <input name="CommentUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentUserID" value="<%=Request.QueryString.Get("CommentUserID") %>" />
                        </td>
                        <td>
                            <select name="status" class="tn-dropdownlist" id="status">
                            <option value="-1">全部评论</option>
                            <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
                              已通过审核</option>
                            <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
                              未通过审核</option>            
                            <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
                              待审核</option>
                            </select>
                        </td>
                        <td>        
                        <input id="searchButton" type="submit" value="<%=GetResourceString("Button_Search") %>" />
                        </td>
                    </tr>
                </table>          
        </div>
   </form>     
     <div id="container-1" class="tn-tabs tn-widget">                
            <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
            <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)AuditingStatuses==-1) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageComments","ManageFile",new{ status = -1,CommentKeyWords=Request.QueryString.GetString("CommentKeyWords",string.Empty),CommentUserID=Request.QueryString.GetString("CommentUserID",string.Empty)}) %>"
                                    target="_self" style="cursor: pointer"><span>全部评论</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageComments","ManageFile",new{ status = AuditingStatusesForDisplay.Success,CommentKeyWords=Request.QueryString.GetString("CommentKeyWords",string.Empty),CommentUserID=Request.QueryString.GetString("CommentUserID",string.Empty)}) %>"
                                    target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageComments","ManageFile",new{ status = AuditingStatusesForDisplay.Pending,CommentKeyWords=Request.QueryString.GetString("CommentKeyWords",string.Empty),CommentUserID=Request.QueryString.GetString("CommentUserID",string.Empty)}) %>">
                                    <span>待审核</span></a></li>                     
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageComments","ManageFile",new{ status = AuditingStatusesForDisplay.Fail,CommentKeyWords=Request.QueryString.GetString("CommentKeyWords",string.Empty),CommentUserID=Request.QueryString.GetString("CommentUserID",string.Empty)}) %>">
                                    <span>未通过审核</span></a></li>
            </ul>   
          <div class="tn-tabs-panel tn-widget-content tn-border-gray">
               <form id="ManageFileForm" method="post">
                 <div class="tn-list-header">
                   <div class="tn-toolbar-area tn-helper-clearfix">
                       <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"title","审核通过选中的文件"}}, null)%>                                               
                       <%=SPBHtmlHelper.Instance().LinkButton("SetNoPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary{{"title","不审核通过选中的文件"}}, null)%>                                               
                       <%=SPBHtmlHelper.Instance().LinkButton("Delete", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,null, null)%>         
                   </div>
                 </div>
                                             
                     <div id="fragment-1">
                                <% Html.RenderAction<ManageFileController>(f => f.Control_ListComments((AuditingStatusesForDisplay)(AuditingStatuses), pageIndex)); %>
                     </div>
               </form>
                        </div>                      
     </div>
   <script type="text/javascript">
       $(document).ready(function() {
           $("#ManageSearchForm").validate({
               rules: {
                   CommentUserID: { digits: true }
               },
               messages: {
                   CommentUserID: { digits: "请输入非负整数" }
               }
           });

           $("#searchButton").click(function() {
               if (!$("#ManageSearchForm").valid()) {
                   return false;
               }
           });



           $("#SetIsPassButton").click(function() {
               $('#ManageFileForm')
                 .attr('action', '<%=Url.Action("UpdateCommentAuditingStatus","ManageFile",new { returnUrl= Request.RawUrl,auditingStatus = AuditingStatusesForDisplay.Success }) %>')
                 .submit();
           });
           $("#SetNoPassButton").click(function() {
               $('#ManageFileForm')
                   .attr('action', '<%=Url.Action("UpdateCommentAuditingStatus","ManageFile",new { returnUrl= Request.RawUrl,auditingStatus = AuditingStatusesForDisplay.Fail }) %>')
                   .submit();
           });

           $("#Delete").click(function() {
               if (confirm('确实要删除吗？'))
                   $('#ManageFileForm')
                   .attr('action', '<%=Url.Action("DeleteComments","ManageFile",new { returnUrl= Request.RawUrl }) %>')
                   .submit();
           });
       })   
   </script> 
    
</asp:content>
