﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" runat="server" contentplaceholderid="HeaderContent">
    <% 
        if (ViewData["FileSubMenu"] == null)
            ViewData["FileSubMenu"] = FileGallerySubMenu.ManageFiles;
        ViewData.Add("ApplicationID", ApplicationIDs.Instance().File());
        Html.RenderPartial("Controls/File/FileSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="File-ManageFiles"
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
文件管理
</asp:content>
<asp:content id="Content3" runat="server" contentplaceholderid="wideContent">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }

        AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
        if (ViewData["status"] != null)
            AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];
        int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
    %>
     <form id="ManageSearchForm" action="<%=Url.Action("ListManageFiles","ManageFile")%>" method="Get">
        <div class="tn-form-box tn-border-gray tn-border-bottom">          
           <table>
                    <tr>
                        <th>
                            <%=GetResourceString("Label_KeyWord")%>：
                        </th>
                        <td>
                           <input name="SubjectKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="SubjectKeywords" value="<%=Request.QueryString.Get("SubjectKeywords") %>" />
                        </td>
                        <th>
                            用户ID
                        </th>
                        <td>
                             <input name="OwnerUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="OwnerUserID" value="<%=Request.QueryString.Get("OwnerUserID") %>" />
                        </td>
                        <td>
                             <select name="status" class="tn-dropdownlist" id="status">
                             <option value="-1">请选择</option>
                              <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
                                已通过审核</option>
                              <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
                                未通过审核</option>
                              <option value="<%=(int)AuditingStatusesForDisplay.Again %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Again) Response.Write("selected"); %>>
                                需再审核</option>
                              <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
                                待审核</option>
                              </select>
                        </td>
                        <td>   
                            <input type="submit" value="搜索" id="searchButton" />
                        </td>
                    </tr>
                </table>          
        </div>
   </form>     
     <div id="container-1" class="tn-tabs tn-widget">
          <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)AuditingStatuses==-1) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageFiles","ManageFile",new{ status = -1,SubjectKeywords=Request.QueryString.GetString("SubjectKeywords",string.Empty),OwnerUserID=Request.QueryString.GetString("OwnerUserID",string.Empty)}) %>"
                                    target="_self" style="cursor: pointer"><span>全部文件</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageFiles","ManageFile",new{ status = AuditingStatusesForDisplay.Success,SubjectKeywords=Request.QueryString.GetString("SubjectKeywords",string.Empty),OwnerUserID=Request.QueryString.GetString("OwnerUserID",string.Empty)}) %>"
                                    target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageFiles","ManageFile",new{ status = AuditingStatusesForDisplay.Pending,SubjectKeywords=Request.QueryString.GetString("SubjectKeywords",string.Empty),OwnerUserID=Request.QueryString.GetString("OwnerUserID",string.Empty)}) %>">
                                    <span>待审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Again) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageFiles","ManageFile",new{ status = AuditingStatusesForDisplay.Again,SubjectKeywords=Request.QueryString.GetString("SubjectKeywords",string.Empty),OwnerUserID=Request.QueryString.GetString("OwnerUserID",string.Empty)}) %>">
                                    <span>需再审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListManageFiles","ManageFile",new{ status = AuditingStatusesForDisplay.Fail,SubjectKeywords=Request.QueryString.GetString("SubjectKeywords",string.Empty),OwnerUserID=Request.QueryString.GetString("OwnerUserID",string.Empty)}) %>">
                                    <span>未通过审核</span></a></li>
                        </ul>
          <div class="tn-tabs-panel tn-widget-content tn-border-gray">
               <form id="ManageFileForm" method="post">
               <div class="tn-list-header">
                 <div class="tn-toolbar-area tn-helper-clearfix">
                      <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"title","审核通过选中的文件"}}, null)%>                                               
                      <%=SPBHtmlHelper.Instance().LinkButton("SetNoPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary{{"title","不审核通过选中的文件"}}, null)%>                                               
                      <%=SPBHtmlHelper.Instance().LinkButton("SetSiteCategories", "设置站点类别", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Set, TextIconLayout.IconText, new RouteValueDictionary { { "title", "设置站点类别" } }, null)%>
                       <%=SPBHtmlHelper.Instance().LinkButton("Delete", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,null, null)%>         
                      <%=SPBHtmlHelper.Instance().LinkButton("SetEssential", "设为精华", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Elite, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将选中的文件设为精华" } }, null)%>                                
                      <%=SPBHtmlHelper.Instance().LinkButton("CancelEssential", "取消精华", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将选中的文件取消精华" } }, null)%>                                
                      <%=SPBHtmlHelper.Instance().LinkButton("SetTop", "设为置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Top, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将选中的文件设为置顶" } }, null)%>                                
                       <%=SPBHtmlHelper.Instance().LinkButton("CancelTop", "取消置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", "将选中的文件取消置顶" } }, null)%>                                
                 </div>
               </div>
                                            
                     <div id="fragment-1">
                                <% Html.RenderAction<ManageFileController>(f => f.Control_ListFiles((AuditingStatusesForDisplay)AuditingStatuses, pageIndex)); %>
                     </div>
               </form>
                        </div>                      
     </div>   
    
 <script type="text/javascript">
     $(document).ready(function() {
         $("#ManageSearchForm").validate({
             rules: {
                 OwnerUserID: { digits: true }
             },
             messages: {
                 OwnerUserID: { digits: "请输入非负整数" }
             }
         });

         $("#searchButton").click(function() {
             if (!$("#ManageSearchForm").valid()) {
                 return false;
             }
         });


         $("#SetIsPassButton").click(function() {
             $('#ManageFileForm')
             .attr('action', '<%=Url.Action("UpdateFileAuditingStatus","ManageFile",new { returnUrl= Request.RawUrl,auditingStatus = AuditingStatusesForDisplay.Success }) %>')
             .submit();
         });
         $("#SetNoPassButton").click(function() {
             $('#ManageFileForm')
               .attr('action', '<%=Url.Action("UpdateFileAuditingStatus","ManageFile",new { returnUrl= Request.RawUrl,auditingStatus = AuditingStatusesForDisplay.Fail }) %>')
               .submit();
         });

         $("#Delete").click(function() {
             if (confirm('确实要删除吗？'))
                 $('#ManageFileForm')
               .attr('action', '<%=Url.Action("DeleteFiles","ManageFile",new { returnUrl= Request.RawUrl }) %>')
               .submit();
         });

         $("#SetEssential").click(function() {
             $('#ManageFileForm')
               .attr('action', '<%=Url.Action("SetEssential","ManageFile",new { returnUrl= Request.RawUrl}) %>')
               .submit();
         });

         $("#CancelEssential").click(function() {
             $('#ManageFileForm')
               .attr('action', '<%=Url.Action("CancelEssential","ManageFile",new { returnUrl= Request.RawUrl}) %>')
               .submit();
         });

         $("#SetTop").click(function() {
             $('#ManageFileForm')
               .attr('action', '<%=Url.Action("SetTop","ManageFile",new { returnUrl= Request.RawUrl}) %>')
               .submit();
         });

         $("#CancelTop").click(function() {
             $('#ManageFileForm')
               .attr('action', '<%=Url.Action("CancelTop","ManageFile",new { returnUrl= Request.RawUrl}) %>')
               .submit();
         });

         $("#SetSiteCategories").click(function() {
             $('#ManageFileForm')
             .attr('action', '<%=Url.Action("Control_SetSiteCategories", "ManageFile")%>')
             .nyroModalManual({
                 resizeable: true
             });
         });
     });
 </script>
</asp:content>
