﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<ForumPost>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <% 
        if (ViewData["SubMenu"] == null)
        {
            ViewData["SubMenu"] = ForumSubMenus.ManagePost;
        }
        ViewData.Add("ApplicationID", ApplicationIDs.Instance().Forum());
        Html.RenderPartial("Controls/Forums/ForumSubMenu.ascx", ViewData);     
    %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
回复审核管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Forum-ManageForumPosts"
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
    <spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
  
  <form id="searchpostsForm" method="post" action="<%=Url.Action("SearchPostForum","ManageForum") %>">
     <div class="tn-form-box tn-border-gray tn-border-bottom">
                <table>
                    <tr>                       
                        <th>
                            用户ID
                        </th>
                        <td>
                             <input name="searchUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="searchUserID" value="<%=Request.QueryString.GetString("userID", string.Empty) %>" />
                        </td>
               
                        <td>
                            <input id="searchButton" type="submit"  value="<%=GetResourceString("Button_Search")%>" />                      
                        </td>
                    </tr>
                </table>
      </div>
  </form>  
  <%AuditingStatusesForDisplay auditingStatusesForDisplay = ViewData.Get<AuditingStatusesForDisplay>("AuditingStatusesForDisplay"); %>
     <div class="tn-tabs tn-widget" id="imitateTabs">          
           <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay == AuditingStatusesForDisplay.Success){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumPosts", "ManageForum", new { auditingStatusesForDisplay = AuditingStatusesForDisplay.Success,userID=Request.QueryString.GetString("userID",string.Empty)})%>">
                            <span>已通过审核</span></a></li>
                              <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Pending){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumPosts", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Pending,userID=Request.QueryString.GetString("userID",string.Empty)})%>">
                            <span>待审核</span></a></li>
                              <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Again){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumPosts", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Again,userID=Request.QueryString.GetString("userID",string.Empty)})%>">
                            <span>需再审核</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Fail){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumPosts", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Fail,userID=Request.QueryString.GetString("userID",string.Empty)})%>">
                            <span>未审核</span></a></li>
                </ul>
           <div id="fragment-1" class="tn-tabs-panel tn-widget-content tn-border-gray" >
               <div class="containerCenter">
        <div class="containerArea">
            <div id="container-1">
                <%
                    StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData");
                    if (TempData["StatusMessageData"] != null)
                    {
                        SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 2000);
                        TempData["StatusMessageData"]=null;
                    }   
                %>
                <form id="postsForm" method="post">           
                <div class="tn-list-header">
                   <div class="tn-toolbar-area tn-helper-clearfix">
                    <%=SPBHtmlHelper.Instance().LinkButton("ApproveYes", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, null, null)%>     
                    <%=SPBHtmlHelper.Instance().LinkButton("ApproveNo", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, null, null)%>             
                    <%=SPBHtmlHelper.Instance().LinkButton("Delete", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,null, null)%>         
                   </div>
                 </div>                     
                  <table class="tn-table-grid">
                    <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom tn-text-note">                           
                                <input type="checkbox" onclick="checkAll(this,'postIDCheckBox')" class="tn-checkbox" />                           
                        </th>
                        <th  class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_Body")%>
                        </th>
                        <th  class="tn-border-gray tn-border-bottom tn-text-note">
                            作者
                        </th>                       
                        <th  class="tn-border-gray tn-border-bottom tn-text-note">
                            发帖日期
                        </th>
                        <th  class="tn-border-gray tn-border-bottom tn-text-note">
                            操作
                        </th>
                    </tr>
                    <%
                        foreach (var post in ViewData.Model.Records)
                        {%>
                    <tr class="tn-table-grid-row">                        
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <input type="checkbox" name="postIDCheckBox" value="<%=post.PostID%>" />
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=HtmlUtils.TrimHtml(post.Body,50) %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%if (post.UserID > 0)
                              { %>
                            <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(post.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                                <%=post.Author%></a>
                            <%
                                }
                              else
                              {
                                  Response.Write(post.Author);
                              }
                            %>
                        </td>                   
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%=Formatter.FormatDate(post.PostDate)%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                           <a href="#" onclick="if (confirm('确实删除该帖子吗？')){window.location.href='<%=this.Url.Action("DeleteForumPost", "ManageForum", new { postID = post.PostID })%>';return false;}"
                                    >删除</a>
                        </td>
                    </tr>
                    <%}%>
                </table>
              </form>
                <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
                  {%>
                <div class="tn-pagination tn-helper-align-center">
                        <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords,ViewData.Model.PageSize,ViewData.Model.PageIndex)%>                    
                   <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                </div>
                <%}%>             
            </div>
        </div>
    </div>
            </div>
          </div>
    <script type="text/javascript">
        $(document).ready(function() {

        $("#searchpostsForm").validate({
            rules: {
            searchUserID: { digits: true }
            },
            messages: {
            searchUserID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#searchpostsForm").valid()) {
                return false;
            }
        });
        
        
        $("#Delete").click(function() {
            if (confirm('确实删除选中的帖子吗？'))
                $('#postsForm')
            .attr('action', '<%=Url.Action("DeleteForumPosts","ManageForum") %>')
            .submit();
        });

        $("#ApproveYes").click(function() {
            $('#postsForm')
           .attr('action', '<%=SPBUrlHelper.Action("UpdatePostApproveStatus","ManageForum",new RouteValueDictionary {{"auditingStatus",AuditingStatuses.Success}}) %>')
           .submit();
        });
        $("#ApproveNo").click(function() {
            $('#postsForm')
           .attr('action', '<%=SPBUrlHelper.Action("UpdatePostApproveStatus","ManageForum",new RouteValueDictionary {{"auditingStatus",AuditingStatuses.Fail}}) %>')
           .submit();
        });
    });   
    </script>
</asp:content>
