﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<List<ForumThreadCategory>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <% 
        if (ViewData["SubMenu"] == null)
        {
            ViewData["SubMenu"] = ForumSubMenus.ManageSections;
        }
        ViewData.Add("ApplicationID", ApplicationIDs.Instance().Forum());
        Html.RenderPartial("Controls/Forums/ForumSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
主题分类
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Forum-ManageForumThreadCategories"
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData");
            //Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000));
        }
        ForumSection section = ViewData.Get<ForumSection>("section");
        if (section != null)
        {
            int sectionID = section.SectionID;
    %>
        <div id="container-1">
                <div id="fragment-1">
                               
                <div class="tn-text-heading tn-border-gray tn-border-bottom">
                            <strong>  <%=section.SectionName%>
                            <p class="tn-helper-right"><a  href="<%=SPBUrlHelper.Action("ManageForumSections","ManageForum") %>" title="返回版块管理">返回版块管理</a></p>
                             </strong>
                 </div>
                                
                 <div class="tn-list-header">
                   <div class="tn-toolbar-area tn-helper-clearfix">
                    <%=SPBHtmlHelper.Instance().LinkButton("nyroModal", "增加新分类", SPBUrlHelper.Action("Control_EditForumThreadCategory", "ManageForum", new RouteValueDictionary { { "sectionID", sectionID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>                   
                   </div>
                 </div>  
                    <table class="tn-table-grid">
                        <tr class="tn-table-grid-header">                            
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                分类名称
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_Description")%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                排列序号
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                操作
                            </th>
                        </tr>
                        <%
                            foreach (ForumThreadCategory category in Model)
                            {%>
                        <tr class="tn-table-grid-row">
                           
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=category.CategoryName%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=category.CategoryDescription%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=category.DisplayOrder%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                            <a  class="nyroModal submit" href="<%=SPBUrlHelper.Action("Control_EditForumThreadCategory", "ManageForum", new RouteValueDictionary { { "sectionID", sectionID },{"categoryID",category.CategoryID } })%>" title="编辑主题分类">编辑</a>
                            <a  href="<%=SPBUrlHelper.Action("DeleteForumThreadCategory", "ManageForum", new RouteValueDictionary { { "categoryID", category.CategoryID } })%>" onclick="if(!confirm('确认删除当前类别')) return false;" title="删除主题分类">删除</a>
                            </td>
                        </tr>
                        <%}%>
                    </table>
                </div>
            </div>
  
    <%}
        else
        { %>
        <div class="errorHint round">抱歉，找不到sectionID 为<%=Request.QueryString.Get("sectionID",0) %>的版块，请<a href="<%=SPBUrlHelper.Action("ManageForumSections","ManageForum") %>" title="返回版块管理">返回版块管理</a></div>
    <%} %>
</asp:content>
