﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<ForumThread>>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
    <% 
        if (ViewData["SubMenu"] == null)
        {
            int presentAreaID = Html.GetParameterFromRouteDateOrQueryString("presentAreaID", PresentAreaIDs.Instance().Channel());
            if (presentAreaID == PresentAreaIDs.Instance().Channel())
                ViewData["SubMenu"] = ForumSubMenus.ManageThread;
            else
                ViewData["SubMenu"] = ForumSubMenus.ManageClubThread;
        }
        ViewData.Add("ApplicationID", ApplicationIDs.Instance().Forum());
        Html.RenderPartial("Controls/Forums/ForumSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
 <%
     int presentAreaID = Html.GetParameterFromRouteDateOrQueryString("presentAreaID", PresentAreaIDs.Instance().Channel());
     if (presentAreaID == PresentAreaIDs.Instance().Channel())
         Response.Write("独立论坛主题");
     else
         Response.Write("群组论坛主题");
      %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Forum-ManageForumThreads"
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
    <%
        int presentAreaID = Html.GetParameterFromRouteDateOrQueryString("presentAreaID", PresentAreaIDs.Instance().Channel());
        AuditingStatusesForDisplay auditingStatusesForDisplay = ViewData.Get<AuditingStatusesForDisplay>("AuditingStatusesForDisplay");
    %>                                                                                                               
    <form id="ManageSearchForm" method="post" action="<%=Url.Action("SearchThreadForum", "ManageForum", new { auditingStatusesForDisplay = auditingStatusesForDisplay, presentAreaID = presentAreaID })%>">
        <div class="tn-form-box tn-border-gray tn-border-bottom">
            <table>
                <tr>                       
                    <th>
                        用户ID
                    </th>
                    <td>
                         <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("userID", string.Empty)%>" id="userID" />
                    </td>
                     <th>
                        帖子名称
                    </th>
                    <td>
                         <input name="subjectKeyword" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("subjectKeyword",string.Empty) %>" id="subjectKeyword" />
                    </td>
                    <td>
                       <input id="searchButton" type="submit"  value="<%=GetResourceString("Button_Search")%>" />
                    </td>
                </tr>
            </table>
      </div>
    </form>
        <div class="tn-tabs tn-widget" id="imitateTabs">          
                <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay == AuditingStatusesForDisplay.Success){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumThreads", "ManageForum", new { auditingStatusesForDisplay = AuditingStatusesForDisplay.Success, presentAreaID = presentAreaID,userID=Request.QueryString.GetString("userID",string.Empty),subjectKeyword=Request.QueryString.GetString("subjectKeyword",string.Empty)})%>">
                            <span>已通过审核</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Pending){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumThreads", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Pending, presentAreaID = presentAreaID,userID=Request.QueryString.GetString("userID",string.Empty),subjectKeyword=Request.QueryString.GetString("subjectKeyword",string.Empty)})%>">
                            <span>待审核</span></a></li>
                              <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Again){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumThreads", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Again, presentAreaID = presentAreaID,userID=Request.QueryString.GetString("userID",string.Empty),subjectKeyword=Request.QueryString.GetString("subjectKeyword",string.Empty)})%>">
                            <span>需再审核</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatusesForDisplay ==AuditingStatusesForDisplay.Fail){Response.Write(" tn-tabs-selected");} %>">
                        <a href="<%=this.Url.Action("ManageForumThreads", "ManageForum", new { auditingStatusesForDisplay =AuditingStatusesForDisplay.Fail, presentAreaID = presentAreaID,userID=Request.QueryString.GetString("userID",string.Empty),subjectKeyword=Request.QueryString.GetString("subjectKeyword",string.Empty)})%>">
                            <span>未审核</span></a></li>
                </ul>
                <div id="fragment-1" class="tn-tabs-panel tn-widget-content tn-border-gray" >
                    <form id="newsForm" method="post">    
                   <div class="tn-list-header">
                     <div class="tn-toolbar-area tn-helper-clearfix">
                       <%=SPBHtmlHelper.Instance().LinkButton("ApproveYes", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, null, null)%>         
                       <%=SPBHtmlHelper.Instance().LinkButton("ApproveNo", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, null, null)%>         
                     </div>
                   </div> 
                    <table class="tn-table-grid">
                        <tr class="tn-table-grid-header">
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <span class="tn-checkbox">
                                    <input type="checkbox" onclick="checkAll(this,'newsCheckBoxGroup')" />
                                </span>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_Subject")%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                群组或版块组
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                所属版块
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                作者
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                浏览次数
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                回复数量
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                是否精华
                            </th>                            
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                发帖日期
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                操作
                            </th>
                        </tr>
                        <%
                            foreach (var thread in ViewData.Model.Records)
                            {%>
                        <tr class="tn-table-grid-row">                           
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <input type="checkbox" name="newsCheckBoxGroup" value="<%=thread.ThreadID%>" />
                            </td>
                           
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                              
                                     <a target="_blank" href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread) %>">
                                    <%=StringUtils.Trim(thread.Subject, 20)%></a>    
                                                            
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <% ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
                                   if (group != null)
                                   {%>
                                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumSectionGroupInPresentArea(group)%>">
                                    <%=group.GroupName%></a>                          
                                    <%} %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">   
                                       <% if (thread.ForumSection != null)
                                          { %>            
                                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumSectionInPresentArea(thread.ForumSection) %>">
                                   <%=thread.ForumSection.SectionName%></a>  
                                                  <%} %>
                            </td>
                    
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%if (thread.UserID > 0)
                                  {%>
                                <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                                    <%=thread.Author%></a>
                                <%}
                                  else { Response.Write(thread.Author); } %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=thread.HitTimes%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=thread.ReplyCount %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%if (thread.IsEssential)
                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                  else
                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                            </td>                           
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                <%=Formatter.FormatDate(thread.PostDate)%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <a class="nyroModal submit" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Forum(),thread.UserID,thread.ThreadID,thread.Subject) %>">
                             推荐</a>
                            </td>
                        </tr>
                        <%}%>
                    </table>
                    </form>
                    <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
                      {%>
                    <div class="tn-pagination tn-helper-align-center">
                            <%= SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords,ViewData.Model.PageSize,ViewData.Model.PageIndex)%>                        
                       <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                    </div>
                    <%}%>                    
                </div>          
        </div>      
       
   <script type="text/javascript">
       $(document).ready(function() {
       $("#ManageSearchForm").validate({
           rules: {
           userID: { digits: true }
           },
           messages: {
           userID: { digits: "请输入非负整数" }
           }
       });

       $("#searchButton").click(function() {
           if (!$("#ManageSearchForm").valid()) {
               return false;
           }
       });
       
           $("#ApproveYes").click(function() {
               $('#newsForm')
            .attr('action', '<%=SPBUrlHelper.Action("UpdateThreadApproveStatus", "ManageForum", new RouteValueDictionary { { "auditingStatus", AuditingStatusesForDisplay.Success }})%>')
            .submit();
           });

           $("#ApproveNo").click(function() {
               $('#newsForm')
           .attr('action', '<%=SPBUrlHelper.Action("UpdateThreadApproveStatus", "ManageForum", new RouteValueDictionary { { "auditingStatus", AuditingStatusesForDisplay.Fail } })%>')
           .submit();
           });
       });   
    </script>
</asp:content>
