﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="layout" Src="~/Utility/jquery/plugin/jquery.layout.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
</spb:Header>
<script type="text/javascript">
    $(document).ready(function () {
        $('body').layout({ applyDefaultStyles: false });
        $(".tn-collapsible").collapsibleBox();
    });
</script>
<body class="tn-page-bg" id="tn-manages-homepage">
    <div class="ui-layout-center ui-layout-pane ui-layout-pane-center open" pane="center"
        style="visibility: visible; display: block; position: absolute; margin: 0px;
        z-index: 2; left: 0px; right: 0px; top: 54px; bottom: 0px; height: 381px; width: 1440px;">
        <div class="tn-main">
            <div class="tn-head">
                <div class="tn-widget spb-pending">
                    <div class="tn-cue-highlight tn-corner-all tn-message-box">
                        <h4>
                            待处理事项</h4>
                        <ul id="service">
                        </ul>
                    </div>
                </div>
            </div>
            <div class="tn-body">
                <div class="tn-text-heading tn-border-gray tn-border-bottom">
                    <strong>内容管理</strong></div>
                <table>
                    <tbody>
                        <%if (ViewData["DicApp"] != null)
                          {%>
                        <tr>
                            <%
                              int i = 0;
                              Dictionary<int, Application> appsDictionary = ViewData["DicApp"] as Dictionary<int, Application>;

                              foreach (var application in appsDictionary.Values)
                              {
                                  if (!application.IsEnabled || application.Configuration == null || application.IsLocked)
                                      continue;
                                  string url = SPBUrlHelper.RouteUrl(application.Configuration.ManageableCountRouteName);
                            %>
                            <td>
                                <% string app = application.ApplicationKey.ToLower(); %>
                                <span class="tn-icon-32 tn-icon-32-<%=app %>"></span><strong>
                                    <%=application.GetMultilingualApplicationName(CurrentUserLanguage) %></strong>
                                <ul id="app_<%=application.ApplicationKey %>" value="<%=url %>">
                                </ul>
                            </td>
                            <% i++;
                               if (i % 2 == 0 && i > 0 && i < appsDictionary.Count)
                               { %>
                        </tr>
                        <tr>
                            <%}
                            %>
                            <%}%>
                        </tr>
                        <%
                          } %>
                    </tbody>
                </table>
            </div>
            <div class="tn-foot">
                <div class="tn-text-heading tn-border-gray tn-border-bottom">
                    <strong>版本信息</strong></div>
                <p class="tn-text-note">
                    <small>版本：<%=string.Format("{0}({1})", SPBConfig.Instance().SpaceBuilderVersionInfo, SPBConfig.Instance().SpaceBuilderVersion)%></small>
                    <%if (SPBConfig.Instance().NewVersionAvailable() && SPBConfig.Instance().EnableLatestVersionCheck)
                      {%>
                    <small>最新：<%=string.Format("{0}({1}) </small><small>请到产品<a href=\"{2}\" target=\"_blank\">Spacebuilder 官方网站</a>进行新版本下载", SPBConfig.Instance().MostRecentVersionInfo, SPBConfig.Instance().MostRecentVersion, "http://www.spacebuilder.cn")%>
                    </small>
                    <%}%>
                </p>
            </div>
        </div>
    </div>
    <div class="ui-layout-north">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <div class="tn-top-menubar">
                    <div class="tn-wrapper-inner tn-helper-clearfix">
                        <div class="tn-user-menu">
                            <ul>
                                <li><a href="<%=Url.Action("ManageLogout","Manage") %>">退出</a></li>
                                <li><a href="<%=SiteUrls.Instance().Home() %>">返回前台</a></li>
                                <li>当前登录：<strong><%=Globals.GetCurrentUser().UserName %></strong> </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="tn-branding-area">
                    <div class="tn-wrapper-inner">
                        <div id="tn-logo">
                            <a href="<%=SiteUrls.Instance().ManageHome() %>" id="siteLogo">
                                <img src="<%=WebUtils.ResolveUrl("~/Themes/Manages/Default/Appearances/Default/Images/manage-logo.png") %>" /></a>
                        </div>
                    </div>
                </div>
                <div class="tn-nav1-area">
                    <div class="tn-wrapper-inner tn-helper-clearfix">
                        <% if (ViewData["manageSubMenu"] == null)
                               ViewData["manageSubMenu"] = ManageSubMenu.ManageHome;
                           Html.RenderPartial("Controls/ManageGlobalMenu.ascx", ViewData); %>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
<script type="text/javascript">

    $(document).ready(function () {
        $.getJSON('<%=Url.Action("GetManageableCounts", "Manage") %>', function (data) {
            $(data).each(function () {
                $('#service').append(" <li><a href='" + this.Url + "'><strong>" + this.Value + "</strong></a>" + this.Name + "</li>");
            });
        });

        $("ul[id^='app_']").each(function () {
            var $this = $(this);
            $.getJSON($this.attr("value"), function (data) {
                $(data).each(function () {
                    if (this.Url)
                    { $this.append("<li>" + this.Name + "：<em> <a href='" + this.Url + "'>" + this.Value + "</a> </em></li>"); }
                    else
                        $this.append("<li>" + this.Name + "：<em>" + this.Value + "</em></li>");
                });

            });
        });
    });
</script>
</html>
