﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<ListingThread>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
招贴管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Listing-ManageListings"
</asp:content>
<asp:content runat="server" contentplaceholderid="HeaderContent">
    <% ViewData["SubMenu"] = ListingManageSubMenus.ManageListings;%>
    <% Html.RenderPartial("Controls/Listings/ListingSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
    <%AuditingStatuses auditingStatus = (AuditingStatuses)ViewData["auditingStatus"];%>
<form id="ManageSearchForm" method="post" action="<%=Url.Action("SearchThreads","ManageListing") %>">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
        <tr>
            <td>关键字</td>
            <td><input name="keyword" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="keyword" value="<%=Html.GetParameterFromRouteDateOrQueryString("keyword") %>" /></td>
            <td>用户ID</td>
            <td><input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<%=Html.GetParameterFromRouteDateOrQueryString("userID") %>" /></td>            
            <td>招贴类别</td>                  `
            <td><% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Listing(), ViewData.GetInt("categoryDepth", 1), "categoryID", Request.QueryString.GetInt("categoryID", -1), "tn-dropdownlist")); %></td>
            <td>地区</td>
            <td><% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", ListingConfiguration.Instance().RootAreaCode, Request.QueryString.GetString("areaCode", string.Empty), ListingConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %></td>
            <td>审核状态</td>
            <td>
                <select name="auditingStatus" class="tn-dropdownlist" id="auditingStatus">
                <option value="-1">全部招贴</option>
                    <option value="<%=(int)AuditingStatuses.Success %>" <% if(auditingStatus==AuditingStatuses.Success) Response.Write("selected"); %>>
                        已通过审核</option>
                    <option value="<%=(int)AuditingStatuses.Fail %>" <% if(auditingStatus==AuditingStatuses.Fail) Response.Write("selected"); %>>
                        未通过审核</option>
                    <option value="<%=(int)AuditingStatuses.Again %>" <% if(auditingStatus==AuditingStatuses.Again) Response.Write("selected"); %>>
                        需再审核</option>
                    <option value="<%=(int)AuditingStatuses.Pending %>" <% if(auditingStatus==AuditingStatuses.Pending) Response.Write("selected"); %>>
                        待审核</option>
                </select>
            </td>
            <td>活跃状态</td>
            <td>
                <select name="isActive" class="tn-dropdownlist" id="isActive">
                    <option value="" <%if (Request.QueryString["isActive"] == "") { Response.Write("selected"); } %>>
                        所有</option>
                    <option value="true" <%if (Request.QueryString.GetBool("isActive", false)) { Response.Write("selected"); } %>>
                        活跃</option>
                    <option value="false" <%if (!Request.QueryString.GetBool("isActive", true)) { Response.Write("selected"); } %>>
                        过期</option>
                </select>
            </td>
            <td>
                <input id="searchButton" type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
            </td>
           </tr>
        </table>
    </div>
</form>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
     <li class="tn-widget-content tn-border-gray tn-border-trl <%if((int)auditingStatus == -1){Response.Write(" tn-tabs-selected");} %>">
            <a href="<%=this.Url.Action("ManageListings", "ManageListing", new { auditingStatus = -1,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword"),userID=Html.GetParameterFromRouteDateOrQueryString("userID"),categoryID= Request.QueryString.GetInt("categoryID", -1),areaCode=Request.QueryString.GetString("areaCode",string.Empty),isActive=Request.QueryString.GetString("isActive", "")})%>">
                <span>全部招贴</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if(auditingStatus == AuditingStatuses.Success){Response.Write(" tn-tabs-selected");} %>">
            <a href="<%=this.Url.Action("ManageListings", "ManageListing", new { auditingStatus = AuditingStatuses.Success,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword"),userID=Html.GetParameterFromRouteDateOrQueryString("userID"),categoryID= Request.QueryString.GetInt("categoryID", -1),areaCode=Request.QueryString.GetString("areaCode",string.Empty),isActive=Request.QueryString.GetString("isActive", "")})%>">
                <span>已通过审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl<%if(auditingStatus == AuditingStatuses.Pending){Response.Write(" tn-tabs-selected");} %>">
            <a href="<%=this.Url.Action("ManageListings", "ManageListing", new { auditingStatus = AuditingStatuses.Pending,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword"),userID=Html.GetParameterFromRouteDateOrQueryString("userID"),categoryID= Request.QueryString.GetInt("categoryID", -1),areaCode=Request.QueryString.GetString("areaCode",string.Empty),isActive=Request.QueryString.GetString("isActive", "")})%>">
                <span>待审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl<%if(auditingStatus ==AuditingStatuses.Again){Response.Write(" tn-tabs-selected");} %>">
            <a href="<%=this.Url.Action("ManageListings", "ManageListing", new { auditingStatus = AuditingStatuses.Again,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword"),userID=Html.GetParameterFromRouteDateOrQueryString("userID"),categoryID= Request.QueryString.GetInt("categoryID", -1),areaCode=Request.QueryString.GetString("areaCode",string.Empty),isActive=Request.QueryString.GetString("isActive", "")})%>">
                <span>需再审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl<%if(auditingStatus == AuditingStatuses.Fail){Response.Write(" tn-tabs-selected");} %>">
            <a href="<%=this.Url.Action("ManageListings", "ManageListing", new { auditingStatus = AuditingStatuses.Fail,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword"),userID=Html.GetParameterFromRouteDateOrQueryString("userID"),categoryID= Request.QueryString.GetInt("categoryID", -1),areaCode=Request.QueryString.GetString("areaCode",string.Empty),isActive=Request.QueryString.GetString("isActive", "")})%>">
                <span>未通过审核</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
       <form id="listingForm" method="post" action="">
       <div class="tn-list-header">
           <div class="tn-toolbar-area tn-helper-clearfix">
               <%if (auditingStatus != AuditingStatuses.Success)
                 { %>
               <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText,
               new RouteValueDictionary{{"onclick"," $('#listingForm').attr('action','"+Url.Action("UpdateAuditingStatuses","ManageListing",new {isPass=true})+"');$('#listingForm').submit();return false;"},{"title","把选中的招贴通过审核"}}, null)%>
               <%}
                 if (auditingStatus != AuditingStatuses.Fail)
                 {%>
               <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                 new RouteValueDictionary { { "onclick", "$('#listingForm').attr('action','" + Url.Action("UpdateAuditingStatuses","ManageListing",new {isPass=false}) + "');$('#listingForm').submit();return false;" }, { "title", "把选中的招贴不通过审核" } }, null)%>
               <%}%>
            
                 <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "设为置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Top, TextIconLayout.IconText,
                 new RouteValueDictionary { { "onclick", "$('#listingForm').attr('action','" + Url.Action("Control_EditStickyDate", "ManageListing") + "');modalsubmit();$('#listingForm').submit();return false;" }, { "title", "设为置顶" } }, null)%>
              
               <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "取消置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
               new RouteValueDictionary { { "onclick", "if (confirm('将选中的招贴信息取消置顶？')) { $('#listingForm').attr('action','" + Url.Action("CancelSticky", "ManageListing") + "');$('#listingForm').submit();return false;}else {  return false; };" }, { "title", "取消置顶" } }, null)%>
               <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
               new RouteValueDictionary { { "onclick", "if (confirm('确认要删除选中的招贴吗？')) { $('#listingForm').attr('action','" + Url.Action("DeleteThreads", "ManageListing") + "');$('#listingForm').submit();return false;}else {  return false; };" }, { "title", "删除选中的招贴" } }, null)%>

           </div>
       </div>
       <table class="tn-table-grid">
           <tr class="tn-table-grid-header">
               <th class="tn-border-gray tn-border-bottom">
                 <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   <%=GetResourceString("Label_Subject")%>
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   作者
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   类别
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   地区
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   置顶
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   <%=GetResourceString("Label_PostDate")%>
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   截止日期
               </th>
               <th class="tn-border-gray tn-border-bottom tn-text-note">
                   操作
               </th>
           </tr>
           <%foreach (var thread in ViewData.Model.Records)
             {%>
           <tr class="tn-table-grid-row">
               <td class="tn-border-gray tn-border-bottom tn-width-check">
                   <input type="checkbox" class="tn-checkbox" name="CheckBoxGroup" value="<%=thread.ThreadID %>" />
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-auto">
                   <a target="_blank" href="<%=SiteUrls.Instance().ShowListingThread(thread.ThreadID) %>">
                       <%=StringUtils.Trim(thread.Title,7) %></a>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                   <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.OwnerUserID,ApplicationIDs.Instance().Listing()) %>">
                       <%=StringUtils.Trim(thread.Author,10) %></a>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                   <%if (thread.Category != null)
                     {%>
                   <a target="_blank" href="<%=this.Url.Action("ListingThread", "ChannelListing", new { categoryID = thread.CategoryID })%>">
                       <%if (thread.Category != null) { Response.Write(StringUtils.Trim(thread.Category.CategoryName, 10)); }%>
                   </a>
                   <%} %>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-auto">
                   <a target="_blank" href="<%=this.Url.Action("Home", "ChannelListing", new { areaCode = thread.AreaCode })%>">
                       <%=Formatter.FormatArea(thread.AreaCode,true) %>
                   </a>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                   <%if (thread.SpecialOrder > 0)
                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                     else
                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                   <%=Formatter.FormatDate(thread.PostDate)%>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                   <%=Formatter.FormatDate(thread.EndDate)%>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                   <a target="_blank"  href="<%=this.Url.Action("EditListing", "ChannelListing", new { threadID = thread.ThreadID })%>">
                       编辑</a> <a  href="javascript:;" onclick="if (confirm('确定要删除该招贴信息吗？')) {window.location.href='<%=this.Url.Action("DeleteThread", "ManageListing", new {threadID=thread.ThreadID }) %>'}">
                           删除</a>
               </td>
           </tr>
           <%}%>
       </table>
       </form>
        <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
          {%>
        <div class="tn-pagination tn-helper-align-center">
                <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords,ViewData.Model.PageSize,ViewData.Model.PageIndex)%>
            
            <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
        <%}%>
    </div>
</div>

 <script type="text/javascript">
     function modalsubmit() {

         $(function() {
             $('#listingForm').submit(function(e) {
                 e.preventDefault();
                 $('#listingForm').nyroModalManual({
                     resizeable: true
                 });
                 return false;
             });
         });
     }
     $(document).ready(function() {
         $("#ManageSearchForm").validate({
             rules: {
                 userID: { digits: true }
             },
             messages: {
                 userID: { digits: "请输入非负整数" }
             }
         });

         $("#searchButton").click(function() {
             if (!$("#ManageSearchForm").valid()) {
                 return false;
             }
         });
     });
 </script>

 
</asp:content>
