﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>后台管理登录</title>
    <spb:Header ID="Header1" runat="server">
        <spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/jquery.min-1.4.2.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="Script2" Src="~/Utility/jquery/plugin/jquery.cookie.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="Script3" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
            SetExpireDays="30" />
        <spb:Script runat="server" ID="Script4" Src="~/Utility/tunynet_web_ui/global.js" />
        <spb:Script runat="server" ID="Script5" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
        <spb:Script runat="server" ID="Script6" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
            SetExpireDays="30" />
    </spb:Header>
</head>
<body id="manageLogin">
    <div id="tn-doc">
        <div id="tn-content">
            <div class="tn-wrapper">
                <div class="tn-login-panel tn-helper-clearfix">
                    <div id="tn-logo">
                        <a href="<%=SiteUrls.Instance().Home() %>">
                            <img src="<%=WebUtils.ResolveUrl("~/Themes/Manages/Default/Appearances/Default/Images/manage-logo.png")%>"
                                alt="spacebuilder"></a>
                    </div>
                    <div class="tn-login-form">
                        <%   
                            if (TempData["StatusMessageType"] != null)
                            {
                                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), new RouteValueDictionary { { "style", "width:160px" } }));
                                TempData["StatusMessageType"] = null;
                            }   
                        %>
                        <div class="tn-form-box">
                            <form method="post" class="tn-helper-reset" id="loginForm" name="loginForm" action="<%=Url.Action("ManageLoginAction","Manage",new { returnUrl=ViewData.GetString("returnUrl","") }) %>">
                            <div class="tn-form tn-label-right">
                                <div class="tn-form-row">
                                    <label class="tn-form-label">
                                        账号：</label>
                                    <input name="userName" type="text" maxlength="64" id="userName" class="tn-textbox tn-input-medium tn-border-gray"
                                        value="<%=TempData.GetString("userName",string.Empty) %>" />
                                </div>
                                <div class="tn-form-row">
                                    <label class="tn-form-label">
                                        密码：</label>
                                    <input name="password" type="password" maxlength="64" id="password" class="tn-textbox tn-input-medium tn-border-gray"
                                        value="<%=TempData.GetString("password",string.Empty) %>" />
                                </div>
                                <div class="tn-form-row tn-form-row-verifycode">
                                    <label class="tn-form-label">
                                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
                                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Normal,true)%>
                                </div>
                                <div class="tn-form-row tn-form-row-button">
                                    <label class="tn-form-label">
                                    </label>
                                    <%=SPBHtmlHelper.Instance().SubmitButton("loginButton", "登录", ButtonSizes.Default,null,null)%>
                                    <%=SPBHtmlHelper.Instance().LinkButton("gohome", "返回前台", SiteUrls.Instance().Home(), ButtonSizes.Default, HighlightStyles.Secondary)%>
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="tn-footer">
            <div class="tn-wrapper">
             <div class="tn-footer-legal">
                <%Html.RenderPartial("Controls/Footer.ascx");%>
              </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#password").focus(function() {
                // $("#verifyCode").focus();

            });
            $("#userName").watermark("输入用户名或Email");

            $("#loginForm").validate({
                rules: {
                    userName: "required",
                    password: "required",
                    verifyCode: "required"
                },
                messages: {
                    userName: "请输入用户名或者Email",
                    password: "请填写密码",
                    verifyCode: "请填写验证码"
                }
            });

            $("#loginForm").submit(function() {
                if (!$("#loginForm").valid()) {
                    return false;
                }
            });
        });
    </script>

</body>
</html>
