﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content contentplaceholderid="pageNameContent" runat="server"> 添加用户 </asp:content>
<asp:content id="Content2" contentplaceholderid="HeaderContent" runat="server">
  <%
      ViewData["UserMenu"] = UserSubMenu.ManageCompanyUsers;
      Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <% if (TempData["StatusMessageType"] != null)
     {
         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
         TempData["StatusMessageType"] = null;
     }
     CompanyUser cu = new CompanyUser();
     int applicationID = ApplicationIDs.Instance().User();
     if (TempData["companyUser"] != null)
         cu = TempData["companyUser"] as CompanyUser;     
      %>
  <form id="RegisterForm" action="<%=Url.Action("AddCompanyUserAction","ManageUser") %>"
    method="post">
    <div class="tn-form-box">
      <table>
        <tr>
          <th> 用户名： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="userName" name="userName" value="<%=TempData.GetString("userName",string.Empty ) %>"
                            maxlength="25" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> </th>
          <td><span style="display: none" id="usernameMessageError"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Cross, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline " } })%> </span><span style="display: none" id="usernameMessageSuccess"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Accept, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline " } })%> </span><span id="usernameMessageNormal">建议用户名以英文字母开头，并只包含字母或者数字,注册成功后不可更改</span></td>
        </tr>
        <tr>
          <th> 密码： </th>
          <td><input type="password" id="password" name="password" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th></th>
          <td><span style="display: none" id="passwordMessageError"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Cross, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline " } })%> </span><span style="display: none" id="passwordMessageSuccess"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Accept, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline " } })%> </span><span id="passwordMessageNormal">建议密码设置6位以上，并且包含：&、*、#、@等特殊字符 </span></td>
        </tr>
        <tr>
          <th> 密码确认： </th>
          <td><input type="password" id="password2" name="password2" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 账号信箱： </th>
          <td><input type="text" id="email" name="email" class="tn-textbox tn-input-long tn-border-gray" value="<%=TempData.GetString("email",string.Empty) %>"
                            maxlength="100" />
            <em>*</em></td>
        </tr>
        <tr>
          <th></th>
          <td> 帐号信箱是您忘记密码后重新获取密码的唯一途径，该邮箱不会公开。 </td>
        </tr>
        <tr>
          <th> 企业名称： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="CommonName" name="CommonName" value="<%=TempData.GetString("CommonName",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 营业执照号： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Licence" name="Licence" value="<%=TempData.GetString("Licence",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <%
            IDictionary<int, CodeItem> dicCompanyPropertys = null;
            IDictionary<int, CodeItem> Funds = null;
            IDictionary<int, CodeItem> EmployeeCounts = null;
            IDictionary<int, CodeItem> Trades = null;
            if (ViewData["CompanyPropertys"] != null)
            {
                dicCompanyPropertys = ViewData["CompanyPropertys"] as Dictionary<int, CodeItem>;
            }
            if (ViewData["Trades"] != null)
            {
                Trades = ViewData["Trades"] as Dictionary<int, CodeItem>;
            }
            if (ViewData["Funds"] != null)
            {
                Funds = ViewData["Funds"] as Dictionary<int, CodeItem>;
            }
            if (ViewData["EmployeeCounts"] != null)
            {
                EmployeeCounts = ViewData["EmployeeCounts"] as Dictionary<int, CodeItem>;
            }

                %>
        <tr>
          <th> 所属行业： </th>
                    <td>
          <%=SPBHtmlHelper.Instance().ShowDropDownList("Trades", Trades.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.Trade)%> 
          </td>
        </tr>
        <tr>
          <th> 所在地区： </th>
          <td><% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", UserDomainConfiguration.Instance().RootAreaCode, ViewData.GetString("areaCode", string.Empty), UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %></td>
        </tr>
        <tr>
          <th> 公司性质： </th>
                    <td>
          <%=SPBHtmlHelper.Instance().ShowDropDownList("CompanyPropertys", dicCompanyPropertys.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.CompanyProperty)%>
          </td>
        </tr>
        <tr>
          <th> 注册资金： </th>
                    <td>
           <%=SPBHtmlHelper.Instance().ShowDropDownList("Funds", Funds.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.Fund)%>
          </td>
        </tr>
        <tr>
          <th> 公司规模： </th>
          <td><%=SPBHtmlHelper.Instance().ShowDropDownList("EmployeeCounts", EmployeeCounts.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.EmployeeNum)%></td>
        </tr>
        <tr>
          <th> 联系人： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Linkman" name="Linkman" value="<%=TempData.GetString("Linkman",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 联系人职位： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="LinkmanDuty" name="LinkmanDuty" value="<%=TempData.GetString("LinkmanDuty",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 联系电话： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="LinkTel" name="LinkTel" value="<%=TempData.GetString("LinkTel",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 传真： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Fax" name="Fax" value="<%=TempData.GetString("Fax",string.Empty) %>"
                            maxlength="64" /></td>
        </tr>
        <tr>
          <th> 通讯地址： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Address" name="Address" value="<%=TempData.GetString("Address",string.Empty) %>"
                            maxlength="64" />
            <em>*</em></td>
        </tr>
        <tr>
          <th> 简介： </th>
          <td><div class="tn-textarea-wrap"><textarea name="Intro" id="Intro" class="tn-textarea tn-input-longest tn-border-gray" cols="30" rows="4"></textarea>
          <span style="display:none"></span></div>
          </td>
        </tr>
        <tr>
          <th></th>
          <td> 请简单介绍一下您的公司 </td>
        </tr>
        <tr>
          <th>&nbsp; </th>
          <td><%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_Cancel"),Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary, null, TextIconLayout.TextOnly)%>
            <%} %></td>
        </tr>
      </table>
    </div>
  </form>
  <script type="text/javascript">
      $(document).ready(function () {
          //$('div.toggler-1').toggleElements();
          $("#RegisterForm").validate({
              rules: {
                  userName: { required: true },
                  password: { required: true },
                  password2: { equalTo: "#password" },
                  email: { required: true, email: true },
                  Licence: { required: true, maxBlength: 40 },
                  Trades: { required: true, min: 1 },
                  areaCode: { required: true, min: 1 },
                  CompanyPropertys: { required: true, min: 1 },
                  Funds: { required: true, min: 1 },
                  EmployeeCounts: { required: true, min: 1 },
                  Linkman: { required: true },
                  LinkTel: { required: true },
                  CommonName: { required: true },
                  Address: { required: true }
              },
              messages: {
                  userName: { required: "请输入姓名" },
                  password: { required: "请输入密码" },
                  password2: { equalTo: "两次输入的密码不一致" },
                  email: { required: "请输入电子邮箱地址", email: "你输入的邮箱地址格式不正确，请重新输入" },
                  Licence: { required: "请输入您的营业执照号码", maxBlength: "最多输入40个字" },
                  Trades: { required: "请选择一个行业", min: "请选择一个行业" },
                  areaCode: { required: "请选择你所在的地区", min: "请选择你所在的地区" },
                  CompanyPropertys: { required: "请选择你的公司性质", min: "请选择你的公司性质" },
                  Funds: { required: "请选择公司的注册资金", min: "请选择公司的注册资金" },
                  EmployeeCounts: { required: "请选择你的公司规模", min: "请选择你的公司规模" },
                  Linkman: { required: "请输入联系人姓名" },
                  LinkTel: { required: "请输入联系人电话" },
                  CommonName: { required: "请输入企业名称" },
                  Address: { required: "请输入联系地址" }
              }
          });
          $("#createButton").click(function () {
              if (!$("#RegisterForm").valid()) {
                  return false;
              }
              else {
                  $("#createButton").hide();
                  $("#saveButtonA").show();
              }
          });
          $("#usernameMessageSuccess").hide();
          $("#usernameMessageError").hide();
          $("#passwordMessageSuccess").hide();
          $("#passwordMessageError").hide();
          $("#userName").blur(function () {
              if ($('#userName').attr("value"))
                  $.getJSON('<%=Url.Action("ValidateUserName","ChannelUser") %>', { userName: $('#userName').attr("value") }, function (data) {
                      $("#usernameMessageNormal").text(data.messageContent);
                      if (data.isSuccess) {
                          $("#usernameMessageSuccess").show();
                          $("#usernameMessageError").hide();
                          $("#createButton").removeAttr("disabled");
                      }
                      else {
                          $("#usernameMessageError").show();
                          $("#usernameMessageSuccess").hide();
                          $("#createButton").attr("disabled", true);
                      }
                  });
          });
          $("#password").blur(function () {
              if ($('#password').attr("value"))
                  $.getJSON('<%=Url.Action("ValidatePassword","ChannelUser") %>', { password: $('#password').attr("value") }, function (data) {
                      $("#passwordMessageNormal").text(data.messageContent);
                      if (data.isSuccess) {
                          $("#passwordMessageSuccess").show();
                          $("#passwordMessageError").hide();
                          $("#createButton").removeAttr("disabled");
                      }
                      else {
                          $("#passwordMessageError").show();
                          $("#passwordMessageSuccess").hide();
                          $("#createButton").attr("disabled", true);
                      }
                  });
          });
      });
    </script>
</asp:content>
