﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
添加用户
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%
        ViewData["UserMenu"] = UserSubMenu.ManagePersonUsers;
        Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }
    %>
    <form id="EditUserForm" action="<%=Url.Action("CreateUser","ManageUser") %>" method="post">
    <div class="tn-form-box">
    <table>
                <tr>
                    <th>
                        用户名：
                    </th>
                    <td>
                        <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="userName" name="userName" value="<%=TempData.GetString("userName",string.Empty ) %>"
                            maxlength="25" />
                    </td>
                    </tr>
                    <tr>
                    <th></th>
                    <td>
                        <span id="usernameMessageError">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.CrossCircle,"不通过",new RouteValueDictionary{{"class","tn-icon-inline"}}) %>
                        </span>
                        <span id="usernameMessageSuccess">
                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.AcceptCircle,"通过",new RouteValueDictionary{{"class","tn-icon-inline"}}) %>
                        </span>
                        <span id="usernameMessageNormal">用户名至少填写3位,必须为英文字母开头,只能含有字母或者数字,注册成功后不可更改</span>
                    </td>
                </tr>
                <tr>
                    <th>
                        密码：
                    </th>
                    <td>
                        <input type="password" id="password" name="password" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
                    </td>
                    </tr>
                    <tr>
                    <th></th>
                    <td>
                        <span id="passwordMessageError">
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/exclamation.gif") %>" />
                        </span><span id="passwordMessageSuccess">
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif") %>" />
                        </span><span id="passwordMessageNormal">建议密码设置6位以上，并且不包含：&、*、#、@等特殊字符 </span>
                    </td>
                </tr>
                <tr>
                    <th>
                        密码确认：
                    </th>
                    <td>
                        <input type="password" id="password2" name="password2" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
                    </td>
                </tr>
                   <tr>
                    <th>
                        是否管制：
                    </th>
                    <td>
                     <input id="IsModerated_true" class="tn-radiobutton" name="IsModerated" type="radio"
             value="true" />是&nbsp;<input
                name="IsModerated" class="tn-radiobutton" id="IsModerated_false" type="radio" checked="checked"
                value="false" />否
                       
                    </td>
                </tr>
                <tr>
                    <th>
                        帐号信箱：
                    </th>
                    <td>
                        <input type="text" id="email" name="email" class="tn-textbox tn-input-long tn-border-gray" value="<%=TempData.GetString("email",string.Empty) %>"
                            maxlength="100" />
                    </td>
                    </tr>
                    <tr>
                    <th></th>
                    <td>
                        帐号信箱是忘记密码后重新获取密码的唯一途径，该邮箱不会公开。
                    </td>
                </tr>
                <tr>
                    <th>
                        <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %>
                    </th>
                    <td>
                        <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="commonName" name="commonName" value="<%=TempData.GetString("commonName",string.Empty) %>"
                            maxlength="64" />
                    </td>
                    </tr>
                    <tr>
                    <th></th>
                    <td>
                        <span class="commonFormFieldDescription">请输入用户的真实姓名</span>
                    </td>
                </tr>
                <tr>
                    <th>
                        &nbsp;
                    </th>
                    <td>
                        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%>
       <% if (Request.UrlReferrer != null)
          {%>
        <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_Cancel"),Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary, null, TextIconLayout.TextOnly)%>
    <%} %>
                    </td>
                </tr>
            </table>
    </div>
    </form>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#EditUserForm").validate({
                rules: {
                    userName: { required: true },
                    password: { required: true },
                    password2: { equalTo: "#password" },
                    email: { required: true, email: true },
                    commonName: { required: true, maxBlength: 30 }
                },
                messages: {
                    userName: { required: "请输入姓名" },
                    password: { required: "请输入密码" },
                    password2: { equalTo: "两次输入的密码不一致" },
                    email: { required: "请输入电子邮箱地址", email: "你输入的邮箱地址格式不正确，请重新输入" },
                    commonName: { required: "请输入的姓名", maxBlength: "最多输入30个字" }
                }
            });
            $("#createButton").click(function() {
                if (!$("#EditUserForm").valid()) {
                    return false;
                }
            });
            $("#usernameMessageSuccess").hide();
            $("#usernameMessageError").hide();
            $("#passwordMessageSuccess").hide();
            $("#passwordMessageError").hide();
            $("#userName").blur(function() {
                if ($('#userName').attr("value"))
                    $.get('<%=Url.Action("ValidateUserName","ChannelUser") %>', { userName: $('#userName').attr("value") }, function(data) {

                        $("#usernameMessageNormal").text(data.messageContent);
                        if (data.isSuccess) {
                            $("#usernameMessageSuccess").show();
                            $("#usernameMessageError").hide();
                        }
                        else {
                            $("#usernameMessageError").show();
                            $("#usernameMessageSuccess").hide();
                        }
                    });
            });
            $("#password").blur(function() {
                if ($('#password').attr("value"))
                    $.get('<%=Url.Action("ValidatePassword","ChannelUser") %>', { password: $('#password').attr("value") }, function(data) {
                        data = eval("(" + data + ")");
                        $("#passwordMessageNormal").text(data.MessageContent.toString());
                        if (data.IsSuccess == "True") {
                            $("#passwordMessageSuccess").show();
                            $("#passwordMessageError").hide();
                        }
                        else {
                            $("#passwordMessageError").show();
                            $("#passwordMessageSuccess").hide();
                        }
                    });
            });
        });
    </script>

</asp:content>
