﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<int, Identity>>" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
认证标识管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%
        ViewData["UserMenu"] = UserSubMenu.ManageIdentities;
        Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }

        UserAccountStatuses UserStatus = UserAccountStatuses.NotActive;
        if (ViewData["UserStatus"] != null)
            UserStatus = (UserAccountStatuses)ViewData["UserStatus"];
        int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
        bool? isModerated = (bool?)ViewData["IsModerated"];
    %>
<div class="tn-list-header">
<div class="tn-toolbar-area tn-helper-clearfix tn-border-gray tn-border-bottom">
<div class="tn-helper-right">
 <%=SPBHtmlHelper.Instance().LinkButton("newIdentity", "增加认证标识", Url.Action("Control_EditIdentity", "ManageUser"), ButtonSizes.Default, HighlightStyles.Primary,IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary{{"class","nyroModal"}},null)%>
 </div>
</div>
</div>
<table class="tn-table-grid">
<tbody>
<tr class="tn-table-grid-header">
<th  class="tn-border-gray tn-border-bottom tn-text-note">标识名称</th>
<th  class="tn-border-gray tn-border-bottom tn-text-note">大标识图片</th>
<th  class="tn-border-gray tn-border-bottom tn-text-note">小标识图片</th>
<th  class="tn-border-gray tn-border-bottom tn-text-note">描述</th>
<th  class="tn-border-gray tn-border-bottom tn-text-note">操作</th>
</tr>
<% if (Model != null)
   {
       foreach (Identity identity in Model.Values)
       { %>
<tr class="tn-table-grid-row">
<td class="tn-border-gray tn-border-bottom"><%=identity.Name %></td>
<td class="tn-border-gray tn-border-bottom tn-nowrap"><img src="<%=SiteUrls.Instance().IdentityIcon(identity, IdentityIconTypes.Big) %>" /></td>
<td class="tn-border-gray tn-border-bottom tn-nowrap"><img src="<%=SiteUrls.Instance().IdentityIcon(identity, IdentityIconTypes.Small) %>" /></td>
<td class="tn-border-gray tn-border-bottom tn-nowrap"><%=identity.Description %></td>
<td class="tn-border-gray tn-border-bottom tn-nowrap">
 <span class="tn-action">
<a href="<%=Url.Action("Control_EditIdentity","ManageUser",new{ identityID = identity.IdentityID }) %>"
                                                        class="tn-action-text nyroModal">编辑</a></span>
<span class="tn-action">
<a href="<%=Url.Action("DeleteIdentity","ManageUser",new{ identityID = identity.IdentityID }) %>"
onclick="if ( !confirm('是否删除该认证标识？') ) {return false; }">删除</a></span>
</td>
</tr>
<%}
   } %>
</tbody>
</table>
<script type="text/javascript">
    $(document).ready(function () {
        $(".nyroModal").nyroModal({ width: 550, height: 450 });
    });
</script>
</asp:content>
