﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
空间留言
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%
        ViewData["UserMenu"] = UserSubMenu.ManageGuestBook;
        Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }
        PagingDataSet<GuestbookPost> PgGuestBookDataSet = ViewData["pdsBookPost"] as PagingDataSet<GuestbookPost>;
        AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
        if (ViewData["status"] != null)
            AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];

        // int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
    %>
    <form id="ManageSearchForm" action="<%=Url.Action("ListGuestBook","ManageUser") %>" method="Get">
      <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
          <th>用户ID</th>
            <td><input name="PostUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="PostUserID" value="<%=Html.GetParameterFromRouteDateOrQueryString("PostUserID") %>" /></td>
            <td>
          <select name="status" class="tn-dropdownlist" id="status">
          <option value="-1">全部</option>
            <option value="<%=AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
              已通过审核</option>
            <option value="<%=AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
              未通过审核</option>
            <option value="<%=AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
              待审核</option>
            </select>
            </td>
            <td>
              <input id="searchButton" type="submit" value="<%=GetResourceString("Button_Search") %>" onclick="$('#ManageSearchForm').submit(); return false;" />
              </td>
        </table>
        </div>
  </form>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)AuditingStatuses==-1) Response.Write("tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListGuestBook","ManageUser",new{ status = -1}) %>"
                target="_self" style="cursor: pointer"><span>全部</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListGuestBook","ManageUser",new{ status = AuditingStatusesForDisplay.Success}) %>"
                target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListGuestBook","ManageUser",new{ status = AuditingStatusesForDisplay.Pending}) %>">
                <span>待审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ListGuestBook","ManageUser",new{ status = AuditingStatusesForDisplay.Fail}) %>">
                <span>未通过审核</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="ManageGuestBookPostForm" method="post">
        <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
        <%=SPBHtmlHelper.Instance().LinkButton("passAuding","通过审核","javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
        <%=SPBHtmlHelper.Instance().LinkButton("noAuding", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
        <%=SPBHtmlHelper.Instance().LinkButton("deletes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
        </div>
        </div>
        <script type="text/javascript">
            $(document).ready(function() {
                $("#passAuding").click(function() {
                    if (confirm('确认要审核通过这些留言吗？')) { $('#ManageGuestBookPostForm').attr('action', '<%=Url.Action("SetAuditingStatuses","ManageUser", new { returnUrl= Request.RawUrl,statues = SpaceBuilder.Common.AuditingStatuses.Success }) %>'); $('#ManageGuestBookPostForm').submit(); return false; } else { return false; };
                });
                $("#noAuding").click(function() {
                    if (confirm('确认要审核不通过这些留言吗？')) { $('#ManageGuestBookPostForm').attr('action', '<%=Url.Action("SetAuditingStatuses","ManageUser",new { returnUrl= Request.RawUrl,statues = SpaceBuilder.Common.AuditingStatuses.Fail }) %>'); $('#ManageGuestBookPostForm').submit(); return false; } else { return false; };
                });
                $("#deletes").click(function() {
                    if (confirm('确认要删除这些留言吗？')) { $('#ManageGuestBookPostForm').attr('action', '<%=Url.Action("DeleteGuestBookPost","ManageUser",new { returnUrl= Request.RawUrl }) %>'); $('#ManageGuestBookPostForm').submit(); return false; } else { return false; };
                });
            });
            </script>
        <div id="fragment-1">
            <div id="ManageFileCommentDiv">
                <table class="tn-table-grid">
                    <tbody>
                        <tr class="tn-table-grid-header">
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                            </th>
                      <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_Body")%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                发表人
                                </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                审核状态
                                </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                发表日期
                                </th>
                      </tr>
                        <%
                            if (ViewData["pdsBookPost"] != null)
                            {

                                IList<GuestbookPost> GuestBookLists = PgGuestBookDataSet.Records;
                                foreach (var item in GuestBookLists)
                                {

                        %>
                        <tr class="tn-table-grid-row">
                            <td class="tn-border-gray tn-border-bottom tn-width-check">
                                <input type="checkbox" name="CheckBoxGroup" id="CheckBoxGroup" class="tn-checkbox" value="<%=item.PostID %>" />
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                <label title="<%=HtmlUtils.StripForPreview(item.Body) %>">
                                    <%=HtmlUtils.TrimHtml(item.Body,50) %></label>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                                <%if (item.UserID > 0)
                                  { %>
                                <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                                    <%=item.Author%></a>
                                <%
                                    }
                                  else
                                  {
                                      Response.Write(item.Author);
                                  }
                                %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                <% 
                                    if (item.AuditingStatus == SpaceBuilder.Common.AuditingStatuses.Success)
                                    {

                                        // <img style="border-width: 0px;" src="/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif" title="该评论已经通过审核" />
                                        Response.Write("通过审核");
                                    }
                                    else if (item.AuditingStatus == SpaceBuilder.Common.AuditingStatuses.Again)
                                    {
                                        Response.Write("再审核");
                                        //<img style="border-width: 0px;" src="/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif" title="该评论还没有通过审核" />
                                    }
                                    else if (item.AuditingStatus == SpaceBuilder.Common.AuditingStatuses.Pending)
                                    {
                                        Response.Write("待审核");
                                    }
                                    else
                                    {
                                        Response.Write("未通过审核");
                                    }
    
                                %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                <%=Formatter.FormatDate(item.PostDate) %>
                            </td>
                        </tr>
                        <% }
                            }%>
                    </tbody>
                </table>
                <div class="tn-pagination tn-helper-align-center">
                        <%--<% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgCommentDataSet.TotalRecords, PgCommentDataSet.PageSize, PgCommentDataSet.PageIndex, 11, Url.Action("ListManageComments", "ManageFile", new { status = (AuditingStatusesForDisplay)(CommentLists[0].AuditingStatus), pageIndex = "{0}" })));   %>--%>
                        <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, PgGuestBookDataSet.TotalRecords, PgGuestBookDataSet.PageSize, PgGuestBookDataSet.PageIndex, 11, null));   %>
                    </div>
                </div>
            </div>
        </form>
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#ManageSearchForm").validate({
                rules: {
                    PostUserID: { digits: true }
                },
                messages: {
                    PostUserID: { digits: "请输入非负整数" }
                }
            });

            $("#searchButton").click(function() {
                if (!$("#ManageSearchForm").valid()) {
                    return false;
                }
            });


        });
    </script>
</asp:content>
