﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
等级管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%
        ViewData["UserMenu"] = UserSubMenu.ManageUserRanks;
        Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }
        Dictionary<string, Language> languages = Languages.GetLanguages(false);
    %>
    <div class="tn-blank10"></div>
                    <div class="tn-tabs tn-widget">
                        <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected"><a href="<%=Url.Action("ListUserRanks","ManageUser") %>">
                                <span>等级管理</span></a></li>
                        <li class="tn-widget-content tn-border-gray tn-border-trl "><a href="<%=Url.Action("UserRankTypes","ManageUser") %>"><span>等级设置</span></a></li>
                        </ul>
                        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                            <div class="tn-list-header">
                            <div classs="tn-toolbar-area tn-helper-clearfix">
                            <%=SPBHtmlHelper.Instance().LinkButton("newRank","新建用户等级",Url.Action("Control_AddUserRank","ManageUser"), ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
                            <%=SPBHtmlHelper.Instance().LinkButton("resetRank", "重设所有用户级别", Url.Action("ResetUserRanks","ManageUser"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                            </div>
                            </div>
                            <div class="toolbarArea">
                            <script type="text/javascript">
                                $(document).ready(function() {
                                    $('#newRank,a[name="RankModal"]').nyroModal({
                                        resizeable: true
                                    });
                                    $("#resetRank").click(function() {
                                        if (!confirm('真的要重设所有用户级别吗？重设后所有用户的级别都将根据积分重新计算！')) { return false; }
                                    });
                                });
    </script>
                            </div>
                            <table class="tn-table-grid">
                                <%
                                    SiteSettings settings = null;
                                    if (ViewData["settings"] != null)
                                    {
                                        settings = ViewData["settings"] as SiteSettings;
                                    }
                                %>
                                <tr class="tn-table-grid-header">
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        等级级数                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        等级下限                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        等级上限                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[0] != null)
                                                Response.Write(settings.NameOfUserRankTypes[0]);
                                        %>
                                  </td>                                 
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[1] != null)
                                                Response.Write(settings.NameOfUserRankTypes[1]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[2] != null)
                                                Response.Write(settings.NameOfUserRankTypes[2]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[3] != null)
                                                Response.Write(settings.NameOfUserRankTypes[3]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[4] != null)
                                                Response.Write(settings.NameOfUserRankTypes[4]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[5] != null)
                                                Response.Write(settings.NameOfUserRankTypes[5]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[6] != null)
                                                Response.Write(settings.NameOfUserRankTypes[6]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[7] != null)
                                                Response.Write(settings.NameOfUserRankTypes[7]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[8] != null)
                                                Response.Write(settings.NameOfUserRankTypes[8]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        <% 
                                            if (settings.NameOfUserRankTypes[9] != null)
                                                Response.Write(settings.NameOfUserRankTypes[9]);
                                        %>
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-text-note">
                                        操作                                    </td>
                                </tr>
                              <%
        
                                  if (ViewData["sortlistUserRank"] != null)
                                  {
                                      SortedList<int, UserRank> slistRank = ViewData["sortlistUserRank"] as SortedList<int, UserRank>;
                                      IList<UserRank> listRank = slistRank.Values;
                                      if (listRank != null && listRank.Count > 0)
                                      {
                                          foreach (var item in listRank)
                                          {
                        
                    
                                %>
                                <tr class="tn-table-grid-row">
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.Rank %>级
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.PointLower %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.PointUpper %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType1 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType2 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType3 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType4 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType5 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType6 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType7 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType8 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType9 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                        <%=item.TitleOfUserRankType10 %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                        <a name="RankModal"  href="<%=Url.Action("Control_EditUserRank","ManageUser",new{ ranks = item.Rank})%>">
                                            编辑</a> <a onclick="if ( !confirm('是否删除选中的等级？') ) {return false; }" href="<%=Url.Action("DeleteUserRanks","ManageUser",new{ Rank = item.Rank }) %>"
                                                >删除</a>
                                    </td>
                                </tr>
                                <%
                                    }
                                      }

                                  }
                                %>
                            </table>
                      </div>
                    </div>
</asp:content>
