﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<ICollection<Role>>" %>

<asp:content contentplaceholderid="operationContent" runat="server">
<div class="tn-shortcut">
    <%=SPBHtmlHelper.Instance().LinkButton("newUserRole", "添加新角色", Url.Action("Control_EditUserRole", "ManageUser"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#newUserRole").nyroModal({
            resizeable: true
        });
    });
    </script>
</asp:content>
<asp:content contentplaceholderid="pageNameContent" runat="server">
角色管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%
      ViewData["UserMenu"] = UserSubMenu.ManageUserRoles;
      Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }
    %>
            <form id="ManageGuestBookPostForm" method="post">
              <div id="fragment-1">
                <div id="ManageFileCommentDiv">
                  <table class="tn-table-grid">
                    <tbody>
                      <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> 角色名称 </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> 中文名称 </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> 标识图片 </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Description")%> </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%> </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> 是否对外展示 </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                      </tr>
                      <%
                          if (Model != null)
                          {
                              foreach (Role role in Model)
                              {
                    %>
                      <tr class="tn-table-grid-row">
                        <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=role.RoleName %> </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=role.FriendlyRoleName %> </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                        <%if (!role.IsBuiltIn)
        { %>
                        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/RoleIcons/" + role.RoleName.ToLower() + ".gif")%>" title="<%=role.FriendlyRoleName %>" alt="<%=role.RoleName %>" /> 
                        <%} %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=role.Description %> </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-icon1"><%if (role.Enabled)
                                                                                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                                     else
                                                                                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-icon1"><%if (role.IsPublic)
                                                                                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                                     else
                                                                                     { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                        </td>
                                                        <td  class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
      <%if (!role.IsBuiltIn)
        { %>
          <a href="<%=Url.Action("Control_EditUserRole","ManageUser",new{ roleID = role.RoleID})%>"  name="editUserRole" > 编辑</a>
            <a onclick="if ( !confirm('是否删除选中的用户角色？') ) {return false; }" href="<%=Url.Action("DeleteUserRole","ManageUser",new{  roleID = role.RoleID }) %>" >删除</a>
      <%} %>
      </td>
                      </tr>
                      <% }
                          }%>
                    </tbody>
                  </table>
                </div>
              </div>
            </form>
            <script type="text/javascript">
                $(document).ready(function() {
                    $("a[name='editUserRole']").nyroModal({
                        resizeable: true
                    });
                });
    </script>
</asp:content>
