﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<PersonUser>>" %>

<asp:content contentplaceholderid="operationContent" runat="server">
<div class="tn-shortcut">
    <%=SPBHtmlHelper.Instance().LinkButton("newTagModal", "添加用户", Url.Action("NewUser", "ManageUser"), ButtonSizes.Default, HighlightStyles.Primary)%>
</div>
</asp:content>
<asp:content contentplaceholderid="pageNameContent" runat="server">
个人用户管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%
        ViewData["UserMenu"] = UserSubMenu.ManagePersonUsers;
        Html.RenderPartial("Controls/Member/UserSubMenu.ascx", ViewData);
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }

        UserAccountStatuses UserStatus = UserAccountStatuses.NotActive;
        if (ViewData["UserStatus"] != null)
            UserStatus = (UserAccountStatuses)ViewData["UserStatus"];
        int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
        bool? isModerated = (bool?)ViewData["IsModerated"];
    %>
    <form id="ManageSearchForm" action="<%=Url.Action("ListUsers","ManageUser")%>" method="get">
      <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
          <tr>
        
               <th>名称</th>
              <td><input name="keyWord" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="keyWord" value="<%=Request.QueryString.GetString("keyWord",string.Empty) %>" /></td>
          <th>邮件</th>
              <td><input name="UserEmail" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="UserEmail" value="<%=Request.QueryString.GetString("UserEmail",string.Empty) %>" /></td>
          </tr>
          <tr>
          <th>状态</th>
              <td><select name="UserStatus" class="tn-dropdownlist">
                  <option value="<%=(int)UserAccountStatuses.Approved%>" <%if ((int)UserAccountStatuses.Approved == (int)UserStatus) { Response.Write("selected"); } %>>
                      已批准</option>
                  <option value="<%=(int)UserAccountStatuses.ApprovalPending%>" <%if ((int)UserAccountStatuses.ApprovalPending == (int)UserStatus) { Response.Write("selected"); } %>>
                      待批准</option>
                  <option value="<%=(int)UserAccountStatuses.Banned%>" <%if ((int)UserAccountStatuses.Banned == (int)UserStatus) { Response.Write("selected"); } %>>
                      封禁中</option>
                  <option value="<%=(int)UserAccountStatuses.Disapproved%>" <%if ((int)UserAccountStatuses.Disapproved == (int)UserStatus) { Response.Write("selected"); } %>>
                      未批准</option>
                  <option value="<%=(int)UserAccountStatuses.NotActive%>" <%if ((int)UserAccountStatuses.NotActive == (int)UserStatus) { Response.Write("selected"); } %>>
                      全部</option>
              </select></td>
          <th>角色</th>
              <td><select class="tn-dropdownlist" name="UserRole">
                  <option value="-1" <%if (Request.QueryString.GetInt("UserRole",-1)==-1) { Response.Write("selected"); } %>>
                      所有角色</option>
                  <%
                      if (ViewData["LRoles"] != null)
                      {
                          List<Role> LRoles = ViewData["LRoles"] as List<Role>;
                          if (LRoles != null && LRoles.Count > 0)
                          {
                              foreach (var item in LRoles)
                              {     
                                        %>
                  <option value="<%=item.RoleID %>" <%if (Request.QueryString.GetInt("UserRole", -1) == item.RoleID) { Response.Write("selected"); } %>>
                      <%=item.FriendlyRoleName %></option>
                  <%
                              }
                          }
                      }
                                        %>
              </select>
              </td>
            <th>管制状态</th>
            <td>
              <select class="tn-dropdownlist" name="IsModerated">
              <option selected="selected" value="" >全部</option>
                  <option  value="true" <%if (isModerated.HasValue && isModerated.Value) { Response.Write("selected"); } %>>
                      管制</option>
                  <option value="false" <%if (isModerated.HasValue && !isModerated.Value) { Response.Write("selected"); } %>>
                      未管制</option>
              </select>
              </td>
<td colspan="2">
<input type="submit" value="<%=GetResourceString("Button_Search") %>" onclick="$('#ManageSearchForm').submit(); return false;" />
<%//=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_Search"), ButtonSizes.Default, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "$('#ManageSearchForm').submit(); return false;" } }, null)%>
</td>
        </tr>
        </table>
        </div>
  </form>
    <div class="tn-tabs tn-widget">
        <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(UserStatus==UserAccountStatuses.NotActive) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListUsers","ManageUser",new{ UserStatus = UserAccountStatuses.NotActive}) %>">
                                    <span>全部用户</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(UserStatus==UserAccountStatuses.Approved) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListUsers","ManageUser",new{ UserStatus = UserAccountStatuses.Approved}) %>"
                                    target="_self" style="cursor: pointer"><span>已批准</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(UserStatus==UserAccountStatuses.ApprovalPending) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListUsers","ManageUser",new{ UserStatus = UserAccountStatuses.ApprovalPending}) %>">
                                    <span>待批准</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(UserStatus==UserAccountStatuses.Disapproved) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListUsers","ManageUser",new{ UserStatus = UserAccountStatuses.Disapproved}) %>">
                                    <span>未批准</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(UserStatus==UserAccountStatuses.Banned) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ListUsers","ManageUser",new{ UserStatus = UserAccountStatuses.Banned}) %>">
                                    <span>封禁中</span></a></li>
                            
                        </ul>
        <div class="tn-tabs-panel tn-widget-content tn-border-gray">          
            <form id="ManageUserForm"  method="post">
             <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
          <%=SPBHtmlHelper.Instance().LinkButton("passAuding","通过批准","javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
          <%=SPBHtmlHelper.Instance().LinkButton("noAuding", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
           <%=SPBHtmlHelper.Instance().LinkButton("stopUser", "封禁", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
  
            </div>
            </div>
             <div class="toolbarArea">
              <script type="text/javascript">
                  $(document).ready(function () {
                      $("#passAuding").click(function () {
                          if (confirm('确认要通过批准这些用户吗？')) { $('#ManageUserForm').attr('action', '<%=Url.Action("UpdateUserAccountStatuses","ManageUser",new { UserStatus = UserAccountStatuses.Approved,returnUrl=Request.RawUrl }) %>'); $('#ManageUserForm').submit(); return false; } else { return false; };
                      });
                      $("#noAuding").click(function () {
                          if (confirm('确认要审核不通过这些用户吗？')) { $('#ManageUserForm').attr('action', '<%=Url.Action("UpdateUserAccountStatuses","ManageUser",new { UserStatus = UserAccountStatuses.Disapproved,returnUrl=Request.RawUrl }) %>'); $('#ManageUserForm').submit(); return false; } else { return false; };
                      });
                      $("#stopUser").click(function () {
                          if (confirm('确认要封禁这些用户吗？')) { $('#ManageUserForm').attr('action', '<%=Url.Action("UpdateUserAccountStatuses","ManageUser",new { UserStatus = UserAccountStatuses.Banned,returnUrl=Request.RawUrl }) %>'); $('#ManageUserForm').submit(); return false; } else { return false; };
                      });
                  });
              </script>
               </div>  
              <table class="tn-table-grid">
                                <tr class="tn-table-grid-header">
                                      <th class="tn-border-gray tn-border-bottom tn-text-note">
                                  <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                                      </th>
                                     <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        用户ID
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        对外显示名称
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        姓名(昵称)
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        注册日期
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        上次登录
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        等级
                                    </th>
                                     <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        是否管制
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        账号状态
                                    </th>
                                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                                        操作
                                    </th>
                                </tr>
                                <% 
                                    if (ViewData.Model != null)
                                    {
                                        PagingDataSet<PersonUser> pds = ViewData.Model;
                                        if (pds != null && pds.TotalRecords > 0)
                                        {
                                            IList<PersonUser> IPersonUser = pds.Records;
                                
                                %>
                                <script type="text/javascript">
                                    $(document).ready(function () {
                                        $('.nyroModal').nyroModal({
                                            resizeable: true
                                        });

                                        $('.nyroModalRecommendUser').nyroModal({
                                            resizeable: true,
                                            height: 450,
                                            width: 400
                                        });
                                        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
                                    });
                                </script>
                                <%            
                                            foreach (var item in IPersonUser)
                                            {   
                                %>
                                <tr class="tn-table-grid-row">
                                 <td class="tn-border-gray tn-border-bottom tn-width-check">
                                     <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox" value="<%=item.UserID %>" />
                                  </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                      <%=item.UserID %>
                                    </td>
                               <%--   <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                                  <%
                                      if (item.IsAdministrator || item.IsContentAdministrator)
                                      {%>
                                         <span class="tn-icon tn-icon-manager tn-icon-inline"></span>
                                  <%}
                                 %>
                                 </td>--%>
                                  
                                
                                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                        <a href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                            target="_blank">
                                       <%=SPBHtmlHelper.Instance().UserDisplayName(item.UserID,true) %></a>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                        <a href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                            target="_blank">
                                      <%=item.CommonName %>(<%=item.NickName %>)</a>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                        <%=Formatter.FormatDate(item.DateCreated) %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                        <%=Formatter.FormatDate(item.LastActivity) %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                        <%=item.RankName %>
                                    </td>
                                     <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                        <%if (item.IsModerated)
                                              Response.Write("是");
                                          else
                                              Response.Write("否");%>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                        <%
                                        if (item.AccountStatus == UserAccountStatuses.Approved)
                                            Response.Write("已批准");
                                        else if (item.AccountStatus == UserAccountStatuses.Disapproved)
                                            Response.Write("未批准");
                                        else if (item.AccountStatus == UserAccountStatuses.Banned)
                                            Response.Write("已封禁");
                                        else
                                            Response.Write("待批准");         
                                        %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                    <span class="tn-action">
                                    <a href="<%=Url.Action("Control_EditUserInfo","ManageUser",new{ UserID = item.UserID }) %>"
                                                        class="tn-action-text nyroModal">修改</a>
                                    </span>
            <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                menu="#MenuButton_<%=item.UserID %>"> <span class="tn-icon tn-icon-triangle-down"></span><a href="javascript:void(0)" class="tn-action-text ">更多</a> </span>
            <div id="MenuButton_<%=item.UserID %>" class="tn-drop-menu ui-widget-content"
                style="display: none;">
                <ul class="tn-menu-drop-list">
                <li class="tn-menu-drop-item"> <a href="<%=Url.Action("Control_DeleteUser","ManageUser",new{ UserId = item.UserID }) %>"
                                                    name="DelButton" class="tn-action-text nyroModal">删除</a></li>
                    <li class="tn-menu-drop-item"><a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().User(),item.UserID, item.UserID,item.DisplayName )%>"
                                            class="nyroModalRecommendUser">推荐</a> </li>
                                            <li class="tn-menu-drop-item"><a href="<%=Url.Action("Control_PrizeUser","ManageUser",new{ UserID = item.UserID }) %>"
                                                class="nyroModal">奖罚</a></li>
                                           <li class="tn-menu-drop-item"> <a href="<%=Url.Action("Control_EditUserIdentity", "ManageUser", new { UserID=item.UserID})%>" class="nyroModal">
                                           认证身份</a></li>
                                           <li class="tn-menu-drop-item"> <a href="<%=Url.Action("DeleteUserIdentity", "ManageUser", new { UserID=item.UserID})%>" onclick="if ( !confirm('是否取消该用户的认证标识？') ) {return false; }">
                                           取消认证</a></li>
                                            <li class="tn-menu-drop-item"><a href="<%=Url.Action("Control_SendMessage", "Auxiliaries", new { toUserName=item.UserName }) %>"
                                                    class="nyroModal">发消息</a> </li>
                                            <% if (Globals.GetCurrentUser().IsAdministrator)
                                               { %><li class="tn-menu-drop-item"><a href="<%=Url.Action("Control_ResetPassword","ManageUser",new{ UserID = item.UserID }) %>"
                                            class=" nyroModal">改密码</a></li>
                                            <li class="tn-menu-drop-item"><a href="<%=Url.Action("Control_SetUserRoles","ManageUser",new{ UserID = item.UserID }) %>"
                                                class="nyroModal">改角色</a> </li><%} %>
                </ul>
            </div>
        </td>
                                </tr>
                                <%
                                    }
                                        }
                                    }
                                %>
                            </table>
            <div class="tn-pagination tn-helper-align-center">
                <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)); %>
            </div>
            </form>
        </div>
    </div>
</asp:content>
