﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<MicroBlogFeaturedTopic>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    <%int topcID = Request.QueryString.Get("topicID", 0);
      if (topcID > 0)
          Response.Write("编辑话题");
      else
      {
          Response.Write("创建话题");
      } %>
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-EditMicroBlogTopices"
</asp:content>
<asp:content id="HeaderContent" contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["SubMenuType"] = MicroBlogSubMenus.MicroBlogTopics;
     Html.RenderPartial("Controls/MicroBlog/MicroBlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
<spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />
  <%  if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }

      string returnPreUrl = TempData.GetString("returnPreUrl", string.Empty);
      if (string.IsNullOrEmpty(returnPreUrl))
          returnPreUrl = Request.UrlReferrer.ToString(); %>
<div class="tn-tabs tn-widget">
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form enctype="multipart/form-data" id="editTopicForm" method="post" action="<%=SPBUrlHelper.Action("UpdateTopic", "ManageMicroBlog", new RouteValueDictionary { {"returnUrl",Request.RawUrl}})%>">
        <div class="tn-form-box">
            <table>
                <tbody>
                    <tr>
                        <th>
                            话题显示文字：
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="Title" id="Title"
                                    value="<%=Model.Title %>" />
                            </span>
                        </td>
                    </tr>
                    <%if (Model.TopicID <= 0)
                      { %>
                    <tr>
                        <th>
                            话题关键字：
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="Body" id="Body"
                                    value="<%=Model.Body %>" />
                            </span>
                        </td>
                    </tr>
                    <%} %>
                    <tr>
                        <th>
                            特色话题：
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("IsFeatured", Model.IsFeatured, new RouteValueDictionary { {"Class" , "radiobutton"}}) %>
                                <span class="tn-text-note">当设置为特色话题时下面项才会起作用</span>
                            </span>
                        </td>
                    </tr>
                    <tr name="hideOption" style="display:none">
                        <th>
                            标识图片：
                        </th>
                        <td>
                            <span class="tn-form-row">
                               <input type="file" class="fileUpload" name="picfile" />
                               <input type="hidden" name="returnPreUrl" value="<%=returnPreUrl %>" />
                               <input type="hidden" name="topicID" value="<%=Request.QueryString.GetInt("topicID",0) %>" />
                            </span>
                        </td>
                    </tr>
                    <%if (!string.IsNullOrEmpty(Model.FileName))
                      { %>
                    <tr name="hideOption" style="display:none">
                        <th>
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <%Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"50\" /><br/>", SiteUrls.Instance().MicroBlogTopicLogoUrl(Model)));%>
                            </span>
                        </td>
                    </tr>
                    <%} %>
                    <tr name="hideOption" style="display:none">
                        <th>
                            话题描述
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Simple, "Description", Model.Description, new RouteValueDictionary { { "id", "Description" }, { "style", "width:500px;height:200px" } })%>
                            </span>
                        </td>
                    </tr>
                    <tr name="hideOption" style="display:none">
                        <th>
                            相关微博：
                        </th>
                        <td>
                            <span class="tn-form-row">
                                <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="UserNames"
                                    id="UserNames" value="<%=Model.UserNames %>" /><br />
                                <span class="tn-text-note">请填写关联微博所属用户的用户名，用户名之间用英文逗号隔开</span>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            &nbsp;
                        </th>
                        <td>
                            <input type="submit" id="saveButton" value="<%=GetResourceString("Button_Save") %>" />
                            <%if (!string.IsNullOrEmpty(returnPreUrl))
                              {%>
                            <input type="button" class="inputCancel" id="cancelButton" onclick="window.location.href='<%=returnPreUrl %>'" value="返回" />
                            <%} %>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        </form>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#editTopicForm").validate({
            rules: {
                Title: { required: true, maxBlength: 140 },
                Description: { htmlEditorRange: [0, 500] },
                UserNames: { maxBlength: 200 }
            },
            messages: {
                Title: { required: "必填", maxBlength: "最多输入140个字符！" },
                Description: { htmlEditorRange: "描述最多500个字符！" },
                UserNames: { maxBlength: "最多输入200个字符！" }
            }
        });



        $('#IsFeatured-true').click(function() {
            $("tr[name='hideOption']").show();
        });

        $('#IsFeatured-false').click(function() {
            $("tr[name='hideOption']").hide();
        });

        if ($('#IsFeatured-true').is(":checked")) {
            $('#IsFeatured-true').click();
        }

        $("#saveButton").click(function() {
            if (!$("#editTopicForm").valid()) {
                return false;
            }
        });
    });
</script>

</asp:content>
