﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<MicroBlogComment>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    微博评论管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-ManageMicroBlogCommentss"
</asp:content>
<asp:content id="Header" contentplaceholderid="HeaderContent" runat="server">
  <% 
      if (ViewData["SubMenuType"] == null)
          ViewData["SubMenuType"] = MicroBlogSubMenus.MicroBlogComments;
      Html.RenderPartial("Controls/MicroBlog/MicroBlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }

      AuditingStatusesForDisplay? AuditingStatuses = AuditingStatusesForDisplay.Pending;
      if (ViewData["status"] != null)
          AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];%>
          <form id="ManageSearchForm" action="<%=Url.Action("ManageMicroBlogComments","ManageMicroBlog")%>"
method="get">
<div class="tn-form-box tn-border-gray tn-border-bottom">
    <table>
        <tr>
            <th>
                内容关键字：
            </th>
            <td>
                <input name="bodyKeywords" id="bodyKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=Request.QueryString.GetString("bodyKeywords",string.Empty) %>" />
            </td>
            <th>
                用户ID
            </th>
            <td>
                <input name="OwnerUserID" id="OwnerUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=Request.QueryString.GetString("OwnerUserID", string.Empty) %>" />
            </td>
            <td>
                <select name="status" id="Select1" class="tn-dropdownlist">
                    <option value="-1">请选择</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
                        已通过审核</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
                        未通过审核</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
                        待审核</option>
                </select>
            </td>
            <td>
                <input id="searchButton" type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
            </td>
        </tr>
    </table>
</div>
</form>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int) AuditingStatuses == -1) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ManageMicroBlogComments","ManageMicroBlog",new{ status = -1,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>">
                <span>全部评论</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ManageMicroBlogComments","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Success ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>">
                <span>已通过审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ManageMicroBlogComments","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Pending ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>">
                <span>待审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>">
            <a href="<%=Url.Action("ManageMicroBlogComments","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Fail ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>">
                <span>未通过审核</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="ManageMicroBlogForm" method="post">
        <table class="tn-table-grid">
            <div class="tn-list-header">
                <div class="tn-toolbar-area tn-helper-clearfix">
                    <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageMicroBlogForm').attr('action','"+Url.Action("UpdateThreadorCommentStatus","ManageMicroBlog",
                    new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success,ActionCate=MicroBlogThreadOrComment.Comments })+"'); $('#ManageMicroBlogForm').submit();return false;"},{"title","审核通过选中的评论"}}, null)%>
                    <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                                                          new RouteValueDictionary { { "onclick", "$('#ManageMicroBlogForm').attr('action','" + Url.Action("UpdateThreadorCommentStatus", "ManageMicroBlog", new { returnUrl = Request.RawUrl, auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail, ActionCate = MicroBlogThreadOrComment.Comments }) + "'); $('#ManageMicroBlogForm').submit();return false;" }, { "title", "不审核通过选中的评论" } }, null)%>
                    <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                    new RouteValueDictionary { { "title", "删除选中的微博评论" } }, null)%>
                </div>
            </div>
            <tr class="gridHeader">
                <th class="tn-border-gray tn-border-bottom">
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_Body")%>
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    评论对象
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_CommentUser")%>
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    操作
                </th>
            </tr>
            <%if (Model != null && Model.Records.Count > 0)
              {
                  foreach (var item in Model.Records)
                  {%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                        value="<%=item.CommentID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <%=HtmlUtils.TrimHtml(item.Body,20) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <%MicroBlogThread thread = MicroBlogThreads.GetThread(item.ThreadID, false);%>
                    <a class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap" target="_blank"
                       title="<%=thread.ForwardBody %>"  href="<%=SiteUrls.Instance().ShowMicroBlog(item.UserID,item.ThreadID) %>">
                        <%=StringUtils.Trim(thread.ForwardBody,30)%>
                    </a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                    <a href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                        target="_blank">
                        <%=item.Author %></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <a class="tn-action-text" onclick="if (!confirm('确认要删除这条评论吗？')) { return false; }"
                        href="<%=Url.Action("DeleteComment", "ManageMicroBlog", new {  commentID=item.CommentID ,returnUrl = Request.RawUrl}) %>">
                        删除</a>
                </td>
            </tr>
            <%}
              }%>
        </table>
        <div class="tn-pagination tn-helper-align-center">
            <%Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)); %>
        </div>
        </form>
    </div>
</div>                     

<script type="text/javascript">
    $(document).ready(function() {
        $("#ManageSearchForm").validate({
            rules: {
                OwnerUserID: { digits: true }
            },
            messages: {
                OwnerUserID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#ManageSearchForm").valid()) {
                return false;
            }
        });
        $("#DeleteButton").click(function() {
            if ($('input[name="CheckBoxGroup"]:checked').length <= 0) {
                alert("没用选中任何项！");
                return false;
            }
            if (confirm('确认要删除这些微博评论吗？')) {
                $('#ManageMicroBlogForm').attr('action', '<%=Url.Action("DeleteBlogThreadsOrComments", "ManageMicroBlog", new { returnUrl = Request.RawUrl, DelCate = MicroBlogThreadOrComment.Comments }) %>');
                $('#ManageMicroBlogForm').submit();
                return false;
            }
        });
    }); 

</script>
</asp:content>
