﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<MicroBlogScreen>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    微博大屏幕管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-ManageMicroBlogTopices"
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["SubMenuType"] = MicroBlogSubMenus.MicroBlogScreen;
     Html.RenderPartial("Controls/MicroBlog/MicroBlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
  <% if (TempData["StatusMessageType"] != null)
     {
         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
         TempData["StatusMessageType"] = null;
     }

     AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
     if (ViewData["status"] != null)
         AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];%>
<form id="ManageSearchForm" action="<%=SPBUrlHelper.Action("SreachMicroBlogScreen","ManageMicroBlog")%>"
method="Post">
<div class="tn-form-box tn-border-gray tn-border-bottom">
    <table>
        <tr>
            <th>
                名称：
            </th>
            <td>
                <input name="keyword" id="keyword" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=TempData.GetString("keyword",string.Empty)%>" />
                    <input name="status" id="status" value="<%=(int)AuditingStatuses %>" type="hidden" />
            </td>

            <td>
                <input type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
            </td>
        </tr>
    </table>
</div>
</form>
<div class="tn-tabs tn-widget">
   <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)AuditingStatuses==-1)  Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageScreens","ManageMicroBlog",new{ status = -1 ,keyword=Html.GetParameterFromRouteDateOrQueryString("keyword")}) %>"> <span>全部大屏幕</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageScreens","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Success ,Keywords=Html.GetParameterFromRouteDateOrQueryString("keyword")}) %>"> <span>已通过审核</span></a></li>
     <li  class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageScreens","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Pending ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("keyword")}) %>"> <span>待审核</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail)  Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageScreens","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Fail ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("keyword")}) %>"> <span>未通过审核</span></a></li>
   </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="ManageMicroBlogForm" method="post">
        <table class="tn-table-grid">
           <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
              <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageMicroBlogForm').attr('action','"+Url.Action("UpdateScreenStatus","ManageMicroBlog",
                  new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success})+"'); $('#ManageMicroBlogForm').submit();return false;"},{"title","把选中的大屏幕通过审核"}}, null)%>
              <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                  new RouteValueDictionary { { "onclick", "$('#ManageMicroBlogForm').attr('action','" + Url.Action("UpdateScreenStatus", "ManageMicroBlog", new { returnUrl = Request.RawUrl, auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail}) + "'); $('#ManageMicroBlogForm').submit();return false;" }, { "title", "把选中的大屏幕不通过审核" } }, null)%>
              <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                  new RouteValueDictionary {{ "title", "删除选中的大屏幕" } }, null)%>
            </div>
          </div>
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    名称
                </th>
                <th class="tn-border-gray tn-border-bottom">
                     关联话题
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    开始时间
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    截止时间
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    创建时间
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    操作
                </th>
            </tr>
            <%if (Model != null && Model.Records.Count > 0)
              {
                  foreach (var item in Model.Records)
                  {%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                        value="<%=item.ScreenID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <a href="<%=SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { {"screenID",item.ScreenID}})%>" title="<%=item.ScreenName %>"><%=StringUtils.Trim(item.ScreenName,24) %></a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <span title="<%=item.Keyword %>">
                    <%=StringUtils.Trim(item.Keyword,28) %></span>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap"><%=Formatter.FormatDate(item.StartDate)%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap"><%=Formatter.FormatDate(item.EndDate)%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap">
                    <%=Formatter.FormatDate(item.DateCreated)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <a class="tn-action-text" onclick="if (!confirm('确认要删除当前大屏幕吗？')) { return false; }"
                        href="<%=Url.Action("DeleteScreen", "ManageMicroBlog", new {  screenID = item.ScreenID,returnUrl = Request.RawUrl}) %>">
                        删除</a>
                </td>
            </tr>
            <%}
              } %>
        </table>
        <%if (Model != null)
          { %>
        <div class="tn-pagination tn-helper-align-center">
            <%Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)); %>
        </div>
        <%} %>
        </form>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $('#DeleteButton').click(function() {
            if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                alert("没有任何选中项!");
                return false;
            }
            if (confirm('确认要删除这些微博吗？')) {
                $('#ManageMicroBlogForm').attr('action', '<%=Url.Action("DeleteScreens", "ManageMicroBlog", new { returnUrl = Request.RawUrl }) %>');
                $('#ManageMicroBlogForm').submit();
                return false;
            }
        });
    });
</script>

</asp:content>
