﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<MicroBlogThread>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    微博管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-ManageMicroBlogs"
</asp:content>
<asp:content id="Header" contentplaceholderid="HeaderContent" runat="server">
  <% 
      if (ViewData["SubMenuType"] == null)
          ViewData["SubMenuType"] = MicroBlogSubMenus.MicroBlogThreads;
      Html.RenderPartial("Controls/MicroBlog/MicroBlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }

      AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
      if (ViewData["status"] != null)
          AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];
    %>
    
    
<form id="SearchMicroBlogsForm" action="<%=Url.Action("ManageMicroBlogThreads","ManageMicroBlog") %>" method="get">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
            <tr>
                <th>
                    内容关键字：
                </th>
                <td>
                    <input name="bodyKeywords" id="bodyKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("bodyKeywords",string.Empty) %>" />
                </td>
                <th>
                    用户ID
                </th>
                <td>
                     <input name="OwnerUserID" id="OwnerUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("OwnerUserID", string.Empty) %>" />
                </td>
                <td>     
                  <select name="status" id="status" class="tn-dropdownlist">
                   <option value="-1">请选择</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>> 已通过审核</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>> 未通过审核</option>
                    <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>> 待审核</option>
                   </select>
                </td>
                <td>
                
                <input id="searchButton" type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
               </td>
            </tr>
        </table>
    </div>
 </form>
<div class="tn-tabs tn-widget">
   <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl <% if((int)AuditingStatuses==-1)  Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogThreads","ManageMicroBlog",new{ status = -1 ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>"> <span>全部微博</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogThreads","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Success ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>"> <span>已通过审核</span></a></li>
     <li  class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogThreads","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Pending ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>"> <span>待审核</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail)  Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogThreads","ManageMicroBlog",new{ status = AuditingStatusesForDisplay.Fail ,bodyKeywords=Html.GetParameterFromRouteDateOrQueryString("bodyKeywords"),OwnerUserID=Html.GetParameterFromRouteDateOrQueryString("OwnerUserID")}) %>"> <span>未通过审核</span></a></li>
   </ul>
   <div class="tn-tabs-panel tn-widget-content tn-border-gray">
      <form id="ManageMicroBlogForm" method="post" action="">
        <table class="tn-table-grid">
          <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
              <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageMicroBlogForm').attr('action','"+Url.Action("UpdateThreadorCommentStatus","ManageMicroBlog",
                  new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success,ActionCate=MicroBlogThreadOrComment.Threads })+"'); $('#ManageMicroBlogForm').submit();return false;"},{"title","把选中的微博通过审核"}}, null)%>
              <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                  new RouteValueDictionary { { "onclick", "$('#ManageMicroBlogForm').attr('action','" + Url.Action("UpdateThreadorCommentStatus", "ManageMicroBlog", new { returnUrl = Request.RawUrl, auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail, ActionCate = MicroBlogThreadOrComment.Threads }) + "'); $('#ManageMicroBlogForm').submit();return false;" }, { "title", "把选中的微博不通过审核" } }, null)%>
              <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                  new RouteValueDictionary {{ "title", "删除选中的微博" } }, null)%>
            </div>
          </div>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom">
              <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
              主题 
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
              作者 
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
              <%=GetResourceString("Label_PostDate")%> 
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note" >操作</th>
          </tr>
           <%if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
             {
                 foreach (var item in Model.Records)
                 {%>
          <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
              <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox" value="<%=item.ThreadID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
               <a href="<%=SiteUrls.Instance().ShowMicroBlog(item.UserID,item.ThreadID) %>"><%= item.ForwardBody %><%if (item.HasPhoto) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Picture, "图片微博", new RouteValueDictionary { { "class", "tn-icon-inline" } })); %></a> 
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
              <a href="<%=SiteUrls.Instance().UserChannelHome(item.OwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
              target="_blank"> <%=item.Author %></a> 
           </td>
           <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
               <%=Formatter.FormatDate(item.DateCreated)%> 
           </td>
               <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
              <a class="tn-action-text" onclick="if (!confirm('确认要删除这条微博吗？')) { return false; }" href="<%=Url.Action("DeleteThread", "ManageMicroBlog", new {  threadID = item.ThreadID ,returnUrl = Request.RawUrl}) %>">删除</a>
           </td>
         </tr>
             <%}%>
        
       <% }%>                
        </table>
        <div class="tn-pagination tn-helper-align-center">
          <%Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, null)); %>
        </div> 
     </form>
   </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#SearchMicroBlogsForm").validate({
            rules: {
                OwnerUserID: { digits: true }
            },
            messages: {
                OwnerUserID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#SearchMicroBlogsForm").valid()) {
                return false;
            }
        });
        $('#DeleteButton').click(function() {
            if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                alert("没有任何选中项!");
                return false;
            }
            if (confirm('确认要删除这些微博吗？')) {
                $('#ManageMicroBlogForm').attr('action', '<%=Url.Action("DeleteBlogThreadsOrComments", "ManageMicroBlog", new { returnUrl = Request.RawUrl, DelCate = MicroBlogThreadOrComment.Threads }) %>');
                $('#ManageMicroBlogForm').submit();
                return false;
            }

        });
    }); 

</script>

</asp:content>
