﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<MicroBlogTopic>>" %>

<asp:content id="operationContent" contentplaceholderid="operationContent" runat="server">
    <%=SPBHtmlHelper.Instance().LinkButton("","创建话题",SPBUrlHelper.Action("EditTopic", "ManageMicroBlog"),ButtonSizes.Default,HighlightStyles.Primary,null,TextIconLayout.TextOnly) %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    微博话题管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-ManageMicroBlogTopices"
</asp:content>
<asp:content id="HeaderContent" contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["SubMenuType"] = MicroBlogSubMenus.MicroBlogTopics;
     Html.RenderPartial("Controls/MicroBlog/MicroBlogSubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <% if (TempData["StatusMessageType"] != null)
     {
         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
         TempData["StatusMessageType"] = null;
     }
     bool? isFeatured = ViewData.Get<bool?>("isFeatured");
      %>
<form id="ManageSearchForm" action="<%=SPBUrlHelper.Action("SreachMicroBlogTopics","ManageMicroBlog")%>"
method="Post">
<div class="tn-form-box tn-border-gray tn-border-bottom">
    <table>
        <tr>
            <th>
                话题关键字：
            </th>
            <td>
                <input name="bodyKeyword" id="bodyKeyword" type="text" class="tn-textbox tn-input-medium tn-border-gray"
                    value="<%=TempData.GetString("bodyKeyword",string.Empty)%>" />
            </td>
            <td>
                <input type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
            </td>
        </tr>
    </table>
</div>
</form>
<div class="tn-tabs tn-widget">
   <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(!isFeatured.HasValue || !isFeatured.Value)  Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogTopics", "ManageMicroBlog", new { bodyKeywords = Html.GetParameterFromRouteDateOrQueryString("bodyKeyword") })%>"> <span>全部话题</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(isFeatured.HasValue && isFeatured.Value) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageMicroBlogTopics", "ManageMicroBlog", new { isFeatured = true, bodyKeywords = Html.GetParameterFromRouteDateOrQueryString("bodyKeyword") })%>"> <span>特色话题</span></a></li>
   </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="ManageMicroBlogTopicForm" method="post">
        <table class="tn-table-grid">
            <div class="tn-list-header">
                <div class="tn-toolbar-area tn-helper-clearfix">
                <%=SPBHtmlHelper.Instance().LinkButton("DeleteButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些话题吗？')) {$('#ManageMicroBlogTopicForm').attr('action','" + Url.Action("DeleteMicroBlogTopics", "ManageMicroBlog", new { returnUrl = Request.RawUrl }) + "'); $('#ManageMicroBlogTopicForm').submit();return false;}" }, { "title", "删除选中的微博话题" } }, null)%>
                </div>
            </div>
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom">
                    <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    话题显示文字
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    话题关键字
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    统计数
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_PostDate")%>
                </th>
                <th class="tn-border-gray tn-border-bottom">
                    操作
                </th>
            </tr>
            <%if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
              {
                  foreach (var item in Model.Records)
                  {%>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                    <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox"
                        value="<%=item.TopicID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <a title="<%=item.Title %>" target="_blank" href="<%=SPBUrlHelper.Action("ShowMicroBlogTopic", "MicroBlog", new RouteValueDictionary { { "topicID", item.TopicID } })%>">
                      <%=item.Title %>
                    </a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                    <%=item.Body %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=item.ItemCount %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <%=Formatter.FormatDate(item.DateCreated)%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                    <a class="tn-action-text" onclick="if (!confirm('确认要删除这条话题吗？')) { return false; }"
                        href="<%=Url.Action("DeleteTopic", "ManageMicroBlog", new {  topicID=item.TopicID ,returnUrl = Request.RawUrl}) %>">
                        删除</a>
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditTopic","ManageMicroBlog",new RouteValueDictionary{{"topicID",item.TopicID}}) %>"
                        name="editTopic">编辑</a>
                </td>
            </tr>
            <%}
              } %>
        </table>
        <div class="tn-pagination tn-helper-align-center">
            <%Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)); %>
        </div>
        </form>
    </div>
</div>

</asp:content>
