﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<NewsThread>" %>
<asp:content contentplaceholderid="pageNameContent" runat="server">
  <%if (Model.ThreadID > 0) { Response.Write("编辑资讯"); } else { Response.Write("发布资讯"); } %>
</asp:content>
<asp:content runat="server" contentplaceholderid="HeaderContent">
  <% ViewData["SubMenuType"] = NewsSubMenus.CreateNews;%>
  <% Html.RenderPartial("Controls/News/NewsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:script runat="server" id="artDialog" src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    setexpiredays="30" />
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />
  <%    bool isShowPage = ViewData.GetBool("isShowPage", true);
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType != StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            }
            TempData["StatusMessageType"] = null;
        }   
    %>
  <%if (ViewData.GetBool("isSection", false))
      {
          int newsApplicationID = ApplicationIDs.Instance().News();
          NewsThread thread = ViewData.Model;%>
  <form id="editor" action="<%=this.Url.Action("CreateUpdateNews", "ManageNews", new {newsID=thread.ThreadID})%>"
            method="post">
    <div class="tn-form tn-label-right">
      <div class="tn-form-row">
        <label class=""> 资讯栏目：</label>
        <select name="sectionDDL" id="sectionDDL" class="tn-dropdownlist">
          <option <%if(thread.ThreadID<=0)Response.Write("selected=\"selected\""); %> value=""> --请 选 择--</option>
          <%foreach (var toSection in ViewData["allSections"] as List<NewsSection>)
                  {%>
          <option <%if(thread.SectionID==toSection.SectionID)Response.Write(" selected=\"selected\""); %>
                                    value="<%=toSection.SectionID %>">
          <%for (int i = 0; i < toSection.Depth; i++) { Response.Write("&nbsp; &nbsp; &nbsp; &nbsp; "); } %>
          <%=toSection.SectionName%></option>
          <%}%>
        </select>
        <span class="tn-form-required">(必填)</span> </div>
      <div class="tn-form-row">
        <input type="text" id="title" name="title" class="tn-textbox tn-input-longest tn-border-gray" value="<%=thread.Title %>" />
      </div>
      <div class="tn-form-row tn-editor">
        <%--<label class="tn-form-label"> <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %></label>--%>
        <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateNewsAttachments", "ChannelNews", new RouteValueDictionary { { "threadID", thread.ThreadID }, { "isImage", true } });
                   string uploadAttachmentUrl = SPBUrlHelper.Action("UserContentSelector_UpdateNewsAttachments", "ChannelNews", new RouteValueDictionary { { "threadID", thread.ThreadID }, { "isImage", false } }); %>
        <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", thread.GetBodyForEdit(), new RouteValueDictionary { { "id", "body" },{"style","width:100%;height:300px;"}}, uploadPhotoUrl, uploadAttachmentUrl,true)%> </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 资讯作者：</label>
        <input id="author" name="author" type="text" class="tn-textbox tn-input-medium  tn-border-gray"
                                value="<%=thread.OriginalAuthor %>" />
        &nbsp;
        <label class=""> 资讯来源：</label>
        <input id="copyFrom" name="copyFrom" type="text" class="tn-textbox tn-input-long tn-border-gray"
                                value="<%=thread.CopyFrom %>" />
      </div>
      <div class="tn-form-row">
        <label class="tn-form-label"> 附加选项：</label>
        <input type="checkbox" class="tn-checkbox" id="downloadRemoteImage" name="downloadRemoteImage" value="true" />
        <label for="downloadRemoteImage">下载远程图片</label>
      </div>
      <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label"> 资讯摘要：</label>
        <textarea name="excerpt" class="tn-textarea tn-input-longest tn-border-gray" id="excerpt"><%=thread.Excerpt %></textarea>
        <span style="display:none"></span>
      </div>
      <div class="tn-collapsible tn-collapsible-closed">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
          <h4 class="tn-helper-reset"><a href="javascript:;;">高级设置</a></h4>
        </div>
        <div class="tn-blank10"></div>
        <div class="tn-collapsible-content" style="display:block;">
          <%if (isShowPage)
              { %>
          <div class="tn-form-row">
            <lable class="tn-form-label">分页方式： </lable>
            <input id="managepager" type="radio" class="tn-radiobutton" checked="checked" name="isAutoPage" value="false" onclick="$('#autoPageSpan').hide();$('#pageTip').show();  $('#body_pagebreak').parent().show();" />
            <label class="dt-label" for="managepager">手动</label>
            <input id="autopager" type="radio" class="tn-radiobutton" name="isAutoPage" value="true" onclick="$('#autoPageSpan').show();$('#pageTip').hide(); $('#body_pagebreak').parent().hide();" />
            <label class="dt-label" for="autopager">自动</label>
            <span id="autoPageSpan" style="display:none;"> &nbsp; 大小：
            <input type="text" class="tn-textbox tn-border-gray" id="pageSize" name="pageSize" value="5" />
            千字/每页</span> </div>
          <%} %>
          <div class="tn-form-row">
            <label class="tn-form-label"> 副标题：</label>
            <input id="subtitle" name="subtitle" type="text" class="tn-textbox tn-input-long tn-border-gray"
                                value="<%=thread.Subtitle %>" />
          </div>
          <%if ((ViewData["dict"] as Dictionary<int, string>) != null && (ViewData["dict"] as Dictionary<int, string>).Count > 0)
                {%>
          <div class="tn-form-row">
            <label class="tn-form-label"> 标题前缀：</label>
            <select name="prefixDDL" id="prefixDDL" class="tn-dropdownlist">
              <option <%if(thread.ThreadID<=0)Response.Write("selected=\"selected\""); %> value=""> --请 选 择-- </option>
              <%foreach (var dict in ViewData["dict"] as Dictionary<int, string>)
                  {%>
              <option <%if(thread.PrefixID==dict.Key)Response.Write(" selected=\"selected\""); %>
                                    value="<%=dict.Key %>"> <%=dict.Value%></option>
              <%}%>
            </select>
          </div>
          <%}%>
          <div class="tn-form-row">
            <label class="tn-form-label"> 关键词：</label>
            <input id="keywords" name="keywords" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=thread.Keywords %>" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> 标签：</label>
            <%        
                ViewData["TagInputName"] = "newsTags";
                ViewData["applicationTagItemKey"] = ApplicationTagItemKeys.Instance().News();
                ViewData["SelectedUserTags"] = Model.Tags;
                Html.RenderPartial("Controls/ApplicationTagSelector.ascx", ViewData);
            %>
            <%--<div class="formField"> <%=SPBHtmlHelper.Instance().TagInput("itemTag", ViewData.GetString("tagList", string.Empty), this.Url.Action("GetTagsJosn", "ChannelNews"),new RouteValueDictionary{{"Class","textBox"},{"style","width:600px"}})%> <span class="tn-text-note">（多个标签用逗号 , 隔开）</span> </div>--%>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_OpenComment")%><%=GetResourceString("Common_Colon") %></label>
            <div class="tn-input-multiple">
              <input id="enableComments-true" class="tn-radiobutton" type="radio" <%if(thread.EnableComments)Response.Write(" checked=\"checked\""); %>
                                value="true" name="enableComments" />
              <label for="enableComments-true">是</label>
              <input id="enableComments-false" class="tn-radiobutton" type="radio" <%if(!thread.EnableComments)Response.Write(" checked=\"checked\""); %>
                                value="false" name="enableComments" />
              <label for="enableComments-false">否</label>
            </div>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> 阅读权限：</label>
            <input type="text" id="allowededUserRank" name="allowededUserRank" class="tn-textbox tn-input-medium tn-border-gray" value="<%=thread.AllowededUserRank %>" />
            <span class="tn-text-note">（设置某级别及以上级别可以阅读，设置为0，可匿名阅读。）</span> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> 置顶设置：</label>
            <input name="isSticky" id="isSticky" type="checkbox" class="tn-checkbox" <%if(thread.IsSticky) Response.Write("checked=\"checked\""); %>
                                value="true" />
            <label for="isSticky"> 资讯置顶</label>
            <% if (thread.IsSticky)
                 { %>
            <span id="showStickyDateSpan">置顶期限：<%=Formatter.FormatDate(thread.StickyDate)%>&nbsp;&nbsp;<a
                                href="javascript:;" id="EditStickyDay" onclick="$('#setStickySpan').show();$('#showStickyDateSpan').hide();"
                                title="重新设置">编辑</a></span>
            <%}%>
            <span id="setStickySpan">，设置置顶时间：
            <select name="stickyDays" class="tn-dropdownlist">
              <option value="1">置顶1天</option>
              <option value="3">置顶3天</option>
              <option value="7">置顶1星期</option>
              <option value="14">置顶2星期</option>
              <option value="30">置顶1个月</option>
              <option value="90">置顶3个月</option>
              <option value="180">置顶6个月</option>
              <option value="365">置顶1年</option>
            </select>
            &nbsp;&nbsp; <a href="javascript:;" id="cancelSticky" onclick=" $('#setStickySpan').hide();$('#showStickyDateSpan').show();
                                <% if (!thread.IsSticky) Response.Write("$('#isSticky').removeAttr('checked');"); %>"
                                    title="取消重新设置"><%=GetResourceString("Button_Cancel")%></a> </span> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> 阅读收费：</label>
            <input type="text" id="pointConsumption" name="pointConsumption" class="tn-textbox tn-input-medium tn-border-gray" value="<%=thread.PointConsumption %>" />
            <span class="tn-text-note">（设置阅读需要消耗的<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>，设置为0，不消耗<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>）</span> </div>
        </div>
      </div>
      <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label"> </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large,null, null)%>
        <% if (Request.UrlReferrer != null)
                   {%>
        <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
        <%} %>
      </div>
      <input type="hidden" value="<%=thread.FeaturedImageAttachmentID %>" id="featurePicAttachmentID" name="featurePicAttachmentID"/>
    </div>
  </form>
  <script type="text/javascript" rel="forceLoad">
            <!--
            $(document).ready(function() {
                $("#title").qtip({content:'<%=string.Format(GetResourceString("Description_Pattern_TitleLimitWordCount", newsApplicationID), NewsConfiguration.Instance().MaxLengthForTitle)%>'});
                $("#subtitle").qtip({content:'<%=string.Format(GetResourceString("Description_Pattern_AssistantTitleLimitWordCount", newsApplicationID), NewsConfiguration.Instance().MaxLengthForSubtitle)%>'});
                $("#excerpt").qtip({content:'<%=string.Format(GetResourceString("Description_Pattern_SummaryLimitWordCount", newsApplicationID), NewsConfiguration.Instance().MaxLengthForExcerpt)%>'});
                $("#keywords").qtip({content:'<%=GetResourceString("Label_SetNewsPageMetaTag",newsApplicationID)%>'});
        
        $("#title").watermark("<%=GetResourceString("Validate_InputTitle")%>");
                    $("#editor").validate({
                        rules: {
                            title: { required: true,minBlength:<%=NewsConfiguration.Instance().MinLengthForTitle %>, maxBlength: <%=NewsConfiguration.Instance().MaxLengthForTitle %> },
                            subtitle: { maxBlength: <%=NewsConfiguration.Instance().MaxLengthForSubtitle %> },       
                            sectionDDL: { required: true },
                             author:{ maxBlength: 60 },
                    keywords:{ maxBlength: 60 },
                    copyFrom:{ maxBlength: 256 },
                    pageSize:{number: true,digits:true },
                            excerpt :{maxBlength: <%=NewsConfiguration.Instance().MaxLengthForExcerpt %> },
                            body: { htmlEditorRequired: true, htmlEditorRange: [<%=NewsConfiguration.Instance().MinLengthForBody %>, <%=NewsConfiguration.Instance().MaxLengthForBody %>] },
                            allowededUserRank: { required: true,digits:true ,max:<%=UserRanks.GetAllUserRanks(true).Values.Max(n=>n.Rank) %>},
                            pointConsumption: { required: true,number: true, minBlength: 0 }
                        },
                        messages: {
                            title: { required: "请输入标题",minBlength:"最少长度<%=NewsConfiguration.Instance().MinLengthForTitle %>字", maxBlength: "最大长度不能超过<%=NewsConfiguration.Instance().MaxLengthForTitle %>字" },
                            subtitle: { maxBlength: "最大长度不能超过<%=NewsConfiguration.Instance().MaxLengthForSubtitle %>字" },
                            sectionDDL: { required: "请选择栏目"},
                             author:{ maxBlength: "最多可以输入60个字" },
                    keywords:{ maxBlength: "最多可以输入60个字" },
                    copyFrom:{ maxBlength: "最多可以输入256个字" },
                     pageSize:{number: "只允许输入数字"},
                            excerpt :{maxBlength: "最大长度不能超过<%=NewsConfiguration.Instance().MaxLengthForExcerpt %>字" },
                            body: { htmlEditorRequired: "请输入内容", htmlEditorRange: "字数必须在<%=NewsConfiguration.Instance().MinLengthForBody %>到<%=NewsConfiguration.Instance().MaxLengthForBody %>以内" },
                            allowededUserRank: { required: "请输入内容",digits: "请输入正整数" ,max:"当前用户等级最大为<%=UserRanks.GetAllUserRanks(true).Values.Max(n=>n.Rank) %>"},
                            pointConsumption: { required: "请输入内容",number: "请输入数字(包括小数)", minBlength: "请输入正数" }
                        }
                    });

                    $("#saveButton").click(function() {
                        if (!$("#editor").valid()) {
                            return false;
                        }
                    });
                    
                    $("#isSticky").click(isStickyClick);  
                    isStickyClick();
                     <% if (thread.IsSticky)
                   { %>
                     $("#setStickySpan").hide();   
                   <%}%>
                }); 
                
                function  isStickyClick(){
                        if ($('#isSticky').attr('checked'))
                           {
                           <% if (thread.IsSticky)
                            { %>
                            $('#showStickyDateSpan').show();
                           <%}
                           else{%>
                            $('#setStickySpan').fadeIn('normal');
                            $('#showStickyDateSpan').hide();  
                            <%} %>                  
                            }
                        else
                            {
                            $('#setStickySpan').fadeOut('fast');
                            $('#showStickyDateSpan').hide();  
                            }
                    }
           //--> 
            </script>
  <%}
      else
      {%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <h1> 友情提示</h1>
      <p> 您暂时还没有可用的“资讯栏目”，建议您新建一个，请点击&nbsp; <a id="newSectionModal" class="nyroModal"
                            href="<%=this.Url.Action("Control_EditSection", "ManageNews")%>">添加栏目</a></p>
    </div>
  </div>
  <%}%>
</asp:content>
