﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<NewsComment>>" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
评论管理
</asp:content>
<asp:content id="Content1" runat="server" contentplaceholderid="HeaderContent">
    <% ViewData["SubMenuType"] = NewsSubMenus.ManageNewsComments;%>
    <% Html.RenderPartial("Controls/News/NewsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
<form id="searchNewsForm" method="post" action="<%=Url.Action("SearchNewsComments","ManageNews",new {status = (AuditingStatusesForDisplay)ViewData["status"]}) %>">
                    <div class="tn-form-box tn-border-gray tn-border-bottom">
                        <table>
                            <th>搜索用户ID</th>
                                <td><input name="searchUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="searchUserID" value="<%=Request.QueryString.GetString("userID", string.Empty) %>" /></td>
                           <td>
                <input id="searchButton" type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" />
                                    </td>
                        </table>
                    </div>
</form>                           

            <div class="tn-tabs tn-widget">
                <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatusesForDisplay)ViewData["status"]==AuditingStatusesForDisplay.Success){Response.Write("tn-tabs-selected");} %>">
                        <a style="cursor: pointer;" href="<%=this.Url.Action("ManageComments", "ManageNews", new { status = AuditingStatusesForDisplay.Success,userID=Request.QueryString.GetString("userID", string.Empty)})%>">
                            <span>已通过审核</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatusesForDisplay)ViewData["status"]==AuditingStatusesForDisplay.Pending){Response.Write("tn-tabs-selected");} %>">
                        <a style="cursor: pointer;" href="<%=this.Url.Action("ManageComments", "ManageNews", new { status = AuditingStatusesForDisplay.Pending,userID=Request.QueryString.GetString("userID", string.Empty)})%>">
                            <span>待审核</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatusesForDisplay)ViewData["status"]==AuditingStatusesForDisplay.Fail){Response.Write("tn-tabs-selected");} %>">
                        <a style="cursor: pointer;" href="<%=this.Url.Action("ManageComments", "ManageNews", new { status = AuditingStatusesForDisplay.Fail,userID=Request.QueryString.GetString("userID", string.Empty)})%>">
                            <span>未通过审核</span></a></li>
                </ul>
                <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                    <form id="commentForm" method="post">
                    <div class="tn-list-header">
                    <div class="tn-toolbar-area tn-helper-clearfix">
                        <%=SPBHtmlHelper.Instance().LinkButton("deletes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                        <%if ((AuditingStatusesForDisplay)ViewData["status"] != AuditingStatusesForDisplay.Success)
                          { %>
                        <%=SPBHtmlHelper.Instance().LinkButton("passAuding","通过审核","javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
                        <%}
                          if ((AuditingStatusesForDisplay)ViewData["status"] != AuditingStatusesForDisplay.Fail)
                          { %>
                        <%=SPBHtmlHelper.Instance().LinkButton("noAuding", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                        <%} %>
                        </div>
                    </div>
                    <div class="toolbarArea">
                            <script type="text/javascript">
                                $(document).ready(function() {
                                    $("#passAuding").click(function() {
                                        $('#commentForm').attr('action', '<%=Url.Action("UpdateCommentAuditingStatuses","ManageNews",new {isPass=true}) %>'); $('#commentForm').submit(); return false;
                                    });
                                    $("#noAuding").click(function() {
                                        $('#commentForm').attr('action', '<%=Url.Action("UpdateCommentAuditingStatuses","ManageNews",new {isPass=false}) %>'); $('#commentForm').submit(); return false;
                                    });
                                    $("#deletes").click(function() {
                                        if (confirm('是否删除选中的评论？')) { $('#commentForm').attr('action', '<%=this.Url.Action("DeleteComments", "ManageNews")%>'); $('#commentForm').submit(); return false; }
                                    });
                                });
                                </script>
                            </div>
                            <div id="fragment-1">
                    <table class="tn-table-grid">
                        <tr class="tn-table-grid-header">
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <span class="tn-checkbox">
                                    <input type="checkbox" onclick="checkAll(this,'commentCheckBoxGroup')" />
                                </span>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_Body")%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                作者
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                审核状态
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                发帖日期
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                操作
                            </th>
                        </tr>
                        <%
                            foreach (var comment in ViewData.Model.Records)
                            {%>
                        <tr class="tn-table-grid-row">
                            <td class="tn-border-gray tn-border-bottom tn-width-check">
                                <input type="checkbox" name="commentCheckBoxGroup" class="tn-checkbox" value="<%=comment.CommentID %>" />
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                <a href="<%=SiteUrls.Instance().ShowNews(comment.ThreadID) %>" target="_blank" title="<%=HtmlUtils.StripForPreview(comment.Body)%>">
                                    <%=HtmlUtils.TrimHtml(comment.Body,50)%></a>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                                <%if (comment.UserID > 0)
                                  { %>
                                <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(comment.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                                    <%=comment.Author %></a>
                                <%
                                    }
                                  else
                                  {
                                      Response.Write(comment.Author);
                                  }
                                %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                <%switch (comment.AuditingStatus)
                                  {
                                      case AuditingStatuses.Again:
                                          Response.Write("需再次审核");
                                          break;
                                      case AuditingStatuses.Fail:
                                          Response.Write("未通过");
                                          break;
                                      case AuditingStatuses.Pending:
                                          Response.Write("待审核");
                                          break;
                                      case AuditingStatuses.Success:
                                          Response.Write("已通过");
                                          break;
                                      default:
                                          break;
                                  } %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                <%= Formatter.FormatDate(comment.PostDate)%>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                <a  class="tn-action-text" href="javascript:;" onclick="if (confirm('确定要删除该评论吗？')) {window.location.href='<%=this.Url.Action("DeleteComment", "ManageNews", new { commentID = comment.CommentID })%>'}">
                                    删除 </a>
                            </td>
                        </tr>
                        <%}%>
                    </table>
                    </div>
                    </form>
                    <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
                      {%>
                    <div class="tn-pagination tn-helper-align-center">
                            <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords,ViewData.Model.PageSize,ViewData.Model.PageIndex)%>
                        
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                    </div>
                    <%}%>
                    
                </div>
            </div>


    <script type="text/javascript">
        $(document).ready(function() {
            $("#searchNewsForm").validate({
                rules: {
                    searchUserID: {digits: true }
                },
                messages: {
                    searchUserID: {digits: "请输入非负整数" }
                }
            });

            $("#searchButton").click(function() {
                if (!$("#searchNewsForm").valid()) {
                    return false;
                }
            });
        }); 

    </script>

</asp:content>
