﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<NewsThread>>" %>
<asp:content id="Content1" runat="server" contentplaceholderid="HeaderContent">
  <% ViewData["SubMenuType"] = NewsSubMenus.ManageNews;%>
  <% Html.RenderPartial("Controls/News/NewsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content contentplaceholderid="pageNameContent" runat="server"> 资讯管理 </asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
  <% 
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000));
        TempData["StatusMessageType"] = null;
    }
        %>
  <form id="SearchNewsForm" method="post" action="<%=Url.Action("SearchNews","ManageNews",new {status = (AuditingStatusesForDisplay)ViewData["status"],sectionID=(int?)ViewData["sectionID"]}) %>">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
      <table>
        <tr>
          <th>搜索关键字</th>
          <td><input name="searchBodyKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="searchBodyKeywords"
                                    value="<%=WebUtils.UrlDecode(Html.GetParameterFromRouteDateOrQueryString("key")) %>" /></td>
          <td><input type="submit" class="tn-botton" value="<%=GetResourceString("Button_Search")%>" /></td>
        </tr>
      </table>
    </div>
  </form>
  <div class="spb-manage-news">
    <div class="tn-tabs tn-widget">
      <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatuses)ViewData["status"]==AuditingStatuses.Success){Response.Write("tn-tabs-selected");} %>"> <a href="<%=this.Url.Action("ManageNews", "ManageNews", new { status = AuditingStatuses.Success,key=Html.GetParameterFromRouteDateOrQueryString("key")})%>"> <span>已通过审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatuses)ViewData["status"]==AuditingStatuses.Pending){Response.Write("tn-tabs-selected");} %>"> <a href="<%=this.Url.Action("ManageNews", "ManageNews", new { status = AuditingStatuses.Pending,key=Html.GetParameterFromRouteDateOrQueryString("key")})%>"> <span>待审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatuses)ViewData["status"]==AuditingStatuses.Again){Response.Write("tn-tabs-selected");} %>"> <a href="<%=this.Url.Action("ManageNews", "ManageNews", new { status = AuditingStatuses.Again,key=Html.GetParameterFromRouteDateOrQueryString("key")})%>"> <span>需再审核</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if((AuditingStatuses)ViewData["status"]==AuditingStatuses.Fail){Response.Write("tn-tabs-selected");} %>"> <a href="<%=this.Url.Action("ManageNews", "ManageNews", new { status = AuditingStatuses.Fail,key=Html.GetParameterFromRouteDateOrQueryString("key")})%>"> <span>未通过审核</span></a></li>
      </ul>
      <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <form id="newsForm" method="post">
          <div class="tn-list-header">
            <div class="tn-toolbar-area tn-helper-clearfix">
              <select name="sectionDDL" id="sectionDDL" class="tn-dropdownlist" onchange="window.location.href='<%=this.Url.Action("ManageNews", "ManageNews", new { status = (AuditingStatusesForDisplay)ViewData["status"]})%>&sectionID='+$(this).val();">
                <option value="0">全部栏目</option>
                <%foreach (var toSection in ViewData["allSections"] as List<NewsSection>)
                      {%>
                <option <%if(toSection.SectionID==Convert.ToInt32(Html.GetParameterFromRouteDateOrQueryString("sectionID")))Response.Write("selected=\"selected\""); %>
                                            value="<%=toSection.SectionID %>">
                <%for (int i = 0; i < toSection.Depth; i++) { Response.Write("&nbsp; &nbsp; &nbsp; &nbsp; "); } %>
                <%=toSection.SectionName%></option>
                <%}%>
              </select>
              <%if ((AuditingStatuses)ViewData["status"] != AuditingStatuses.Success)
                { %>
              <%=SPBHtmlHelper.Instance().LinkButton("passAuding","通过审核","javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
              <%}
                if ((AuditingStatuses)ViewData["status"] != AuditingStatuses.Fail)
                {%>
              <%=SPBHtmlHelper.Instance().LinkButton("noAuding", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().LinkButton("SetSiteCategories", "设置栏目", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().LinkButton("deletes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
              <%} if ((AuditingStatuses)ViewData["status"] == AuditingStatuses.Success)
                { %>
              <%=SPBHtmlHelper.Instance().LinkButton("SetTop", "设为置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().LinkButton("CancelTop", "取消置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
              <%} %>
            </div>
          </div>
          <div class="toolbarArea">
            <script type="text/javascript">
                                $(document).ready(function() {
                                    $("#passAuding").click(function() {
                                        $('#newsForm').attr('action', '<%=Url.Action("UpdateNewsAuditingStatuses","ManageNews", new {isPass=true}) %>'); $('#newsForm').submit(); return false;
                                    });
                                    $("#noAuding").click(function() {
                                        $('#newsForm').attr('action', '<%=Url.Action("UpdateNewsAuditingStatuses","ManageNews", new {isPass=false}) %>'); $('#newsForm').submit(); return false;
                                    });
                                    $("#SetSiteCategories").click(function() {
                                        $('#newsForm').attr('action', '<%=Url.Action("Control_EditNewsSection", "ManageNews")%>'); cai(); $('#newsForm').submit(); return false;
                                    });
                                    $("#deletes").click(function() {
                                        if (confirm('是否删除选中的资讯？')) { $('#newsForm').attr('action', '<%=this.Url.Action("DeleteNewss", "ManageNews")%>'); $('#newsForm').submit(); return false; }
                                    });
                                    $("#SetTop").click(function() {
                                        $('#newsForm').attr('action', '<%=Url.Action("UpdateStickyStatuses","ManageNews",new {isSticky=true}) %>'); $('#newsForm').submit(); return false;
                                    });
                                    $("#CancelTop").click(function() {
                                        $('#newsForm').attr('action', '<%=Url.Action("UpdateStickyStatuses","ManageNews",new {isSticky=false}) %>'); $('#newsForm').submit(); return false;
                                    });
                                });

                                function cai() {
                                    $(function() {
                                        $('#newsForm').submit(function(e) {
                                            e.preventDefault();
                                            $('#newsForm').nyroModalManual({
                                                resizeable: true,
                                                width: 300,
                                                height: 300
                                            });
                                            return false;
                                        });
                                    });
                                }  
                                </script>
          </div>
          <div id="fragment-1">
            <table class="tn-table-grid">
              <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'newsCheckBoxGroup')" />
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Subject")%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 录入人 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 所属栏目 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 置顶 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PostDate")%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <%foreach (var thread in ViewData.Model.Records)
                {%>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" class="tn-checkbox" name="newsCheckBoxGroup" value="<%=thread.ThreadID %>" /></td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto"><a target="_blank" href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>"> <%=StringUtils.Trim(thread.Title,23) %></a></td>
                <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,ApplicationIDs.Instance().News()) %>"> <%=thread.Contributor %></a></td>
                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%if (thread.Section != null)
                                                                                          { %>
                  <a target="_blank" href="<%=this.Url.Action("ListNewsForChild", "ChannelNews", new { sectionID = thread.Section.SectionID })%>"> <%=StringUtils.Trim(thread.Section.SectionName,10) %></a>
                  <%} %></td>
                <td class="tn-border-gray tn-border-bottom tn-width-pic"><%if (thread.SpecialOrder == 1)
                                                                           { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                           else
                                                                           { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=Formatter.FormatDate(thread.PostDate)%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap"><span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                menu="#MenuButton_<%=thread.ThreadID %>"> <span class="tn-icon tn-icon-triangle-down"></span><a class="tn-action-text" href="<%=this.Url.Action("EditNews", "ManageNews", new {newsID=thread.ThreadID })%>"> 编辑</a> </span>
                  <div id="MenuButton_<%=thread.ThreadID %>" class="tn-drop-menu ui-widget-content" style="display: none;">
                    <ul class="tn-menu-drop-list">
                      <li class="tn-menu-drop-item"><a class="tn-action-text" href="javascript:;" onclick="if (confirm('确定要删除该资讯吗？')) {window.location.href='<%=this.Url.Action("DeleteNews", "ManageNews", new {newsID=thread.ThreadID }) %>'}"> 删除</a></li>
                      <li class="tn-menu-drop-item"><a class="tn-action-text recommendNewsModal" href="<%=SiteUrls.Instance().RecommendItem( ApplicationIDs.Instance().News(),thread.UserID, thread.ThreadID, thread.Title )%>"> 推荐</a> </li>
                    </ul>
                  </div></td>
              </tr>
              <%}%>
            </table>
          </div>
        </form>
        <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
            {%>
        <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords,ViewData.Model.PageSize,ViewData.Model.PageIndex)%>
          <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
        <%}%>
        <script type="text/javascript">
              $(document).ready(function() {
                  $('.recommendNewsModal').nyroModal({
                      resizeable: true,
                      width: 300,
                      height: 400
                  });
                  $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
              });
                    </script>
      </div>
    </div>
  </div>
</asp:content>
