﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<UserCategory>>" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
相册管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% 
      if (ViewData["GallerySubMenu"] == null)
          ViewData["GallerySubMenu"] = PhotoSubMenu.ManageGallerys;
      Html.RenderPartial("Controls/Photos/GallerySubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
  <% 
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      }     
    
    %>
 <form id="ManageSearchForm" action="" method="Get">
      <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
          <th><%=GetResourceString("Label_KeyWord")%></th>
            <td><input name="KeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="KeyWords" value="<%=WebUtils.UrlDecode(Html.GetParameterFromRouteDateOrQueryString("KeyWords"))%>" /></td>
          <th>用户ID</th>
            <td><input name="UserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="UserID" value="<%=Html.GetParameterFromRouteDateOrQueryString("UserID") %>" /></td>
          <td>

        <input id="searchButton" value="<%=GetResourceString("Button_Search") %>" type="submit" onclick="$('#ManageSearchForm').attr('action','<%=Url.Action("ManageGallery","ManagePhoto") %>');$('#ManageSearchForm').submit(); return false;" />

          </td>
        </table>
        </div>
  </form>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-content tn-widget-content tn-corner-all">
                    <form method="post" id="ManageGalleryForm">      
                        <div class="tn-list-header">
                            <div class="tn-toolbar-area tn-helper-clearfix">
                                    <%=SPBHtmlHelper.Instance().LinkButton("deletes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>                            
                                </div>                                                       
                        </div>  
                        <div class="toolbarArea">
                            <script type="text/javascript">
                                $(document).ready(function() {
                                $("#deletes").click(function() {
                                if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                                    alert("至少选择一个相册！");
                                    return false;
                                }
                                    
                                        if (confirm('确实要删除选中的相册吗？')) { $('#ManageGalleryForm').attr('action', '<%=Url.Action("DeleteGallerys","ManagePhoto", new { returnUrl= Request.RawUrl }) %>'); $('#ManageGalleryForm').submit(); return false; } else { return false; };
                                    });
                                });  
                                </script>
                            </div>                  
 <div id="fragment-1">
   <table class="tn-table-grid">
    <tr class="gridHeader">
      <th class="tn-border-gray tn-border-bottom tn-text-note">
        <input type="checkbox" id="Checkbox1" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
       </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 封面 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 相册名称 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 用户名 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 照片数量 </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 隐私设置</th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 发布日期 </th> 
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
    </tr>
   <%
       if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
       {
           PagingDataSet<UserCategory> PgListGalleries = ViewData.Model as PagingDataSet<UserCategory>;
           IList<UserCategory> IListuserCategory = PgListGalleries.Records;
                          
        %>
  
    <%
        foreach (var userCategory in IListuserCategory)
        {    
        %>
    <tr>    
       <td  class="tn-border-gray tn-border-bottom tn-width-check">
       <input id="checkbox" type="checkbox" class="tn-checkbox" name="CheckBoxGroup" value='<%=string.Format("{0};{1}",userCategory.UserID,userCategory.CategoryID)%>' />
      </td>
      <td class="tn-border-gray tn-border-bottom tn-width-pic"><img  src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(userCategory) %>"/></td>
      <td class="tn-border-gray tn-border-bottom tn-width-auto"><a href="<%=SiteUrls.Instance().UserChannelHome(userCategory.UserID,ApplicationIDs.Instance().Photo()) %>"><%=userCategory.CategoryName %></a></td>
      <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><a href="<%=SiteUrls.Instance().UserDomainHome(userCategory.UserID) %>"><%=UserID2UserNameDictionary.GetUserName(userCategory.UserID) %></a></td>
      <td  class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=userCategory.ItemCount %></td>
      <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap"><% switch (userCategory.PrivacyStatus)
                                                                               {
                                                                                   case PrivacyStatuses.NeedPassword:
                                                                                       Response.Write("凭密码访问");
                                                                                       break;
                                                                                   case PrivacyStatuses.OnlyFriend:
                                                                                       Response.Write("仅好友可见");
                                                                                       break;
                                                                                   case PrivacyStatuses.Privacy:
                                                                                       Response.Write("仅自己可见");
                                                                                       break;
                                                                                   case PrivacyStatuses.Public:
                                                                                       Response.Write("所有人可见");
                                                                                       break;
                                                                                   default:
                                                                                       break;
                                                                               } %>      </td>
     <td  class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%= Formatter.FormatDate(userCategory.DateCreated) %></td>
          <td  class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
          <a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Photo(), userCategory.UserID,userCategory.CategoryID,userCategory.CategoryName,"112001")%>"  name="GalleryManagerCommend" > 推荐</a>
            <a onclick="if ( !confirm('是否删除选中的图片？') ) {return false; }"
                            href="<%=Url.Action("DeleteGallery", "ManagePhoto", new {categoryID=userCategory.CategoryID,userID=userCategory.UserID,pageIndex = PgListGalleries.PageIndex }) %>"
                            >删除</a>
      </td>
    </tr>
         <%}
          %> <%} %> 
  </table>  
  <div class="tn-pagination tn-helper-align-center">
      <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex));   %>
    </div>
</div>
</form>
  </div>
  </div>
<script type="text/javascript">
    $(document).ready(function() {
        $('a[name="GalleryManagerCommend"]').nyroModal({
            resizeable: true,
            height: 450,
            width: 400,
            endRemove: function(elts, settings) {
            }
        });

        $("#ManageSearchForm").validate({
            rules: {
                UserID: { digits: true }
            },
            messages: {
                UserID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#ManageSearchForm").valid()) {
                return false;
            }
        });


    });
        </script>
 </asp:content>
