﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content contentplaceholderid="pageNameContent" runat="server">
照片管理
</asp:content>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <% 
        if (ViewData["GallerySubMenu"] == null)
            ViewData["GallerySubMenu"] = PhotoSubMenu.ManagePhotos;
        Html.RenderPartial("Controls/Photos/GallerySubMenu.ascx", ViewData); 
    %>
</asp:content>
<asp:content id="Content3" contentplaceholderid="wideContent" runat="server">
    <% 
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            TempData["StatusMessageType"] = null;
        }

        AuditingStatusesForDisplay AuditingStatuses = AuditingStatusesForDisplay.Pending;
        if (ViewData["status"] != null)
            AuditingStatuses = (AuditingStatusesForDisplay)ViewData["status"];
        int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
    %>
    <form id="ManageSearchForm" action="" method="Get">
      <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
        <tr>
          <th><%=GetResourceString("Label_KeyWord")%></th>
            <td><input name="CommentKeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentKeyWords" value="<%=WebUtils.UrlDecode(Html.GetParameterFromRouteDateOrQueryString("CommentKeyWords"))%>" /></td>
          <th>用户ID</th>
            <td><input name="CommentUserID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="CommentUserID" value="<%=Html.GetParameterFromRouteDateOrQueryString("CommentUserID")%>" />
          </td>
          <td>
          <select name="status" class="tn-dropdownlist" id="status">
          <option value="-1">请选择</option>
            <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
              已通过审核</option>
            <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
              未通过审核</option>
            <option value="<%=(int)AuditingStatusesForDisplay.Again %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Again) Response.Write("selected"); %>>
              需再审核</option>
            <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
              待审核</option>
            </select>
            </td>
            <td>
            
                        <input id="searchButton" value="<%=GetResourceString("Button_Search") %>" type="submit" onclick="$('#ManageSearchForm').attr('action', '<%=Url.Action("ManageThreads", "ManagePhoto") %>'); $('#ManageSearchForm').submit(); return false;" />

                                    </td>
                                    </tr>
        </table>
        </div>
  </form>
    <div class="tn-tabs tn-widget">
<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
  <li class="tn-widget-content tn-border-gray tn-border-trl <% if( (int)AuditingStatuses==-1) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ManageThreads","ManagePhoto",new{ status = -1,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"
                                    target="_self" style="cursor: pointer"><span>全部照片</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Success) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ManageThreads","ManagePhoto",new{ status = AuditingStatusesForDisplay.Success,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>"
                                    target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Pending) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ManageThreads","ManagePhoto",new{ status = AuditingStatusesForDisplay.Pending,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")} )%>">
                                    <span>待审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Again) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ManageThreads","ManagePhoto",new{ status = AuditingStatusesForDisplay.Again,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>">
                                    <span>需再审核</span></a></li>
                            <li class="tn-widget-content tn-border-gray tn-border-trl <% if(AuditingStatuses==AuditingStatusesForDisplay.Fail) Response.Write("tn-tabs-selected"); %>">
                                <a href="<%=Url.Action("ManageThreads","ManagePhoto",new{ status = AuditingStatusesForDisplay.Fail,CommentKeyWords=Request.QueryString.Get("CommentKeyWords"),CommentUserID=Request.QueryString.Get("CommentUserID")}) %>">
                                    <span>未通过审核</span></a></li>
                        </ul>
<div class="tn-tabs-panel tn-widget-content tn-border-gray">
                            <form id="ManageGalleryForm" method="post">
                            <div class="tn-list-header">
                            <div class="tn-toolbar-area tn-helper-clearfix">
                            <%=SPBHtmlHelper.Instance().LinkButton("passAuding","通过审核","javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Accept, TextIconLayout.IconText) %>
                            <%=SPBHtmlHelper.Instance().LinkButton("noAuding", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("SetSiteCategories", "设置站点类别", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("deletes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("SetEssential", "设为精华", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("CancelEssential", "取消精华", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("SetTop", "设为置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("CancelTop", "取消置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
                            </div>
                            </div>
                            <div class="toolbarArea">
                            <script type="text/javascript">
                                $(document).ready(function() {
                                    $("#passAuding").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("UpdateThreadAuditingStatus","ManagePhoto", new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Success }) %>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#noAuding").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("UpdateThreadAuditingStatus","ManagePhoto", new { returnUrl= Request.RawUrl,auditingStatus = SpaceBuilder.Common.AuditingStatuses.Fail }) %>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#SetSiteCategories").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("Control_SetSiteCategories", "ManagePhoto")%>'); cai(); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#deletes").click(function() {
                                        if (!VerifyChoose())
                                            return false;
                                        if (confirm('确认要删除这些图片吗？')) { $('#ManageGalleryForm').attr('action', '<%=Url.Action("DeleteThreads","ManagePhoto", new { returnUrl= Request.RawUrl }) %>'); $('#ManageGalleryForm').submit(); return false; } else { return false; };
                                    });
                                    $("#SetEssential").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("SetEssential", "ManagePhoto", new { returnUrl = Request.RawUrl }) %>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#CancelEssential").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("CancelEssential", "ManagePhoto", new { returnUrl = Request.RawUrl }) %>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#SetTop").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("SetTop", "ManagePhoto", new { returnUrl = Request.RawUrl })%>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                    $("#CancelTop").click(function() {
                                    if (!VerifyChoose())
                                        return false;
                                        $('#ManageGalleryForm').attr('action', '<%=Url.Action("CancelTop", "ManagePhoto", new { returnUrl = Request.RawUrl })%>'); $('#ManageGalleryForm').submit(); return false;
                                    });
                                });

                                function VerifyChoose() {
                                    if ($("input[name='CheckBoxGroup']:checked").length <= 0) {
                                        alert("至少选择一个照片！");
                                        return false;
                                    }
                                    return true;
                                }

                                function cai() {
                                    $(function() {
                                        $('#ManageGalleryForm').submit(function(e) {
                                            e.preventDefault();
                                            $('#ManageGalleryForm').nyroModalManual({
                                                resizeable: true
                                            });
                                            return false;
                                        });
                                    });
                                }  
                                </script>
                            </div>
                            <div id="fragment-1">
                                <% Html.RenderAction<ManagePhotoController>(b => b.Control_ListThreads((AuditingStatusesForDisplay)AuditingStatuses, pageIndex)); %>
                            </div>
                            </form>
                        </div>
    </div>
    
        <script type="text/javascript">
            $(document).ready(function() {
                $("#ManageSearchForm").validate({
                    rules: {
                        CommentUserID: { digits: true }
                    },
                    messages: {
                        CommentUserID: { digits: "请输入非负整数" }
                    }
                });

                $("#searchButton").click(function() {
                    if (!$("#ManageSearchForm").valid()) {
                        return false;
                    }
                });
            }); 

    </script> 
</asp:content>
