﻿<%@ Page Language="C#"    Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string, ActivityItemSettings>>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeaderContent" runat="server">
      <% 
        ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageRule;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ActivitySettings;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:Content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  动态设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="ActivitySettings"
</asp:content>
<asp:Content ContentPlaceHolderID="wideContent" runat="server">
    <%
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            if (messageData.MessageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData.MessageType, messageData.MessageContent, 3000));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
            TempData["StatusMessageData"] = null;
        }

    %>
    <form action="<%=Url.Action("UpdateActivitySettings", "ManageSettings")%>" method="post">
 <div class="tn-tabs tn-widget">
        <div class="tn-tabs-panel tn-widget-content">
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>设置默认允许发送的个人动态</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">你可以设置默认哪些动作发生后，将会体现在用户朋友的好友动态里，让用户的好友了解到他的动态。</p>
            <table width="800" cellpadding="3" cellspacing="5">
                    <%
                        Dictionary<string, ActivityItemSettings> globalActivitySettings = ViewData.Model;
                        Dictionary<string, ActivityItem> ActivityItems = null;
                        if (ViewData["ActivityItems"] != null)
                        { ActivityItems = ViewData["ActivityItems"] as Dictionary<string, ActivityItem>; }
                        string str = "<input type=\"checkbox\" class=\"tn-checkbox\" id=\"{0}\" name=\"{1}\" value=\"true\" {2} /><label for=\"{3}\">{4}</label>";
                        int i = 1;
                        Response.Write("<tr>");
                        string strChecked = string.Empty;
                        foreach (KeyValuePair<string, ActivityItem> item in ActivityItems)
                        {
                            Response.Write("<td>");

                            if (globalActivitySettings[item.Value.ItemKey].IsAllowSending)
                                strChecked = "checked=\"checked\"";
                            else
                                strChecked = string.Empty;

                            Response.Write(string.Format(str, "Send_" + item.Value.ItemKey, "Send_" + item.Value.ItemKey, strChecked, "Send_" + item.Value.ItemKey, item.Value.ItemName));

                            if (i % 3 == 0)
                                Response.Write("</td></tr><tr>");
                            else
                                Response.Write("</td>");
                            i++;
                        }
                        Response.Write("</tr>");
                    %>
                </table>
          </div>
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>设置默认允许接收的朋友动态</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">你可以设置用户默认接收好友的哪些动作，会体现在用户的好友动态里，让用户了解到好友的动态。</p>
             <table width="800" cellpadding="3" cellspacing="5">
                    <%
                        i = 1;
                        Response.Write("<tr>");
                        strChecked = string.Empty;
                        foreach (KeyValuePair<string, ActivityItem> item in ActivityItems)
                        {
                            Response.Write("<td>");

                            if (globalActivitySettings[item.Value.ItemKey].IsAllowReceiving)
                                strChecked = "checked=\"checked\"";
                            else
                                strChecked = string.Empty;

                            Response.Write(string.Format(str, "Rece_" + item.Value.ItemKey, "Rece_" + item.Value.ItemKey, strChecked, "Rece_" + item.Value.ItemKey, item.Value.ItemName));

                            if (i % 3 == 0)
                                Response.Write("</td></tr><tr>");
                            else
                                Response.Write("</td>");
                            i++;
                        }
                        Response.Write("</tr>");
        
                    %>
                     <tr>
                <td colspan="3">&nbsp;</td>
              </tr>
                     <tr>
                <td colspan="3">
 <input name="updateButton" type="submit"  id="updateButton" value="更新动态设置" /> &nbsp;
                    <input id="Reset1" type="reset" value="重 置"  />                </td>
              </tr>
                </table>
          </div>
        </div>
      </div>
            <%--<div class="ui-tabs-panel">
                <div class="commonTitle">
                    设置默认允许发送的个人动态</div>
                <div class="description">
                    你可以设置默认哪些动作发生后，将会体现在用户朋友的好友动态里，让用户的好友了解到他的动态。</div>
                <table class="editor" width="800" cellpadding="3" cellspacing="5">
                    <%
                        Dictionary<string, ActivityItemSettings> globalActivitySettings = ViewData.Model;
                        Dictionary<string, ActivityItem> ActivityItems = null;
                        if (ViewData["ActivityItems"] != null)
                        { ActivityItems = ViewData["ActivityItems"] as Dictionary<string, ActivityItem>; }
                        string str = "<input type=\"checkbox\" id=\"{0}\" name=\"{1}\" value=\"true\" {2} /><label for=\"{3}\">{4}</label>";
                        int i = 1;
                        Response.Write("<tr>");
                        string strChecked = string.Empty;
                        foreach (KeyValuePair<string, ActivityItem> item in ActivityItems)
                        {
                            Response.Write("<td nowrap=\"nowrap\" style=\"width: 25%\">");

                            if (globalActivitySettings[item.Value.ItemKey].IsAllowSending)
                                strChecked = "checked=\"checked\"";
                            else
                                strChecked = string.Empty;

                            Response.Write(string.Format(str, "Send_" + item.Value.ItemKey, "Send_" + item.Value.ItemKey, strChecked, "Send_" + item.Value.ItemKey, item.Value.ItemName));

                            if (i % 3 == 0)
                                Response.Write("</td></tr><tr>");
                            else
                                Response.Write("</td>");
                            i++;
                        }
                        Response.Write("</tr>");
                    %>
                </table>
                <div class="commonTitle">
                    设置默认允许接收的朋友动态</div>
                <div class="description">
                    你可以设置用户默认接收好友的哪些动作，会体现在用户的好友动态里，让用户了解到好友的动态</div>
                <table class="editor" width="800" cellpadding="3" cellspacing="5">
                    <%
                        i = 1;
                        Response.Write("<tr>");
                        strChecked = string.Empty;
                        foreach (KeyValuePair<string, ActivityItem> item in ActivityItems)
                        {
                            Response.Write("<td nowrap=\"nowrap\" style=\"width: 25%\">");

                            if (globalActivitySettings[item.Value.ItemKey].IsAllowReceiving)
                                strChecked = "checked=\"checked\"";
                            else
                                strChecked = string.Empty;

                            Response.Write(string.Format(str, "Rece_" + item.Value.ItemKey, "Rece_" + item.Value.ItemKey, strChecked, "Rece_" + item.Value.ItemKey, item.Value.ItemName));

                            if (i % 3 == 0)
                                Response.Write("</td></tr><tr>");
                            else
                                Response.Write("</td>");
                            i++;
                        }
                        Response.Write("</tr>");
        
                    %>
                </table>
                <div style="text-align:center">
                <br />
                    <input name="updateButton" type="submit"  id="updateButton" value="更新动态设置" /> &nbsp;
                    <input id="Reset1" type="reset" value="重 置"  />
                </div>
            </div>--%>
      
    </form>
</asp:Content>