﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.SiteSetting;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.EmailSetting;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server"> Email设置 </asp:content>
<asp:content contentplaceholderid="setPageID" runat="server"> id="EmailHolderSetting" </asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      SiteSettings setting = null;
      if (ViewData["SiteSetting"] != null)
          setting = ViewData["SiteSetting"] as SiteSettings;
    %>
  <form id="EmailHolderForm" method="post" action="<%=SPBUrlHelper.Action("UpdateSiteSetting", "ManageSettings")%>">
    <div class="tn-form-box">
      <table class="commonFormArea" cellspacing="1" cellpadding="4" width="100%">
        <tr>
          <th> 启用Email： </th>
          <td><input class="tn-radiobutton" type="radio" name="EnableEmail" value="True" <%if(setting.EnableEmail) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input class="tn-radiobutton" type="radio" name="EnableEmail" value="False" <%if(!setting.EnableEmail) Response.Write("checked=\"checked\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 每批邮件发送限制量： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 80px" maxlength="5" name="EmailThrottle"
                                            value="<%=setting.EmailThrottle %>" />
            <span class="tn-text-note">此数量由您所选择的smtp服务器一次所允许发送的数目而决定的</span></td>
        </tr>
        <tr>
          <th> SMTP服务器： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="SmtpServer"
                                            value="<%=setting.SmtpServer %>" />
            <span class="tn-text-note">SMTP服务器地址</span></td>
        </tr>
        <tr>
          <th> 使用SSL： </th>
          <td><input class="tn-radiobutton" type="radio" name="SmtpServerEnableSsl" value="True" <%if(setting.SmtpServerEnableSsl) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input class="tn-radiobutton" type="radio" name="SmtpServerEnableSsl" value="False" <%if(!setting.SmtpServerEnableSsl) Response.Write("checked=\"checked\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 端口号： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 80px" maxlength="64" name="SmtpServerPort"
                                            value="<%=setting.SmtpServerPort %>" /></td>
        </tr>
        <tr>
          <th> 需要身份验证： </th>
          <td><input class="tn-radiobutton" type="radio" name="SmtpServerRequiredLogin" value="True" <%if(setting.SmtpServerRequiredLogin) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input class="tn-radiobutton" type="radio" name="SmtpServerRequiredLogin" value="False" <%if(!setting.SmtpServerRequiredLogin) Response.Write("checked=\"checked\""); %> />
            否&nbsp; </td>
        </tr>
        <tr>
          <th> 用户名： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" id="SmtpServerUserName"
                                            name="SmtpServerUserName" value="<%=setting.SmtpServerUserName %>" /></td>
        </tr>
        <tr id="SmtpServerUserNamePostfixTr" style="display: none">
          <th> 域名后缀： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" id="SmtpServerUserNamePostfix" name="SmtpServerUserNamePostfix"
                                            value="<%=setting.SmtpServerUserNamePostfix %>" />
            <span class="tn-text-note">示例：@gmail.com</span></td>
        </tr>
        <tr>
          <th> 密码： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="SmtpServerPassword"
                                            value="<%=setting.SmtpServerPassword.Replace("\"","&quot;") %>" /></td>
        </tr>
        <tr>
          <th> 发件人地址设置： </th>
          <td><input class="tn-radiobutton" type="radio" value="<%=(int)EmailSendFromTypes.SMTPLoginAddress %>" name="EmailSendFromType" id="EmailSendFromType-SMTPLoginAddress" <%if (setting.EmailSendFromType == EmailSendFromTypes.SMTPLoginAddress) Response.Write("checked=\"checked\""); %> class="radiobutton" />
            <label for="EmailSendFromType-SMTPLoginAddress">强制使用SMTP登录邮件地址</label>
            <input class="tn-radiobutton" type="radio" value="<%=(int)EmailSendFromTypes.OriginalSendAddress %>" name="EmailSendFromType" id="EmailSendFromType-OriginalSendAddress" <%if (setting.EmailSendFromType == EmailSendFromTypes.OriginalSendAddress) Response.Write("checked=\"checked\""); %> class="radiobutton" />
            <label for="EmailSendFromType-OriginalSendAddress">原始发件人邮件地址</label>
            <span class="tn-text-note">对于Gmail等邮箱必须使用SMTP登录邮件地址 </span></td>
        </tr>
        <tr>
          <th> 管理员Email地址： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="AdminEmailAddress"
                                            value="<%=setting.AdminEmailAddress %>" />
            <span class="tn-text-note">用于邮件内容中的管理员邮箱地址</span></td>
        </tr>
        <tr>
          <th> 不允许回复 Email 地址： </th>
          <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="NoReplyEmailAddress"
                                            value="<%=setting.NoReplyEmailAddress %>" />
            <span class="tn-text-note">用于邮件内容中的系统Email地址，但会注明此邮箱不允许回复。</span></td>
        </tr>
        <tr>
          <th> </th>
          <td><input id="saveButton" type="submit" value="保存" />
            &nbsp;
            <input id="Reset5" type="reset" value="重置" /></td>
        </tr>
      </table>
      <script type="text/javascript">
                            $(document).ready(function() {
                                $("#EmailHolderForm").validate({
                                    rules: {
                                        AdminEmailAddress: { required: true, email: true },
                                        SmtpServer: { required: true },
                                        SmtpServerPort: { required: true },
                                        SmtpServerUserNamePostfix: { required: "#SmtpServerUserNamePostfixTr:visible" }
                                    },
                                    messages: {
                                        AdminEmailAddress: { required: "请填写管理员email地址", email: "请填写正确的Email地址" },
                                        SmtpServer: { required: "请填写管理员email地址" },
                                        SmtpServerPort: { required: "请填写SMTP服务器端口号" },
                                        SmtpServerUserNamePostfix: { required: "请填写域名后缀" }
                                    }
                                });

                                $("#saveButton").click(function() {
                                    if (!$("#EmailHolderForm").valid()) {
                                        return false;
                                    }
                                });
                                $("#SmtpServerUserName").blur(function() {
                                    if ($('#SmtpServerUserName').val().indexOf('@') > 0) {
                                        $('#SmtpServerUserNamePostfixTr').hide();
                                    }
                                    else {
                                        $('#SmtpServerUserNamePostfixTr').show();
                                    }
                                }).blur();
                            });  
                        </script>
    </div>
  </form>
  <div class="tn-collapsible tn-collapsible-closed">
    <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
      <h4 class="tn-helper-reset"> <span>测试Email设置</span></h4>
      <span class="tn-icon tn-switch tn-icon-collapse-close"></span> </div>
    <div style="" class="tn-collapsible-content">
      <form id="TestEmailHolderForm" method="post" action="<%=Url.Action("TestEmailSettingResult","ManageSettings")%>">
        <div class="tn-form-box">
          <table>
            <% if (setting.EmailSendFromType == EmailSendFromTypes.OriginalSendAddress)
                                   { %>
            <tr>
              <th> 发件人： </th>
              <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="sender"
                                            value=""/></td>
            </tr>
            <%} %>
            <tr>
              <th> 收件人： </th>
              <td><input type="text"  id="receiver" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="receiver"
                                            value=""/></td>
            </tr>
            <tr>
              <th> Email标题： </th>
              <td><input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" maxlength="64" name="subject"
                                            value=""/>
                <span class="tn-text-note">Email标题最大长度不超过30个字</span></td>
            </tr>
            <tr>
              <th> Email内容： </th>
              <td><textarea name="body" id="body" cols="60" rows="8" class="tn-textarea tn-input-longest tn-border-gray"></textarea>
                <span class="tn-text-note">内容允许输入的最大字数为：3000字</span></td>
            </tr>
            <tr>
              <th> </th>
              <td><input id="testEmail" type="submit"  value="测试" /></td>
            </tr>
          </table>
          <script type="text/javascript" rel="forceLoad" >
                           $(document).ready(function() {
                               $("#TestEmailHolderForm").validate({
                                   rules: {
                                       sender: { required: true, email: true },
                                       receiver: { required: true, email: true },
                                       subject: { required: true, maxBlength: 30 },
                                       body: { required: true, maxBlength: 3000 }
                                   },
                                   messages: {
                                       sender: { required: "发送人不能为空", email: "请输入正确的Email格式" },
                                       receiver: { required: "收件人不能为空", email: "请输入正确的Email格式" },
                                       subject: { required: "请填写email标题", maxBlength: "email标题不允许超过30个字" },
                                       body: { required: "请填写email内容", maxBlength: "email内容不允许超过3000字" }

                                   }
                               });

                               $("#testEmail").click(function() {
                                   if (!$("#TestEmailHolderForm").valid()) {
                                       return false;
                                   }
                               });
                           }); 
                       </script>
        </div>
      </form>
    </div>
  </div>
</asp:content>
