﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% 
        ViewData["SystemSettingMenu"] = SystemSettingMenu.SiteSetting;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.SiteInfo;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server"> 全局设置 </asp:content>
<asp:content contentplaceholderid="setPageID" runat="server"> id="GlobalSetting" </asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      SiteSettings setting = null;
      if (ViewData["SiteSetting"] != null)
          setting = ViewData["SiteSetting"] as SiteSettings;
      Dictionary<string, string> dir = ViewData["languages"] as Dictionary<string, string>;
      Dictionary<int, CodeItem> TimeZoneList = ViewData["TimeZone"] as Dictionary<int, CodeItem>;
    %>
  <form id="GlobalSettingForm"  method="post" action="<%=SPBUrlHelper.Action("UpdateSiteSetting", "ManageSettings")%>">
    <div class="tn-form-box">
      <table>
        <tr>
          <th> 站点名称： </th>
          <td><input type="text" class="tn-textbox tn-input-longest tn-border-gray" name="SiteName" value="<%=setting.SiteName%>"
                                    /></td>
        </tr>
        <tr>
          <th> 页面头信息的描述： </th>
          <td><div class="tn-textarea-wrap"><textarea id="SearchMetaDescription" cols="90" rows="2" name="SearchMetaDescription" class="tn-textarea tn-input-longest tn-border-gray"><%=setting.SearchMetaDescription%></textarea>
              <span style="display:none"></span></div>
          </td>
        </tr>
        <tr>
          <th> 页面头信息的关键字： </th>
          <td><div class="tn-textarea-wrap"><textarea id="SearchMetaKeywords" cols="90" rows="2" name="SearchMetaKeywords" class="tn-textarea tn-input-longest tn-border-gray"><%=setting.SearchMetaKeywords%></textarea>
          <span style="display:none"></span></div>
          </td>
        </tr>
        <tr>
          <th> 页脚链接： </th>
          <td><div class="tn-textarea-wrap"><textarea id="ChannelFooterNote" cols="90" rows="3" name="ChannelFooterNote" class="tn-textarea tn-input-longest tn-border-gray"><%=setting.ChannelFooterNote%></textarea>
          <span style="display:none"></span></div>
          </td>
        </tr>
        <tr>
          <th>&nbsp;</th>
          <td><span class="tn-text-note">允许Html</span></td>
        </tr>
        <tr>
          <th> 备案信息： </th>
          <td><div class="tn-textarea-wrap"><textarea id="SiteRegisterInformation" cols="90" rows="2" name="SiteRegisterInformation"
                                    class="tn-textarea tn-input-longest tn-border-gray"><%=setting.SiteRegisterInformation%></textarea>
                                    <span style="display:none"></span></div>
          </td>
        </tr>
        <tr>
          <th>&nbsp;</th>
          <td><span class="tn-text-note">允许Html</span></td>
        </tr>
        <tr>
          <th> 统计脚本： </th>
          <td><div class="tn-textarea-wrap"><textarea id="SiteStatisticsScript" cols="90" rows="2" name="SiteStatisticsScript"
                                    class="tn-textarea tn-input-longest tn-border-gray"><%=setting.SiteStatisticsScript%></textarea>
                                    <span style="display:none"></span></div></td>
        </tr>
        <tr>
          <th> </th>
          <td><span class="tn-text-note">用于站点统计的JavaScript脚本</span></td>
        </tr>
        <tr>
          <th> 是否启用国际化： </th>
          <td><input name="EnableInternationalization" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableMultilingual) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input name="EnableInternationalization" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableMultilingual) Response.Write("checked=\"true\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 设置站点默认语言： </th>
          <td><%= SPBHtmlHelper.Instance().ShowDropDownList<string, string>("defaultLanguage", dir, new RouteValueDictionary { { "Class", "dropDownList" } }, setting.DefaultLanguage)%></td>
        </tr>
        <tr>
          <th> 匿名用户使用简洁首页： </th>
          <td><input name="EnableSimpleHomepageForAnonymous" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableSimpleHomepageForAnonymous) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input name="EnableSimpleHomepageForAnonymous" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableSimpleHomepageForAnonymous) Response.Write("checked=\"true\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 是否允许匿名用户浏览： </th>
          <td><input name="EnableAnonymousBrowse" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableAnonymousBrowse) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input name="EnableAnonymousBrowse" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableAnonymousBrowse) Response.Write("checked=\"checked\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 是否启用广告： </th>
          <td><input name="EnableAD" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableAD) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input name="EnableAD" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableAD) Response.Write("checked=\"checked\""); %> />
            否 </td>
        </tr>        
        <tr>
          <th> 是否允许用户在个人空间投放广告： </th>
          <td><input name="EnableUserAD" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableUserAD) Response.Write("checked=\"checked\""); %>
                                    onclick="if(!confirm('注意：如果允许空间投放广告,则会给站点带来潜在的威胁！\n你确定要允许吗？')){ return false; }" />
            是
            &nbsp;
            <input name="EnableUserAD" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableUserAD) Response.Write("checked=\"checked\""); %> />
            否
            &nbsp; <span class="tn-text-note">注意：如果允许空间投放广告，用户就有执行任何JavaScript的权限！</span></td>
        </tr>
        <tr>
          <th> 是否允许群主在群组内投放广告： </th>
          <td><input name="EnableClubAD" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableClubAD) Response.Write("checked=\"checked\""); %>
                                    onclick="if(!confirm('注意：如果允许群组投放广告,则会给站点带来潜在的威胁！\n你确定要允许吗？')){ return false; }" />
            是
            &nbsp;
            <input name="EnableClubAD" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableClubAD) Response.Write("checked=\"checked\""); %> />
            否&nbsp;
            &nbsp; <span class="tn-text-note">注意：如果允许群组投放广告，用户就有执行任何JavaScript的权限！</span></td>
        </tr>
        <tr>
          <th> 是否启用FreeHome： </th>
          <td><input name="EnableFreeHome" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableFreeHome) Response.Write("checked=\"checked\""); %>
                                    onclick="if(!confirm('注意：如果启用FreeHome将不能对站点首页进行自定义布局！\n你确定要允许吗？')){ return false; }" />
            是
            &nbsp;
            <input name="EnableFreeHome" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableFreeHome) Response.Write("checked=\"checked\""); %> />
            否&nbsp;
            &nbsp; <span class="tn-text-note">注意：如果启用FreeHome将不能对站点首页进行自定义布局！</span></td>
        </tr>
        <tr>
          <th> 是否启用积分： </th>
          <td><input name="EnablePoints" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnablePoints) Response.Write("checked=\"checked\""); %> />
            是
            &nbsp;
            <input name="EnablePoints" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnablePoints) Response.Write("checked=\"checked\""); %> />
            否 </td>
        </tr>
        <tr>
          <th> 设置积分税点： </th>
          <td><input name="TransactionTax" id="TransactionTax" type="text" class="tn-textbox tn-input-short tn-border-gray" value="<%=setting.TransactionTax%>"/>
            <b>%</b> &nbsp;&nbsp; <span class="tn-text-note" title="如：下载文件、论坛附件，礼品兑换时">用户在进行<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>交易时，所扣的税点！<b>注意：</b>税点的值需在0-100之间！</span></td>
        </tr>
        <tr>
          <th> 设置站点默认时区： </th>
          <td><%= SPBHtmlHelper.Instance().ShowDropDownList<int, string>("TimeZoneListDefault", TimeZoneList.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "dropDownList" } }, setting.SiteTimezone)%></td>
        </tr>
        <tr>
          <th> 设置服务器时区： </th>
          <td><%= SPBHtmlHelper.Instance().ShowDropDownList<int, string>("TimeZoneListServer", TimeZoneList.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "dropDownList" } }, setting.ServerTimezone)%></td>
        </tr>
        <tr>
          <th> 当前站点皮肤： </th>
          <td><%                             
                                    ThemeAppearance themeAppearance = Themes.GetThemeAppearance(PresentAreaIDs.Instance().Channel(), setting.SiteTheme, setting.SiteThemeAppearance, false, false);
                                    if (themeAppearance != null)
                                        Response.Write(themeAppearance.Title);
                                    else
                                    {
                                        Response.Write("默认");
                                    }                                                
                                %>
            &nbsp; &nbsp; <a href="<%=Url.Action("ModifyHome", "Channel")%>" target="_blank" >更新皮肤</a></td>
        </tr>
        <tr>
          <th>&nbsp;</th>
          <td><input id="Submit1" type="submit"  value="<%=GetResourceString("Button_Save")%>" />
            &nbsp;
            <input id="Reset1"  type="reset" value="<%=GetResourceString("Button_Reset")%>" /></td>
        </tr>
      </table>
      <script type="text/javascript" rel="forceLoad">
                    $(document).ready(function() {
                        $("#GlobalSettingForm").validate({
                            rules: {
                                TransactionTax: { required: true, digits: true }
                            },
                            messages: {
                                TransactionTax: { digits: "请输入非负整数" }
                            }
                        });

                        $("#Submit1").click(function() {
                            if (!$("#GlobalSettingForm").valid()) {
                                return false;
                            }
                        });
                    }); 
                </script>
    </div>
  </form>
</asp:content>
