﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<List<IndexFileReport>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <%  ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageTool;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.RebuildIndex;%>
    <% Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  重建索引
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="IndexsReport"
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
  <div class="tn-tabs tn-widget">
        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                    <%
                        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                        if (statusMessageData != null)
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                            statusMessageData = null;
                        }
                    %>
                      <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 索引名称</th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 内容</th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 索引文件路径 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note">索引文件大小 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 上次更新时间 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                </tr>
                    <%
                        foreach (var indexFileReport in ViewData.Model)
                        {
                    %>
                      <tr class="tn-table-grid-row">
       <td class="tn-border-gray tn-border-bottom tn-nowrap">
        <%=indexFileReport.IndexFileDirectory%>
                            索引状态
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
       <%=string.Join(" , ", indexFileReport.SearchNames)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
       <%=indexFileReport.PhysicalIndexDirectory%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
        <%=(indexFileReport.IndexFileSize == 0L)? "--" : Formatter.FormatFriendlyFileSize(indexFileReport.IndexFileSize)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
        <%=(indexFileReport.LastModified == DateTime.MinValue) ? "--" : Formatter.FormatFriendlyDate(indexFileReport.LastModified)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
        <a href="<%=SPBUrlHelper.Action("RebuildIndex", "ManageSettings", new RouteValueDictionary {{ "indexFileDirectory" , indexFileReport.IndexFileDirectory }})%>">
        重建
        </a>
        </td>
        </tr>

        <%
            }
        %>
            
   </table>
   </div>
   </div>
</asp:content>
