﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<int,SpaceBuilder.Common.Application>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.AboutInterFace;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageApplications;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
 应用管理
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
      <div class="tn-tabs tn-widget">

        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <div class="description">
          <h4> 更新统计的内容包括：</h4>
          <p> a) 应用内的统计信息，记录在表spb_Applications中；</p>
          <p> b) 如果使用了站点类别服务，还需定期计算应用在站点类别的统计信息，记录在表spb_SiteCategories中；</br>
          </p>
          <p> c) 如果使用了地区统计，还需定期计算应用在地区的统计信息；</p>
          <p> d) 如果应用具有综合积分，则需要定期计算其综合积分；</p>
         
        </div>
        <%
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
            if (statusMessageData != null)
            {
                if (statusMessageData.MessageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 3000, false));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                statusMessageData = null;
            }
                %>
         <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
         <%=SPBHtmlHelper.Instance().LinkButton("createButton", "更新所有应用统计", Url.Action("CalculateStatistics", "ManageSettings"), ButtonSizes.Default, HighlightStyles.Default)%>
         </div>
         </div>
        
        
         <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">  应用名称 </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> 内容项总数 </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> 24小时新增 </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
          </tr>
          <%  
              foreach (Application application in ViewData.Model.Values)
              {
                  if (application.ApplicationID == ApplicationIDs.Instance().Friend())
                      continue;
                    %>
           <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=application.GetMultilingualApplicationName(CurrentUserLanguage) %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=application.TotalCount%> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=application.CountInPast24Hours %> </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (application.IsEnabled)
                                                                 { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept));}
                                  else
                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross));}%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=Url.Action("CalculateStatistics","ManageSettings",new{ applicationID = application.ApplicationID }) %>"
                                name="CalculateStatisticsButton">更新统计</a>
              <% if (application.ApplicationID != ApplicationIDs.Instance().User())
                 { %>
              <a href="<%=Url.Action("UpdateEnabledStatus","ManageSettings",new{ applicationID = application.ApplicationID,isEnabled=!application.IsEnabled }) %>"
                                name="SetIsEnabledButton">
              <% if (application.IsEnabled) Response.Write("禁用"); else Response.Write("启用"); %>
              </a>
              <%} %>
            </td>
          </tr>
          <%}  %>
        </table>
      </div>
  </div>
</asp:content>
